/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsAsyncClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.AssetInstance;
import software.amazon.awssdk.services.outposts.model.ListAssetInstancesRequest;
import software.amazon.awssdk.services.outposts.model.ListAssetInstancesResponse;

public class ListAssetInstancesPublisher
implements SdkPublisher<ListAssetInstancesResponse> {
    private final OutpostsAsyncClient client;
    private final ListAssetInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssetInstancesPublisher(OutpostsAsyncClient client, ListAssetInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssetInstancesPublisher(OutpostsAsyncClient client, ListAssetInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssetInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssetInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetInstance> assetInstances() {
        Function<ListAssetInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetInstances() != null) {
                return response.assetInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssetInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssetInstancesResponseFetcher
    implements AsyncPageFetcher<ListAssetInstancesResponse> {
        private ListAssetInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssetInstancesResponse> nextPage(ListAssetInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListAssetInstancesPublisher.this.client.listAssetInstances(ListAssetInstancesPublisher.this.firstRequest);
            }
            return ListAssetInstancesPublisher.this.client.listAssetInstances((ListAssetInstancesRequest)((Object)ListAssetInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

