/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventTrackerResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeEventTrackerResponse.Builder, DescribeEventTrackerResponse> {
    private static final SdkField<EventTracker> EVENT_TRACKER_FIELD = SdkField.<EventTracker> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeEventTrackerResponse::eventTracker)).setter(setter(Builder::eventTracker))
            .constructor(EventTracker::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTracker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TRACKER_FIELD));

    private final EventTracker eventTracker;

    private DescribeEventTrackerResponse(BuilderImpl builder) {
        super(builder);
        this.eventTracker = builder.eventTracker;
    }

    /**
     * <p>
     * An object that describes the event tracker.
     * </p>
     * 
     * @return An object that describes the event tracker.
     */
    public EventTracker eventTracker() {
        return eventTracker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventTracker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventTrackerResponse)) {
            return false;
        }
        DescribeEventTrackerResponse other = (DescribeEventTrackerResponse) obj;
        return Objects.equals(eventTracker(), other.eventTracker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEventTrackerResponse").add("EventTracker", eventTracker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventTracker":
            return Optional.ofNullable(clazz.cast(eventTracker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventTrackerResponse, T> g) {
        return obj -> g.apply((DescribeEventTrackerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventTrackerResponse> {
        /**
         * <p>
         * An object that describes the event tracker.
         * </p>
         * 
         * @param eventTracker
         *        An object that describes the event tracker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTracker(EventTracker eventTracker);

        /**
         * <p>
         * An object that describes the event tracker.
         * </p>
         * This is a convenience that creates an instance of the {@link EventTracker.Builder} avoiding the need to
         * create one manually via {@link EventTracker#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventTracker.Builder#build()} is called immediately and its
         * result is passed to {@link #eventTracker(EventTracker)}.
         * 
         * @param eventTracker
         *        a consumer that will call methods on {@link EventTracker.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTracker(EventTracker)
         */
        default Builder eventTracker(Consumer<EventTracker.Builder> eventTracker) {
            return eventTracker(EventTracker.builder().applyMutation(eventTracker).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private EventTracker eventTracker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventTrackerResponse model) {
            super(model);
            eventTracker(model.eventTracker);
        }

        public final EventTracker.Builder getEventTracker() {
            return eventTracker != null ? eventTracker.toBuilder() : null;
        }

        @Override
        public final Builder eventTracker(EventTracker eventTracker) {
            this.eventTracker = eventTracker;
            return this;
        }

        public final void setEventTracker(EventTracker.BuilderImpl eventTracker) {
            this.eventTracker = eventTracker != null ? eventTracker.build() : null;
        }

        @Override
        public DescribeEventTrackerResponse build() {
            return new DescribeEventTrackerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
