/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeAsyncClient;
import software.amazon.awssdk.services.personalize.model.BatchSegmentJobSummary;
import software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsResponse;

public class ListBatchSegmentJobsPublisher
implements SdkPublisher<ListBatchSegmentJobsResponse> {
    private final PersonalizeAsyncClient client;
    private final ListBatchSegmentJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBatchSegmentJobsPublisher(PersonalizeAsyncClient client, ListBatchSegmentJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBatchSegmentJobsPublisher(PersonalizeAsyncClient client, ListBatchSegmentJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBatchSegmentJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBatchSegmentJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BatchSegmentJobSummary> batchSegmentJobs() {
        Function<ListBatchSegmentJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.batchSegmentJobs() != null) {
                return response.batchSegmentJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBatchSegmentJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBatchSegmentJobsResponseFetcher
    implements AsyncPageFetcher<ListBatchSegmentJobsResponse> {
        private ListBatchSegmentJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListBatchSegmentJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBatchSegmentJobsResponse> nextPage(ListBatchSegmentJobsResponse previousPage) {
            if (previousPage == null) {
                return ListBatchSegmentJobsPublisher.this.client.listBatchSegmentJobs(ListBatchSegmentJobsPublisher.this.firstRequest);
            }
            return ListBatchSegmentJobsPublisher.this.client.listBatchSegmentJobs((ListBatchSegmentJobsRequest)((Object)ListBatchSegmentJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

