/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalize.model.MetricsCopier;
import software.amazon.awssdk.services.personalize.model.RecommenderConfig;
import software.amazon.awssdk.services.personalize.model.RecommenderUpdateSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Recommender
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Recommender> {
    private static final SdkField<String> RECOMMENDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommenderArn").getter(Recommender.getter(Recommender::recommenderArn)).setter(Recommender.setter(Builder::recommenderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommenderArn").build()}).build();
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetGroupArn").getter(Recommender.getter(Recommender::datasetGroupArn)).setter(Recommender.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Recommender.getter(Recommender::name)).setter(Recommender.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recipeArn").getter(Recommender.getter(Recommender::recipeArn)).setter(Recommender.setter(Builder::recipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeArn").build()}).build();
    private static final SdkField<RecommenderConfig> RECOMMENDER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recommenderConfig").getter(Recommender.getter(Recommender::recommenderConfig)).setter(Recommender.setter(Builder::recommenderConfig)).constructor(RecommenderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommenderConfig").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(Recommender.getter(Recommender::creationDateTime)).setter(Recommender.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(Recommender.getter(Recommender::lastUpdatedDateTime)).setter(Recommender.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Recommender.getter(Recommender::status)).setter(Recommender.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(Recommender.getter(Recommender::failureReason)).setter(Recommender.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<RecommenderUpdateSummary> LATEST_RECOMMENDER_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestRecommenderUpdate").getter(Recommender.getter(Recommender::latestRecommenderUpdate)).setter(Recommender.setter(Builder::latestRecommenderUpdate)).constructor(RecommenderUpdateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRecommenderUpdate").build()}).build();
    private static final SdkField<Map<String, Double>> MODEL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("modelMetrics").getter(Recommender.getter(Recommender::modelMetrics)).setter(Recommender.setter(Builder::modelMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelMetrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDER_ARN_FIELD, DATASET_GROUP_ARN_FIELD, NAME_FIELD, RECIPE_ARN_FIELD, RECOMMENDER_CONFIG_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, LATEST_RECOMMENDER_UPDATE_FIELD, MODEL_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Recommender.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String recommenderArn;
    private final String datasetGroupArn;
    private final String name;
    private final String recipeArn;
    private final RecommenderConfig recommenderConfig;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;
    private final String status;
    private final String failureReason;
    private final RecommenderUpdateSummary latestRecommenderUpdate;
    private final Map<String, Double> modelMetrics;

    private Recommender(BuilderImpl builder) {
        this.recommenderArn = builder.recommenderArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.name = builder.name;
        this.recipeArn = builder.recipeArn;
        this.recommenderConfig = builder.recommenderConfig;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.latestRecommenderUpdate = builder.latestRecommenderUpdate;
        this.modelMetrics = builder.modelMetrics;
    }

    public final String recommenderArn() {
        return this.recommenderArn;
    }

    public final String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public final String name() {
        return this.name;
    }

    public final String recipeArn() {
        return this.recipeArn;
    }

    public final RecommenderConfig recommenderConfig() {
        return this.recommenderConfig;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final String status() {
        return this.status;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final RecommenderUpdateSummary latestRecommenderUpdate() {
        return this.latestRecommenderUpdate;
    }

    public final boolean hasModelMetrics() {
        return this.modelMetrics != null && !(this.modelMetrics instanceof SdkAutoConstructMap);
    }

    public final Map<String, Double> modelMetrics() {
        return this.modelMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRecommenderUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelMetrics() ? this.modelMetrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommender)) {
            return false;
        }
        Recommender other = (Recommender)obj;
        return Objects.equals(this.recommenderArn(), other.recommenderArn()) && Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.recipeArn(), other.recipeArn()) && Objects.equals(this.recommenderConfig(), other.recommenderConfig()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.latestRecommenderUpdate(), other.latestRecommenderUpdate()) && this.hasModelMetrics() == other.hasModelMetrics() && Objects.equals(this.modelMetrics(), other.modelMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"Recommender").add("RecommenderArn", (Object)this.recommenderArn()).add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("Name", (Object)this.name()).add("RecipeArn", (Object)this.recipeArn()).add("RecommenderConfig", (Object)this.recommenderConfig()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("Status", (Object)this.status()).add("FailureReason", (Object)this.failureReason()).add("LatestRecommenderUpdate", (Object)this.latestRecommenderUpdate()).add("ModelMetrics", this.hasModelMetrics() ? this.modelMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recommenderArn": {
                return Optional.ofNullable(clazz.cast(this.recommenderArn()));
            }
            case "datasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "recipeArn": {
                return Optional.ofNullable(clazz.cast(this.recipeArn()));
            }
            case "recommenderConfig": {
                return Optional.ofNullable(clazz.cast(this.recommenderConfig()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "latestRecommenderUpdate": {
                return Optional.ofNullable(clazz.cast(this.latestRecommenderUpdate()));
            }
            case "modelMetrics": {
                return Optional.ofNullable(clazz.cast(this.modelMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recommenderArn", RECOMMENDER_ARN_FIELD);
        map.put("datasetGroupArn", DATASET_GROUP_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("recipeArn", RECIPE_ARN_FIELD);
        map.put("recommenderConfig", RECOMMENDER_CONFIG_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("latestRecommenderUpdate", LATEST_RECOMMENDER_UPDATE_FIELD);
        map.put("modelMetrics", MODEL_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Recommender, T> g) {
        return obj -> g.apply((Recommender)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recommenderArn;
        private String datasetGroupArn;
        private String name;
        private String recipeArn;
        private RecommenderConfig recommenderConfig;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;
        private String status;
        private String failureReason;
        private RecommenderUpdateSummary latestRecommenderUpdate;
        private Map<String, Double> modelMetrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Recommender model) {
            this.recommenderArn(model.recommenderArn);
            this.datasetGroupArn(model.datasetGroupArn);
            this.name(model.name);
            this.recipeArn(model.recipeArn);
            this.recommenderConfig(model.recommenderConfig);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.status(model.status);
            this.failureReason(model.failureReason);
            this.latestRecommenderUpdate(model.latestRecommenderUpdate);
            this.modelMetrics(model.modelMetrics);
        }

        public final String getRecommenderArn() {
            return this.recommenderArn;
        }

        public final void setRecommenderArn(String recommenderArn) {
            this.recommenderArn = recommenderArn;
        }

        @Override
        public final Builder recommenderArn(String recommenderArn) {
            this.recommenderArn = recommenderArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecipeArn() {
            return this.recipeArn;
        }

        public final void setRecipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
        }

        @Override
        public final Builder recipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
            return this;
        }

        public final RecommenderConfig.Builder getRecommenderConfig() {
            return this.recommenderConfig != null ? this.recommenderConfig.toBuilder() : null;
        }

        public final void setRecommenderConfig(RecommenderConfig.BuilderImpl recommenderConfig) {
            this.recommenderConfig = recommenderConfig != null ? recommenderConfig.build() : null;
        }

        @Override
        public final Builder recommenderConfig(RecommenderConfig recommenderConfig) {
            this.recommenderConfig = recommenderConfig;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final RecommenderUpdateSummary.Builder getLatestRecommenderUpdate() {
            return this.latestRecommenderUpdate != null ? this.latestRecommenderUpdate.toBuilder() : null;
        }

        public final void setLatestRecommenderUpdate(RecommenderUpdateSummary.BuilderImpl latestRecommenderUpdate) {
            this.latestRecommenderUpdate = latestRecommenderUpdate != null ? latestRecommenderUpdate.build() : null;
        }

        @Override
        public final Builder latestRecommenderUpdate(RecommenderUpdateSummary latestRecommenderUpdate) {
            this.latestRecommenderUpdate = latestRecommenderUpdate;
            return this;
        }

        public final Map<String, Double> getModelMetrics() {
            if (this.modelMetrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.modelMetrics;
        }

        public final void setModelMetrics(Map<String, Double> modelMetrics) {
            this.modelMetrics = MetricsCopier.copy(modelMetrics);
        }

        @Override
        public final Builder modelMetrics(Map<String, Double> modelMetrics) {
            this.modelMetrics = MetricsCopier.copy(modelMetrics);
            return this;
        }

        public Recommender build() {
            return new Recommender(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Recommender> {
        public Builder recommenderArn(String var1);

        public Builder datasetGroupArn(String var1);

        public Builder name(String var1);

        public Builder recipeArn(String var1);

        public Builder recommenderConfig(RecommenderConfig var1);

        default public Builder recommenderConfig(Consumer<RecommenderConfig.Builder> recommenderConfig) {
            return this.recommenderConfig((RecommenderConfig)((RecommenderConfig.Builder)RecommenderConfig.builder().applyMutation(recommenderConfig)).build());
        }

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder status(String var1);

        public Builder failureReason(String var1);

        public Builder latestRecommenderUpdate(RecommenderUpdateSummary var1);

        default public Builder latestRecommenderUpdate(Consumer<RecommenderUpdateSummary.Builder> latestRecommenderUpdate) {
            return this.latestRecommenderUpdate((RecommenderUpdateSummary)((RecommenderUpdateSummary.Builder)RecommenderUpdateSummary.builder().applyMutation(latestRecommenderUpdate)).build());
        }

        public Builder modelMetrics(Map<String, Double> var1);
    }
}

