/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pi.PiClient;
import software.amazon.awssdk.services.pi.internal.UserAgentUtils;
import software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest;
import software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse;

public class ListAvailableResourceMetricsIterable
implements SdkIterable<ListAvailableResourceMetricsResponse> {
    private final PiClient client;
    private final ListAvailableResourceMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAvailableResourceMetricsIterable(PiClient client, ListAvailableResourceMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAvailableResourceMetricsResponseFetcher();
    }

    public Iterator<ListAvailableResourceMetricsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAvailableResourceMetricsResponseFetcher
    implements SyncPageFetcher<ListAvailableResourceMetricsResponse> {
        private ListAvailableResourceMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListAvailableResourceMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAvailableResourceMetricsResponse nextPage(ListAvailableResourceMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListAvailableResourceMetricsIterable.this.client.listAvailableResourceMetrics(ListAvailableResourceMetricsIterable.this.firstRequest);
            }
            return ListAvailableResourceMetricsIterable.this.client.listAvailableResourceMetrics((ListAvailableResourceMetricsRequest)((Object)ListAvailableResourceMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

