/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.AIAgentConfigurationData;
import software.amazon.awssdk.services.qconnect.model.AIAgentConfigurationMapCopier;
import software.amazon.awssdk.services.qconnect.model.AIAgentType;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.TagFilter;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSessionRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, CreateSessionRequest> {
    private static final SdkField<Map<String, AIAgentConfigurationData>> AI_AGENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("aiAgentConfiguration").getter(CreateSessionRequest.getter(CreateSessionRequest::aiAgentConfigurationAsStrings)).setter(CreateSessionRequest.setter(Builder::aiAgentConfigurationWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AIAgentConfigurationData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(CreateSessionRequest.getter(CreateSessionRequest::assistantId)).setter(CreateSessionRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateSessionRequest.getter(CreateSessionRequest::clientToken)).setter(CreateSessionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateSessionRequest.getter(CreateSessionRequest::description)).setter(CreateSessionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateSessionRequest.getter(CreateSessionRequest::name)).setter(CreateSessionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tagFilter").getter(CreateSessionRequest.getter(CreateSessionRequest::tagFilter)).setter(CreateSessionRequest.setter(Builder::tagFilter)).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSessionRequest.getter(CreateSessionRequest::tags)).setter(CreateSessionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_AGENT_CONFIGURATION_FIELD, ASSISTANT_ID_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, NAME_FIELD, TAG_FILTER_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSessionRequest.memberNameToFieldInitializer();
    private final Map<String, AIAgentConfigurationData> aiAgentConfiguration;
    private final String assistantId;
    private final String clientToken;
    private final String description;
    private final String name;
    private final TagFilter tagFilter;
    private final Map<String, String> tags;

    private CreateSessionRequest(BuilderImpl builder) {
        super(builder);
        this.aiAgentConfiguration = builder.aiAgentConfiguration;
        this.assistantId = builder.assistantId;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.name = builder.name;
        this.tagFilter = builder.tagFilter;
        this.tags = builder.tags;
    }

    public final Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration() {
        return AIAgentConfigurationMapCopier.copyStringToEnum(this.aiAgentConfiguration);
    }

    public final boolean hasAiAgentConfiguration() {
        return this.aiAgentConfiguration != null && !(this.aiAgentConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, AIAgentConfigurationData> aiAgentConfigurationAsStrings() {
        return this.aiAgentConfiguration;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final TagFilter tagFilter() {
        return this.tagFilter;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAiAgentConfiguration() ? this.aiAgentConfigurationAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSessionRequest)) {
            return false;
        }
        CreateSessionRequest other = (CreateSessionRequest)((Object)obj);
        return this.hasAiAgentConfiguration() == other.hasAiAgentConfiguration() && Objects.equals(this.aiAgentConfigurationAsStrings(), other.aiAgentConfigurationAsStrings()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.tagFilter(), other.tagFilter()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSessionRequest").add("AiAgentConfiguration", this.hasAiAgentConfiguration() ? this.aiAgentConfigurationAsStrings() : null).add("AssistantId", (Object)this.assistantId()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("TagFilter", (Object)this.tagFilter()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aiAgentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.aiAgentConfigurationAsStrings()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tagFilter": {
                return Optional.ofNullable(clazz.cast(this.tagFilter()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("aiAgentConfiguration", AI_AGENT_CONFIGURATION_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tagFilter", TAG_FILTER_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSessionRequest, T> g) {
        return obj -> g.apply((CreateSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private Map<String, AIAgentConfigurationData> aiAgentConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private String assistantId;
        private String clientToken;
        private String description;
        private String name;
        private TagFilter tagFilter;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSessionRequest model) {
            super(model);
            this.aiAgentConfigurationWithStrings(model.aiAgentConfiguration);
            this.assistantId(model.assistantId);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.name(model.name);
            this.tagFilter(model.tagFilter);
            this.tags(model.tags);
        }

        public final Map<String, AIAgentConfigurationData.Builder> getAiAgentConfiguration() {
            Map<String, AIAgentConfigurationData.Builder> result = AIAgentConfigurationMapCopier.copyToBuilder(this.aiAgentConfiguration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAiAgentConfiguration(Map<String, AIAgentConfigurationData.BuilderImpl> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copyFromBuilder(aiAgentConfiguration);
        }

        @Override
        public final Builder aiAgentConfigurationWithStrings(Map<String, AIAgentConfigurationData> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copy(aiAgentConfiguration);
            return this;
        }

        @Override
        public final Builder aiAgentConfiguration(Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copyEnumToString(aiAgentConfiguration);
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TagFilter.Builder getTagFilter() {
            return this.tagFilter != null ? this.tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSessionRequest build() {
            return new CreateSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSessionRequest> {
        public Builder aiAgentConfigurationWithStrings(Map<String, AIAgentConfigurationData> var1);

        public Builder aiAgentConfiguration(Map<AIAgentType, AIAgentConfigurationData> var1);

        public Builder assistantId(String var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder tagFilter(TagFilter var1);

        default public Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return this.tagFilter((TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation(tagFilter)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

