/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Participant {
    CUSTOMER("CUSTOMER"),
    AGENT("AGENT"),
    BOT("BOT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Participant> VALUE_MAP;
    private final String value;

    private Participant(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Participant fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Participant> knownValues() {
        EnumSet<Participant> knownValues = EnumSet.allOf(Participant.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Participant.class, Participant::toString);
    }
}

