/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AdHocFilteringOption;
import software.amazon.awssdk.services.quicksight.model.DashboardVisualPublishOptions;
import software.amazon.awssdk.services.quicksight.model.DataPointDrillUpDownOption;
import software.amazon.awssdk.services.quicksight.model.DataPointMenuLabelOption;
import software.amazon.awssdk.services.quicksight.model.DataPointTooltipOption;
import software.amazon.awssdk.services.quicksight.model.ExportToCSVOption;
import software.amazon.awssdk.services.quicksight.model.ExportWithHiddenFieldsOption;
import software.amazon.awssdk.services.quicksight.model.SheetControlsOption;
import software.amazon.awssdk.services.quicksight.model.SheetLayoutElementMaximizationOption;
import software.amazon.awssdk.services.quicksight.model.VisualAxisSortOption;
import software.amazon.awssdk.services.quicksight.model.VisualMenuOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashboardPublishOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashboardPublishOptions> {
    private static final SdkField<AdHocFilteringOption> AD_HOC_FILTERING_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdHocFilteringOption").getter(DashboardPublishOptions.getter(DashboardPublishOptions::adHocFilteringOption)).setter(DashboardPublishOptions.setter(Builder::adHocFilteringOption)).constructor(AdHocFilteringOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdHocFilteringOption").build()}).build();
    private static final SdkField<ExportToCSVOption> EXPORT_TO_CSV_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportToCSVOption").getter(DashboardPublishOptions.getter(DashboardPublishOptions::exportToCSVOption)).setter(DashboardPublishOptions.setter(Builder::exportToCSVOption)).constructor(ExportToCSVOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToCSVOption").build()}).build();
    private static final SdkField<SheetControlsOption> SHEET_CONTROLS_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SheetControlsOption").getter(DashboardPublishOptions.getter(DashboardPublishOptions::sheetControlsOption)).setter(DashboardPublishOptions.setter(Builder::sheetControlsOption)).constructor(SheetControlsOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetControlsOption").build()}).build();
    private static final SdkField<DashboardVisualPublishOptions> VISUAL_PUBLISH_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualPublishOptions").getter(DashboardPublishOptions.getter(DashboardPublishOptions::visualPublishOptions)).setter(DashboardPublishOptions.setter(Builder::visualPublishOptions)).constructor(DashboardVisualPublishOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPublishOptions").build()}).build();
    private static final SdkField<SheetLayoutElementMaximizationOption> SHEET_LAYOUT_ELEMENT_MAXIMIZATION_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SheetLayoutElementMaximizationOption").getter(DashboardPublishOptions.getter(DashboardPublishOptions::sheetLayoutElementMaximizationOption)).setter(DashboardPublishOptions.setter(Builder::sheetLayoutElementMaximizationOption)).constructor(SheetLayoutElementMaximizationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetLayoutElementMaximizationOption").build()}).build();
    private static final SdkField<VisualMenuOption> VISUAL_MENU_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualMenuOption").getter(DashboardPublishOptions.getter(DashboardPublishOptions::visualMenuOption)).setter(DashboardPublishOptions.setter(Builder::visualMenuOption)).constructor(VisualMenuOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualMenuOption").build()}).build();
    private static final SdkField<VisualAxisSortOption> VISUAL_AXIS_SORT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualAxisSortOption").getter(DashboardPublishOptions.getter(DashboardPublishOptions::visualAxisSortOption)).setter(DashboardPublishOptions.setter(Builder::visualAxisSortOption)).constructor(VisualAxisSortOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualAxisSortOption").build()}).build();
    private static final SdkField<ExportWithHiddenFieldsOption> EXPORT_WITH_HIDDEN_FIELDS_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportWithHiddenFieldsOption").getter(DashboardPublishOptions.getter(DashboardPublishOptions::exportWithHiddenFieldsOption)).setter(DashboardPublishOptions.setter(Builder::exportWithHiddenFieldsOption)).constructor(ExportWithHiddenFieldsOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportWithHiddenFieldsOption").build()}).build();
    private static final SdkField<DataPointDrillUpDownOption> DATA_POINT_DRILL_UP_DOWN_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataPointDrillUpDownOption").getter(DashboardPublishOptions.getter(DashboardPublishOptions::dataPointDrillUpDownOption)).setter(DashboardPublishOptions.setter(Builder::dataPointDrillUpDownOption)).constructor(DataPointDrillUpDownOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPointDrillUpDownOption").build()}).build();
    private static final SdkField<DataPointMenuLabelOption> DATA_POINT_MENU_LABEL_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataPointMenuLabelOption").getter(DashboardPublishOptions.getter(DashboardPublishOptions::dataPointMenuLabelOption)).setter(DashboardPublishOptions.setter(Builder::dataPointMenuLabelOption)).constructor(DataPointMenuLabelOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPointMenuLabelOption").build()}).build();
    private static final SdkField<DataPointTooltipOption> DATA_POINT_TOOLTIP_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataPointTooltipOption").getter(DashboardPublishOptions.getter(DashboardPublishOptions::dataPointTooltipOption)).setter(DashboardPublishOptions.setter(Builder::dataPointTooltipOption)).constructor(DataPointTooltipOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPointTooltipOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_HOC_FILTERING_OPTION_FIELD, EXPORT_TO_CSV_OPTION_FIELD, SHEET_CONTROLS_OPTION_FIELD, VISUAL_PUBLISH_OPTIONS_FIELD, SHEET_LAYOUT_ELEMENT_MAXIMIZATION_OPTION_FIELD, VISUAL_MENU_OPTION_FIELD, VISUAL_AXIS_SORT_OPTION_FIELD, EXPORT_WITH_HIDDEN_FIELDS_OPTION_FIELD, DATA_POINT_DRILL_UP_DOWN_OPTION_FIELD, DATA_POINT_MENU_LABEL_OPTION_FIELD, DATA_POINT_TOOLTIP_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DashboardPublishOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AdHocFilteringOption adHocFilteringOption;
    private final ExportToCSVOption exportToCSVOption;
    private final SheetControlsOption sheetControlsOption;
    private final DashboardVisualPublishOptions visualPublishOptions;
    private final SheetLayoutElementMaximizationOption sheetLayoutElementMaximizationOption;
    private final VisualMenuOption visualMenuOption;
    private final VisualAxisSortOption visualAxisSortOption;
    private final ExportWithHiddenFieldsOption exportWithHiddenFieldsOption;
    private final DataPointDrillUpDownOption dataPointDrillUpDownOption;
    private final DataPointMenuLabelOption dataPointMenuLabelOption;
    private final DataPointTooltipOption dataPointTooltipOption;

    private DashboardPublishOptions(BuilderImpl builder) {
        this.adHocFilteringOption = builder.adHocFilteringOption;
        this.exportToCSVOption = builder.exportToCSVOption;
        this.sheetControlsOption = builder.sheetControlsOption;
        this.visualPublishOptions = builder.visualPublishOptions;
        this.sheetLayoutElementMaximizationOption = builder.sheetLayoutElementMaximizationOption;
        this.visualMenuOption = builder.visualMenuOption;
        this.visualAxisSortOption = builder.visualAxisSortOption;
        this.exportWithHiddenFieldsOption = builder.exportWithHiddenFieldsOption;
        this.dataPointDrillUpDownOption = builder.dataPointDrillUpDownOption;
        this.dataPointMenuLabelOption = builder.dataPointMenuLabelOption;
        this.dataPointTooltipOption = builder.dataPointTooltipOption;
    }

    public final AdHocFilteringOption adHocFilteringOption() {
        return this.adHocFilteringOption;
    }

    public final ExportToCSVOption exportToCSVOption() {
        return this.exportToCSVOption;
    }

    public final SheetControlsOption sheetControlsOption() {
        return this.sheetControlsOption;
    }

    @Deprecated
    public final DashboardVisualPublishOptions visualPublishOptions() {
        return this.visualPublishOptions;
    }

    public final SheetLayoutElementMaximizationOption sheetLayoutElementMaximizationOption() {
        return this.sheetLayoutElementMaximizationOption;
    }

    public final VisualMenuOption visualMenuOption() {
        return this.visualMenuOption;
    }

    public final VisualAxisSortOption visualAxisSortOption() {
        return this.visualAxisSortOption;
    }

    public final ExportWithHiddenFieldsOption exportWithHiddenFieldsOption() {
        return this.exportWithHiddenFieldsOption;
    }

    public final DataPointDrillUpDownOption dataPointDrillUpDownOption() {
        return this.dataPointDrillUpDownOption;
    }

    public final DataPointMenuLabelOption dataPointMenuLabelOption() {
        return this.dataPointMenuLabelOption;
    }

    public final DataPointTooltipOption dataPointTooltipOption() {
        return this.dataPointTooltipOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adHocFilteringOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToCSVOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.sheetControlsOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualPublishOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.sheetLayoutElementMaximizationOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualMenuOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualAxisSortOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportWithHiddenFieldsOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPointDrillUpDownOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPointMenuLabelOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPointTooltipOption());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardPublishOptions)) {
            return false;
        }
        DashboardPublishOptions other = (DashboardPublishOptions)obj;
        return Objects.equals(this.adHocFilteringOption(), other.adHocFilteringOption()) && Objects.equals(this.exportToCSVOption(), other.exportToCSVOption()) && Objects.equals(this.sheetControlsOption(), other.sheetControlsOption()) && Objects.equals(this.visualPublishOptions(), other.visualPublishOptions()) && Objects.equals(this.sheetLayoutElementMaximizationOption(), other.sheetLayoutElementMaximizationOption()) && Objects.equals(this.visualMenuOption(), other.visualMenuOption()) && Objects.equals(this.visualAxisSortOption(), other.visualAxisSortOption()) && Objects.equals(this.exportWithHiddenFieldsOption(), other.exportWithHiddenFieldsOption()) && Objects.equals(this.dataPointDrillUpDownOption(), other.dataPointDrillUpDownOption()) && Objects.equals(this.dataPointMenuLabelOption(), other.dataPointMenuLabelOption()) && Objects.equals(this.dataPointTooltipOption(), other.dataPointTooltipOption());
    }

    public final String toString() {
        return ToString.builder((String)"DashboardPublishOptions").add("AdHocFilteringOption", (Object)this.adHocFilteringOption()).add("ExportToCSVOption", (Object)this.exportToCSVOption()).add("SheetControlsOption", (Object)this.sheetControlsOption()).add("VisualPublishOptions", (Object)this.visualPublishOptions()).add("SheetLayoutElementMaximizationOption", (Object)this.sheetLayoutElementMaximizationOption()).add("VisualMenuOption", (Object)this.visualMenuOption()).add("VisualAxisSortOption", (Object)this.visualAxisSortOption()).add("ExportWithHiddenFieldsOption", (Object)this.exportWithHiddenFieldsOption()).add("DataPointDrillUpDownOption", (Object)this.dataPointDrillUpDownOption()).add("DataPointMenuLabelOption", (Object)this.dataPointMenuLabelOption()).add("DataPointTooltipOption", (Object)this.dataPointTooltipOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdHocFilteringOption": {
                return Optional.ofNullable(clazz.cast(this.adHocFilteringOption()));
            }
            case "ExportToCSVOption": {
                return Optional.ofNullable(clazz.cast(this.exportToCSVOption()));
            }
            case "SheetControlsOption": {
                return Optional.ofNullable(clazz.cast(this.sheetControlsOption()));
            }
            case "VisualPublishOptions": {
                return Optional.ofNullable(clazz.cast(this.visualPublishOptions()));
            }
            case "SheetLayoutElementMaximizationOption": {
                return Optional.ofNullable(clazz.cast(this.sheetLayoutElementMaximizationOption()));
            }
            case "VisualMenuOption": {
                return Optional.ofNullable(clazz.cast(this.visualMenuOption()));
            }
            case "VisualAxisSortOption": {
                return Optional.ofNullable(clazz.cast(this.visualAxisSortOption()));
            }
            case "ExportWithHiddenFieldsOption": {
                return Optional.ofNullable(clazz.cast(this.exportWithHiddenFieldsOption()));
            }
            case "DataPointDrillUpDownOption": {
                return Optional.ofNullable(clazz.cast(this.dataPointDrillUpDownOption()));
            }
            case "DataPointMenuLabelOption": {
                return Optional.ofNullable(clazz.cast(this.dataPointMenuLabelOption()));
            }
            case "DataPointTooltipOption": {
                return Optional.ofNullable(clazz.cast(this.dataPointTooltipOption()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AdHocFilteringOption", AD_HOC_FILTERING_OPTION_FIELD);
        map.put("ExportToCSVOption", EXPORT_TO_CSV_OPTION_FIELD);
        map.put("SheetControlsOption", SHEET_CONTROLS_OPTION_FIELD);
        map.put("VisualPublishOptions", VISUAL_PUBLISH_OPTIONS_FIELD);
        map.put("SheetLayoutElementMaximizationOption", SHEET_LAYOUT_ELEMENT_MAXIMIZATION_OPTION_FIELD);
        map.put("VisualMenuOption", VISUAL_MENU_OPTION_FIELD);
        map.put("VisualAxisSortOption", VISUAL_AXIS_SORT_OPTION_FIELD);
        map.put("ExportWithHiddenFieldsOption", EXPORT_WITH_HIDDEN_FIELDS_OPTION_FIELD);
        map.put("DataPointDrillUpDownOption", DATA_POINT_DRILL_UP_DOWN_OPTION_FIELD);
        map.put("DataPointMenuLabelOption", DATA_POINT_MENU_LABEL_OPTION_FIELD);
        map.put("DataPointTooltipOption", DATA_POINT_TOOLTIP_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashboardPublishOptions, T> g) {
        return obj -> g.apply((DashboardPublishOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AdHocFilteringOption adHocFilteringOption;
        private ExportToCSVOption exportToCSVOption;
        private SheetControlsOption sheetControlsOption;
        private DashboardVisualPublishOptions visualPublishOptions;
        private SheetLayoutElementMaximizationOption sheetLayoutElementMaximizationOption;
        private VisualMenuOption visualMenuOption;
        private VisualAxisSortOption visualAxisSortOption;
        private ExportWithHiddenFieldsOption exportWithHiddenFieldsOption;
        private DataPointDrillUpDownOption dataPointDrillUpDownOption;
        private DataPointMenuLabelOption dataPointMenuLabelOption;
        private DataPointTooltipOption dataPointTooltipOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardPublishOptions model) {
            this.adHocFilteringOption(model.adHocFilteringOption);
            this.exportToCSVOption(model.exportToCSVOption);
            this.sheetControlsOption(model.sheetControlsOption);
            this.visualPublishOptions(model.visualPublishOptions);
            this.sheetLayoutElementMaximizationOption(model.sheetLayoutElementMaximizationOption);
            this.visualMenuOption(model.visualMenuOption);
            this.visualAxisSortOption(model.visualAxisSortOption);
            this.exportWithHiddenFieldsOption(model.exportWithHiddenFieldsOption);
            this.dataPointDrillUpDownOption(model.dataPointDrillUpDownOption);
            this.dataPointMenuLabelOption(model.dataPointMenuLabelOption);
            this.dataPointTooltipOption(model.dataPointTooltipOption);
        }

        public final AdHocFilteringOption.Builder getAdHocFilteringOption() {
            return this.adHocFilteringOption != null ? this.adHocFilteringOption.toBuilder() : null;
        }

        public final void setAdHocFilteringOption(AdHocFilteringOption.BuilderImpl adHocFilteringOption) {
            this.adHocFilteringOption = adHocFilteringOption != null ? adHocFilteringOption.build() : null;
        }

        @Override
        public final Builder adHocFilteringOption(AdHocFilteringOption adHocFilteringOption) {
            this.adHocFilteringOption = adHocFilteringOption;
            return this;
        }

        public final ExportToCSVOption.Builder getExportToCSVOption() {
            return this.exportToCSVOption != null ? this.exportToCSVOption.toBuilder() : null;
        }

        public final void setExportToCSVOption(ExportToCSVOption.BuilderImpl exportToCSVOption) {
            this.exportToCSVOption = exportToCSVOption != null ? exportToCSVOption.build() : null;
        }

        @Override
        public final Builder exportToCSVOption(ExportToCSVOption exportToCSVOption) {
            this.exportToCSVOption = exportToCSVOption;
            return this;
        }

        public final SheetControlsOption.Builder getSheetControlsOption() {
            return this.sheetControlsOption != null ? this.sheetControlsOption.toBuilder() : null;
        }

        public final void setSheetControlsOption(SheetControlsOption.BuilderImpl sheetControlsOption) {
            this.sheetControlsOption = sheetControlsOption != null ? sheetControlsOption.build() : null;
        }

        @Override
        public final Builder sheetControlsOption(SheetControlsOption sheetControlsOption) {
            this.sheetControlsOption = sheetControlsOption;
            return this;
        }

        @Deprecated
        public final DashboardVisualPublishOptions.Builder getVisualPublishOptions() {
            return this.visualPublishOptions != null ? this.visualPublishOptions.toBuilder() : null;
        }

        @Deprecated
        public final void setVisualPublishOptions(DashboardVisualPublishOptions.BuilderImpl visualPublishOptions) {
            this.visualPublishOptions = visualPublishOptions != null ? visualPublishOptions.build() : null;
        }

        @Override
        @Deprecated
        public final Builder visualPublishOptions(DashboardVisualPublishOptions visualPublishOptions) {
            this.visualPublishOptions = visualPublishOptions;
            return this;
        }

        public final SheetLayoutElementMaximizationOption.Builder getSheetLayoutElementMaximizationOption() {
            return this.sheetLayoutElementMaximizationOption != null ? this.sheetLayoutElementMaximizationOption.toBuilder() : null;
        }

        public final void setSheetLayoutElementMaximizationOption(SheetLayoutElementMaximizationOption.BuilderImpl sheetLayoutElementMaximizationOption) {
            this.sheetLayoutElementMaximizationOption = sheetLayoutElementMaximizationOption != null ? sheetLayoutElementMaximizationOption.build() : null;
        }

        @Override
        public final Builder sheetLayoutElementMaximizationOption(SheetLayoutElementMaximizationOption sheetLayoutElementMaximizationOption) {
            this.sheetLayoutElementMaximizationOption = sheetLayoutElementMaximizationOption;
            return this;
        }

        public final VisualMenuOption.Builder getVisualMenuOption() {
            return this.visualMenuOption != null ? this.visualMenuOption.toBuilder() : null;
        }

        public final void setVisualMenuOption(VisualMenuOption.BuilderImpl visualMenuOption) {
            this.visualMenuOption = visualMenuOption != null ? visualMenuOption.build() : null;
        }

        @Override
        public final Builder visualMenuOption(VisualMenuOption visualMenuOption) {
            this.visualMenuOption = visualMenuOption;
            return this;
        }

        public final VisualAxisSortOption.Builder getVisualAxisSortOption() {
            return this.visualAxisSortOption != null ? this.visualAxisSortOption.toBuilder() : null;
        }

        public final void setVisualAxisSortOption(VisualAxisSortOption.BuilderImpl visualAxisSortOption) {
            this.visualAxisSortOption = visualAxisSortOption != null ? visualAxisSortOption.build() : null;
        }

        @Override
        public final Builder visualAxisSortOption(VisualAxisSortOption visualAxisSortOption) {
            this.visualAxisSortOption = visualAxisSortOption;
            return this;
        }

        public final ExportWithHiddenFieldsOption.Builder getExportWithHiddenFieldsOption() {
            return this.exportWithHiddenFieldsOption != null ? this.exportWithHiddenFieldsOption.toBuilder() : null;
        }

        public final void setExportWithHiddenFieldsOption(ExportWithHiddenFieldsOption.BuilderImpl exportWithHiddenFieldsOption) {
            this.exportWithHiddenFieldsOption = exportWithHiddenFieldsOption != null ? exportWithHiddenFieldsOption.build() : null;
        }

        @Override
        public final Builder exportWithHiddenFieldsOption(ExportWithHiddenFieldsOption exportWithHiddenFieldsOption) {
            this.exportWithHiddenFieldsOption = exportWithHiddenFieldsOption;
            return this;
        }

        public final DataPointDrillUpDownOption.Builder getDataPointDrillUpDownOption() {
            return this.dataPointDrillUpDownOption != null ? this.dataPointDrillUpDownOption.toBuilder() : null;
        }

        public final void setDataPointDrillUpDownOption(DataPointDrillUpDownOption.BuilderImpl dataPointDrillUpDownOption) {
            this.dataPointDrillUpDownOption = dataPointDrillUpDownOption != null ? dataPointDrillUpDownOption.build() : null;
        }

        @Override
        public final Builder dataPointDrillUpDownOption(DataPointDrillUpDownOption dataPointDrillUpDownOption) {
            this.dataPointDrillUpDownOption = dataPointDrillUpDownOption;
            return this;
        }

        public final DataPointMenuLabelOption.Builder getDataPointMenuLabelOption() {
            return this.dataPointMenuLabelOption != null ? this.dataPointMenuLabelOption.toBuilder() : null;
        }

        public final void setDataPointMenuLabelOption(DataPointMenuLabelOption.BuilderImpl dataPointMenuLabelOption) {
            this.dataPointMenuLabelOption = dataPointMenuLabelOption != null ? dataPointMenuLabelOption.build() : null;
        }

        @Override
        public final Builder dataPointMenuLabelOption(DataPointMenuLabelOption dataPointMenuLabelOption) {
            this.dataPointMenuLabelOption = dataPointMenuLabelOption;
            return this;
        }

        public final DataPointTooltipOption.Builder getDataPointTooltipOption() {
            return this.dataPointTooltipOption != null ? this.dataPointTooltipOption.toBuilder() : null;
        }

        public final void setDataPointTooltipOption(DataPointTooltipOption.BuilderImpl dataPointTooltipOption) {
            this.dataPointTooltipOption = dataPointTooltipOption != null ? dataPointTooltipOption.build() : null;
        }

        @Override
        public final Builder dataPointTooltipOption(DataPointTooltipOption dataPointTooltipOption) {
            this.dataPointTooltipOption = dataPointTooltipOption;
            return this;
        }

        public DashboardPublishOptions build() {
            return new DashboardPublishOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashboardPublishOptions> {
        public Builder adHocFilteringOption(AdHocFilteringOption var1);

        default public Builder adHocFilteringOption(Consumer<AdHocFilteringOption.Builder> adHocFilteringOption) {
            return this.adHocFilteringOption((AdHocFilteringOption)((AdHocFilteringOption.Builder)AdHocFilteringOption.builder().applyMutation(adHocFilteringOption)).build());
        }

        public Builder exportToCSVOption(ExportToCSVOption var1);

        default public Builder exportToCSVOption(Consumer<ExportToCSVOption.Builder> exportToCSVOption) {
            return this.exportToCSVOption((ExportToCSVOption)((ExportToCSVOption.Builder)ExportToCSVOption.builder().applyMutation(exportToCSVOption)).build());
        }

        public Builder sheetControlsOption(SheetControlsOption var1);

        default public Builder sheetControlsOption(Consumer<SheetControlsOption.Builder> sheetControlsOption) {
            return this.sheetControlsOption((SheetControlsOption)((SheetControlsOption.Builder)SheetControlsOption.builder().applyMutation(sheetControlsOption)).build());
        }

        @Deprecated
        public Builder visualPublishOptions(DashboardVisualPublishOptions var1);

        @Deprecated
        default public Builder visualPublishOptions(Consumer<DashboardVisualPublishOptions.Builder> visualPublishOptions) {
            return this.visualPublishOptions((DashboardVisualPublishOptions)((DashboardVisualPublishOptions.Builder)DashboardVisualPublishOptions.builder().applyMutation(visualPublishOptions)).build());
        }

        public Builder sheetLayoutElementMaximizationOption(SheetLayoutElementMaximizationOption var1);

        default public Builder sheetLayoutElementMaximizationOption(Consumer<SheetLayoutElementMaximizationOption.Builder> sheetLayoutElementMaximizationOption) {
            return this.sheetLayoutElementMaximizationOption((SheetLayoutElementMaximizationOption)((SheetLayoutElementMaximizationOption.Builder)SheetLayoutElementMaximizationOption.builder().applyMutation(sheetLayoutElementMaximizationOption)).build());
        }

        public Builder visualMenuOption(VisualMenuOption var1);

        default public Builder visualMenuOption(Consumer<VisualMenuOption.Builder> visualMenuOption) {
            return this.visualMenuOption((VisualMenuOption)((VisualMenuOption.Builder)VisualMenuOption.builder().applyMutation(visualMenuOption)).build());
        }

        public Builder visualAxisSortOption(VisualAxisSortOption var1);

        default public Builder visualAxisSortOption(Consumer<VisualAxisSortOption.Builder> visualAxisSortOption) {
            return this.visualAxisSortOption((VisualAxisSortOption)((VisualAxisSortOption.Builder)VisualAxisSortOption.builder().applyMutation(visualAxisSortOption)).build());
        }

        public Builder exportWithHiddenFieldsOption(ExportWithHiddenFieldsOption var1);

        default public Builder exportWithHiddenFieldsOption(Consumer<ExportWithHiddenFieldsOption.Builder> exportWithHiddenFieldsOption) {
            return this.exportWithHiddenFieldsOption((ExportWithHiddenFieldsOption)((ExportWithHiddenFieldsOption.Builder)ExportWithHiddenFieldsOption.builder().applyMutation(exportWithHiddenFieldsOption)).build());
        }

        public Builder dataPointDrillUpDownOption(DataPointDrillUpDownOption var1);

        default public Builder dataPointDrillUpDownOption(Consumer<DataPointDrillUpDownOption.Builder> dataPointDrillUpDownOption) {
            return this.dataPointDrillUpDownOption((DataPointDrillUpDownOption)((DataPointDrillUpDownOption.Builder)DataPointDrillUpDownOption.builder().applyMutation(dataPointDrillUpDownOption)).build());
        }

        public Builder dataPointMenuLabelOption(DataPointMenuLabelOption var1);

        default public Builder dataPointMenuLabelOption(Consumer<DataPointMenuLabelOption.Builder> dataPointMenuLabelOption) {
            return this.dataPointMenuLabelOption((DataPointMenuLabelOption)((DataPointMenuLabelOption.Builder)DataPointMenuLabelOption.builder().applyMutation(dataPointMenuLabelOption)).build());
        }

        public Builder dataPointTooltipOption(DataPointTooltipOption var1);

        default public Builder dataPointTooltipOption(Consumer<DataPointTooltipOption.Builder> dataPointTooltipOption) {
            return this.dataPointTooltipOption((DataPointTooltipOption)((DataPointTooltipOption.Builder)DataPointTooltipOption.builder().applyMutation(dataPointTooltipOption)).build());
        }
    }
}

