/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a response element in the action <code>DescribeDBEngineVersions</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCustomDbEngineVersionResponse extends RdsResponse implements
        ToCopyableBuilder<ModifyCustomDbEngineVersionResponse.Builder, ModifyCustomDbEngineVersionResponse> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(ModifyCustomDbEngineVersionResponse::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ModifyCustomDbEngineVersionResponse::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> DB_PARAMETER_GROUP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBParameterGroupFamily").getter(getter(ModifyCustomDbEngineVersionResponse::dbParameterGroupFamily))
            .setter(setter(Builder::dbParameterGroupFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupFamily").build())
            .build();

    private static final SdkField<String> DB_ENGINE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBEngineDescription").getter(getter(ModifyCustomDbEngineVersionResponse::dbEngineDescription))
            .setter(setter(Builder::dbEngineDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineDescription").build())
            .build();

    private static final SdkField<String> DB_ENGINE_VERSION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBEngineVersionDescription")
            .getter(getter(ModifyCustomDbEngineVersionResponse::dbEngineVersionDescription))
            .setter(setter(Builder::dbEngineVersionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineVersionDescription").build())
            .build();

    private static final SdkField<CharacterSet> DEFAULT_CHARACTER_SET_FIELD = SdkField
            .<CharacterSet> builder(MarshallingType.SDK_POJO).memberName("DefaultCharacterSet")
            .getter(getter(ModifyCustomDbEngineVersionResponse::defaultCharacterSet))
            .setter(setter(Builder::defaultCharacterSet)).constructor(CharacterSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCharacterSet").build())
            .build();

    private static final SdkField<List<CharacterSet>> SUPPORTED_CHARACTER_SETS_FIELD = SdkField
            .<List<CharacterSet>> builder(MarshallingType.LIST)
            .memberName("SupportedCharacterSets")
            .getter(getter(ModifyCustomDbEngineVersionResponse::supportedCharacterSets))
            .setter(setter(Builder::supportedCharacterSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedCharacterSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CharacterSet")
                            .memberFieldInfo(
                                    SdkField.<CharacterSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(CharacterSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CharacterSet").build()).build()).build()).build();

    private static final SdkField<List<CharacterSet>> SUPPORTED_NCHAR_CHARACTER_SETS_FIELD = SdkField
            .<List<CharacterSet>> builder(MarshallingType.LIST)
            .memberName("SupportedNcharCharacterSets")
            .getter(getter(ModifyCustomDbEngineVersionResponse::supportedNcharCharacterSets))
            .setter(setter(Builder::supportedNcharCharacterSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedNcharCharacterSets")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CharacterSet")
                            .memberFieldInfo(
                                    SdkField.<CharacterSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(CharacterSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CharacterSet").build()).build()).build()).build();

    private static final SdkField<List<UpgradeTarget>> VALID_UPGRADE_TARGET_FIELD = SdkField
            .<List<UpgradeTarget>> builder(MarshallingType.LIST)
            .memberName("ValidUpgradeTarget")
            .getter(getter(ModifyCustomDbEngineVersionResponse::validUpgradeTarget))
            .setter(setter(Builder::validUpgradeTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUpgradeTarget").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("UpgradeTarget")
                            .memberFieldInfo(
                                    SdkField.<UpgradeTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpgradeTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("UpgradeTarget").build()).build()).build()).build();

    private static final SdkField<List<Timezone>> SUPPORTED_TIMEZONES_FIELD = SdkField
            .<List<Timezone>> builder(MarshallingType.LIST)
            .memberName("SupportedTimezones")
            .getter(getter(ModifyCustomDbEngineVersionResponse::supportedTimezones))
            .setter(setter(Builder::supportedTimezones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTimezones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Timezone")
                            .memberFieldInfo(
                                    SdkField.<Timezone> builder(MarshallingType.SDK_POJO)
                                            .constructor(Timezone::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Timezone").build()).build()).build()).build();

    private static final SdkField<List<String>> EXPORTABLE_LOG_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExportableLogTypes")
            .getter(getter(ModifyCustomDbEngineVersionResponse::exportableLogTypes))
            .setter(setter(Builder::exportableLogTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportableLogTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> SUPPORTS_LOG_EXPORTS_TO_CLOUDWATCH_LOGS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsLogExportsToCloudwatchLogs")
            .getter(getter(ModifyCustomDbEngineVersionResponse::supportsLogExportsToCloudwatchLogs))
            .setter(setter(Builder::supportsLogExportsToCloudwatchLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsLogExportsToCloudwatchLogs")
                    .build()).build();

    private static final SdkField<Boolean> SUPPORTS_READ_REPLICA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsReadReplica").getter(getter(ModifyCustomDbEngineVersionResponse::supportsReadReplica))
            .setter(setter(Builder::supportsReadReplica))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsReadReplica").build())
            .build();

    private static final SdkField<List<String>> SUPPORTED_ENGINE_MODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedEngineModes")
            .getter(getter(ModifyCustomDbEngineVersionResponse::supportedEngineModes))
            .setter(setter(Builder::supportedEngineModes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedEngineModes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_FEATURE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedFeatureNames")
            .getter(getter(ModifyCustomDbEngineVersionResponse::supportedFeatureNames))
            .setter(setter(Builder::supportedFeatureNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedFeatureNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ModifyCustomDbEngineVersionResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Boolean> SUPPORTS_PARALLEL_QUERY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsParallelQuery").getter(getter(ModifyCustomDbEngineVersionResponse::supportsParallelQuery))
            .setter(setter(Builder::supportsParallelQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsParallelQuery").build())
            .build();

    private static final SdkField<Boolean> SUPPORTS_GLOBAL_DATABASES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsGlobalDatabases").getter(getter(ModifyCustomDbEngineVersionResponse::supportsGlobalDatabases))
            .setter(setter(Builder::supportsGlobalDatabases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsGlobalDatabases").build())
            .build();

    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MajorEngineVersion").getter(getter(ModifyCustomDbEngineVersionResponse::majorEngineVersion))
            .setter(setter(Builder::majorEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build())
            .build();

    private static final SdkField<String> DATABASE_INSTALLATION_FILES_S3_BUCKET_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DatabaseInstallationFilesS3BucketName")
            .getter(getter(ModifyCustomDbEngineVersionResponse::databaseInstallationFilesS3BucketName))
            .setter(setter(Builder::databaseInstallationFilesS3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DatabaseInstallationFilesS3BucketName").build()).build();

    private static final SdkField<String> DATABASE_INSTALLATION_FILES_S3_PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DatabaseInstallationFilesS3Prefix")
            .getter(getter(ModifyCustomDbEngineVersionResponse::databaseInstallationFilesS3Prefix))
            .setter(setter(Builder::databaseInstallationFilesS3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInstallationFilesS3Prefix")
                    .build()).build();

    private static final SdkField<String> DB_ENGINE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBEngineVersionArn").getter(getter(ModifyCustomDbEngineVersionResponse::dbEngineVersionArn))
            .setter(setter(Builder::dbEngineVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineVersionArn").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyId").getter(getter(ModifyCustomDbEngineVersionResponse::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(ModifyCustomDbEngineVersionResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("TagList")
            .getter(getter(ModifyCustomDbEngineVersionResponse::tagList))
            .setter(setter(Builder::tagList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<Boolean> SUPPORTS_BABELFISH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsBabelfish").getter(getter(ModifyCustomDbEngineVersionResponse::supportsBabelfish))
            .setter(setter(Builder::supportsBabelfish))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsBabelfish").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            ENGINE_VERSION_FIELD, DB_PARAMETER_GROUP_FAMILY_FIELD, DB_ENGINE_DESCRIPTION_FIELD,
            DB_ENGINE_VERSION_DESCRIPTION_FIELD, DEFAULT_CHARACTER_SET_FIELD, SUPPORTED_CHARACTER_SETS_FIELD,
            SUPPORTED_NCHAR_CHARACTER_SETS_FIELD, VALID_UPGRADE_TARGET_FIELD, SUPPORTED_TIMEZONES_FIELD,
            EXPORTABLE_LOG_TYPES_FIELD, SUPPORTS_LOG_EXPORTS_TO_CLOUDWATCH_LOGS_FIELD, SUPPORTS_READ_REPLICA_FIELD,
            SUPPORTED_ENGINE_MODES_FIELD, SUPPORTED_FEATURE_NAMES_FIELD, STATUS_FIELD, SUPPORTS_PARALLEL_QUERY_FIELD,
            SUPPORTS_GLOBAL_DATABASES_FIELD, MAJOR_ENGINE_VERSION_FIELD, DATABASE_INSTALLATION_FILES_S3_BUCKET_NAME_FIELD,
            DATABASE_INSTALLATION_FILES_S3_PREFIX_FIELD, DB_ENGINE_VERSION_ARN_FIELD, KMS_KEY_ID_FIELD, CREATE_TIME_FIELD,
            TAG_LIST_FIELD, SUPPORTS_BABELFISH_FIELD));

    private final String engine;

    private final String engineVersion;

    private final String dbParameterGroupFamily;

    private final String dbEngineDescription;

    private final String dbEngineVersionDescription;

    private final CharacterSet defaultCharacterSet;

    private final List<CharacterSet> supportedCharacterSets;

    private final List<CharacterSet> supportedNcharCharacterSets;

    private final List<UpgradeTarget> validUpgradeTarget;

    private final List<Timezone> supportedTimezones;

    private final List<String> exportableLogTypes;

    private final Boolean supportsLogExportsToCloudwatchLogs;

    private final Boolean supportsReadReplica;

    private final List<String> supportedEngineModes;

    private final List<String> supportedFeatureNames;

    private final String status;

    private final Boolean supportsParallelQuery;

    private final Boolean supportsGlobalDatabases;

    private final String majorEngineVersion;

    private final String databaseInstallationFilesS3BucketName;

    private final String databaseInstallationFilesS3Prefix;

    private final String dbEngineVersionArn;

    private final String kmsKeyId;

    private final Instant createTime;

    private final List<Tag> tagList;

    private final Boolean supportsBabelfish;

    private ModifyCustomDbEngineVersionResponse(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.dbEngineDescription = builder.dbEngineDescription;
        this.dbEngineVersionDescription = builder.dbEngineVersionDescription;
        this.defaultCharacterSet = builder.defaultCharacterSet;
        this.supportedCharacterSets = builder.supportedCharacterSets;
        this.supportedNcharCharacterSets = builder.supportedNcharCharacterSets;
        this.validUpgradeTarget = builder.validUpgradeTarget;
        this.supportedTimezones = builder.supportedTimezones;
        this.exportableLogTypes = builder.exportableLogTypes;
        this.supportsLogExportsToCloudwatchLogs = builder.supportsLogExportsToCloudwatchLogs;
        this.supportsReadReplica = builder.supportsReadReplica;
        this.supportedEngineModes = builder.supportedEngineModes;
        this.supportedFeatureNames = builder.supportedFeatureNames;
        this.status = builder.status;
        this.supportsParallelQuery = builder.supportsParallelQuery;
        this.supportsGlobalDatabases = builder.supportsGlobalDatabases;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.databaseInstallationFilesS3BucketName = builder.databaseInstallationFilesS3BucketName;
        this.databaseInstallationFilesS3Prefix = builder.databaseInstallationFilesS3Prefix;
        this.dbEngineVersionArn = builder.dbEngineVersionArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.createTime = builder.createTime;
        this.tagList = builder.tagList;
        this.supportsBabelfish = builder.supportsBabelfish;
    }

    /**
     * <p>
     * The name of the database engine.
     * </p>
     * 
     * @return The name of the database engine.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version number of the database engine.
     * </p>
     * 
     * @return The version number of the database engine.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The name of the DB parameter group family for the database engine.
     * </p>
     * 
     * @return The name of the DB parameter group family for the database engine.
     */
    public final String dbParameterGroupFamily() {
        return dbParameterGroupFamily;
    }

    /**
     * <p>
     * The description of the database engine.
     * </p>
     * 
     * @return The description of the database engine.
     */
    public final String dbEngineDescription() {
        return dbEngineDescription;
    }

    /**
     * <p>
     * The description of the database engine version.
     * </p>
     * 
     * @return The description of the database engine version.
     */
    public final String dbEngineVersionDescription() {
        return dbEngineVersionDescription;
    }

    /**
     * <p>
     * The default character set for new instances of this engine version, if the <code>CharacterSetName</code>
     * parameter of the CreateDBInstance API isn't specified.
     * </p>
     * 
     * @return The default character set for new instances of this engine version, if the <code>CharacterSetName</code>
     *         parameter of the CreateDBInstance API isn't specified.
     */
    public final CharacterSet defaultCharacterSet() {
        return defaultCharacterSet;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedCharacterSets property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedCharacterSets() {
        return supportedCharacterSets != null && !(supportedCharacterSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the
     * <code>CreateDBInstance</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedCharacterSets} method.
     * </p>
     * 
     * @return A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of
     *         the <code>CreateDBInstance</code> operation.
     */
    public final List<CharacterSet> supportedCharacterSets() {
        return supportedCharacterSets;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedNcharCharacterSets property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedNcharCharacterSets() {
        return supportedNcharCharacterSets != null && !(supportedNcharCharacterSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code>
     * parameter of the <code>CreateDBInstance</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedNcharCharacterSets} method.
     * </p>
     * 
     * @return A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code>
     *         parameter of the <code>CreateDBInstance</code> operation.
     */
    public final List<CharacterSet> supportedNcharCharacterSets() {
        return supportedNcharCharacterSets;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValidUpgradeTarget property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasValidUpgradeTarget() {
        return validUpgradeTarget != null && !(validUpgradeTarget instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of engine versions that this database engine version can be upgraded to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidUpgradeTarget} method.
     * </p>
     * 
     * @return A list of engine versions that this database engine version can be upgraded to.
     */
    public final List<UpgradeTarget> validUpgradeTarget() {
        return validUpgradeTarget;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedTimezones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedTimezones() {
        return supportedTimezones != null && !(supportedTimezones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the time zones supported by this engine for the <code>Timezone</code> parameter of the
     * <code>CreateDBInstance</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedTimezones} method.
     * </p>
     * 
     * @return A list of the time zones supported by this engine for the <code>Timezone</code> parameter of the
     *         <code>CreateDBInstance</code> action.
     */
    public final List<Timezone> supportedTimezones() {
        return supportedTimezones;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExportableLogTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExportableLogTypes() {
        return exportableLogTypes != null && !(exportableLogTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of logs that the database engine has available for export to CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExportableLogTypes} method.
     * </p>
     * 
     * @return The types of logs that the database engine has available for export to CloudWatch Logs.
     */
    public final List<String> exportableLogTypes() {
        return exportableLogTypes;
    }

    /**
     * <p>
     * A value that indicates whether the engine version supports exporting the log types specified by
     * ExportableLogTypes to CloudWatch Logs.
     * </p>
     * 
     * @return A value that indicates whether the engine version supports exporting the log types specified by
     *         ExportableLogTypes to CloudWatch Logs.
     */
    public final Boolean supportsLogExportsToCloudwatchLogs() {
        return supportsLogExportsToCloudwatchLogs;
    }

    /**
     * <p>
     * Indicates whether the database engine version supports read replicas.
     * </p>
     * 
     * @return Indicates whether the database engine version supports read replicas.
     */
    public final Boolean supportsReadReplica() {
        return supportsReadReplica;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedEngineModes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedEngineModes() {
        return supportedEngineModes != null && !(supportedEngineModes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the supported DB engine modes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedEngineModes} method.
     * </p>
     * 
     * @return A list of the supported DB engine modes.
     */
    public final List<String> supportedEngineModes() {
        return supportedEngineModes;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedFeatureNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedFeatureNames() {
        return supportedFeatureNames != null && !(supportedFeatureNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of features supported by the DB engine.
     * </p>
     * <p>
     * The supported features vary by DB engine and DB engine version.
     * </p>
     * <p>
     * To determine the supported features for a specific DB engine and DB engine version using the CLI, use the
     * following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine &lt;engine_name&gt; --engine-version &lt;engine_version&gt;</code>
     * </p>
     * <p>
     * For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI, use the
     * following command:
     * </p>
     * <p>
     * <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
     * </p>
     * <p>
     * The supported features are listed under <code>SupportedFeatureNames</code> in the output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedFeatureNames} method.
     * </p>
     * 
     * @return A list of features supported by the DB engine.</p>
     *         <p>
     *         The supported features vary by DB engine and DB engine version.
     *         </p>
     *         <p>
     *         To determine the supported features for a specific DB engine and DB engine version using the CLI, use the
     *         following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine &lt;engine_name&gt; --engine-version &lt;engine_version&gt;</code>
     *         </p>
     *         <p>
     *         For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI, use
     *         the following command:
     *         </p>
     *         <p>
     *         <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
     *         </p>
     *         <p>
     *         The supported features are listed under <code>SupportedFeatureNames</code> in the output.
     */
    public final List<String> supportedFeatureNames() {
        return supportedFeatureNames;
    }

    /**
     * <p>
     * The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.
     * </p>
     * 
     * @return The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * A value that indicates whether you can use Aurora parallel query with a specific DB engine version.
     * </p>
     * 
     * @return A value that indicates whether you can use Aurora parallel query with a specific DB engine version.
     */
    public final Boolean supportsParallelQuery() {
        return supportsParallelQuery;
    }

    /**
     * <p>
     * A value that indicates whether you can use Aurora global databases with a specific DB engine version.
     * </p>
     * 
     * @return A value that indicates whether you can use Aurora global databases with a specific DB engine version.
     */
    public final Boolean supportsGlobalDatabases() {
        return supportsGlobalDatabases;
    }

    /**
     * <p>
     * The major engine version of the CEV.
     * </p>
     * 
     * @return The major engine version of the CEV.
     */
    public final String majorEngineVersion() {
        return majorEngineVersion;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket that contains your database installation files.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket that contains your database installation files.
     */
    public final String databaseInstallationFilesS3BucketName() {
        return databaseInstallationFilesS3BucketName;
    }

    /**
     * <p>
     * The Amazon S3 directory that contains the database installation files. If not specified, then no prefix is
     * assumed.
     * </p>
     * 
     * @return The Amazon S3 directory that contains the database installation files. If not specified, then no prefix
     *         is assumed.
     */
    public final String databaseInstallationFilesS3Prefix() {
        return databaseInstallationFilesS3Prefix;
    }

    /**
     * <p>
     * The ARN of the custom engine version.
     * </p>
     * 
     * @return The ARN of the custom engine version.
     */
    public final String dbEngineVersionArn() {
        return dbEngineVersionArn;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for RDS Custom, but
     * optional for Amazon RDS.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for RDS
     *         Custom, but optional for Amazon RDS.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The creation time of the DB engine version.
     * </p>
     * 
     * @return The creation time of the DB engine version.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagList() {
        return tagList != null && !(tagList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TagList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagList} method.
     * </p>
     * 
     * @return The value of the TagList property for this object.
     */
    public final List<Tag> tagList() {
        return tagList;
    }

    /**
     * <p>
     * A value that indicates whether the engine version supports Babelfish for Aurora PostgreSQL.
     * </p>
     * 
     * @return A value that indicates whether the engine version supports Babelfish for Aurora PostgreSQL.
     */
    public final Boolean supportsBabelfish() {
        return supportsBabelfish;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(dbEngineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(dbEngineVersionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCharacterSet());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedCharacterSets() ? supportedCharacterSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedNcharCharacterSets() ? supportedNcharCharacterSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValidUpgradeTarget() ? validUpgradeTarget() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedTimezones() ? supportedTimezones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExportableLogTypes() ? exportableLogTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(supportsLogExportsToCloudwatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(supportsReadReplica());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedEngineModes() ? supportedEngineModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedFeatureNames() ? supportedFeatureNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(supportsParallelQuery());
        hashCode = 31 * hashCode + Objects.hashCode(supportsGlobalDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(databaseInstallationFilesS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseInstallationFilesS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(dbEngineVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagList() ? tagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(supportsBabelfish());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCustomDbEngineVersionResponse)) {
            return false;
        }
        ModifyCustomDbEngineVersionResponse other = (ModifyCustomDbEngineVersionResponse) obj;
        return Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(dbParameterGroupFamily(), other.dbParameterGroupFamily())
                && Objects.equals(dbEngineDescription(), other.dbEngineDescription())
                && Objects.equals(dbEngineVersionDescription(), other.dbEngineVersionDescription())
                && Objects.equals(defaultCharacterSet(), other.defaultCharacterSet())
                && hasSupportedCharacterSets() == other.hasSupportedCharacterSets()
                && Objects.equals(supportedCharacterSets(), other.supportedCharacterSets())
                && hasSupportedNcharCharacterSets() == other.hasSupportedNcharCharacterSets()
                && Objects.equals(supportedNcharCharacterSets(), other.supportedNcharCharacterSets())
                && hasValidUpgradeTarget() == other.hasValidUpgradeTarget()
                && Objects.equals(validUpgradeTarget(), other.validUpgradeTarget())
                && hasSupportedTimezones() == other.hasSupportedTimezones()
                && Objects.equals(supportedTimezones(), other.supportedTimezones())
                && hasExportableLogTypes() == other.hasExportableLogTypes()
                && Objects.equals(exportableLogTypes(), other.exportableLogTypes())
                && Objects.equals(supportsLogExportsToCloudwatchLogs(), other.supportsLogExportsToCloudwatchLogs())
                && Objects.equals(supportsReadReplica(), other.supportsReadReplica())
                && hasSupportedEngineModes() == other.hasSupportedEngineModes()
                && Objects.equals(supportedEngineModes(), other.supportedEngineModes())
                && hasSupportedFeatureNames() == other.hasSupportedFeatureNames()
                && Objects.equals(supportedFeatureNames(), other.supportedFeatureNames())
                && Objects.equals(status(), other.status())
                && Objects.equals(supportsParallelQuery(), other.supportsParallelQuery())
                && Objects.equals(supportsGlobalDatabases(), other.supportsGlobalDatabases())
                && Objects.equals(majorEngineVersion(), other.majorEngineVersion())
                && Objects.equals(databaseInstallationFilesS3BucketName(), other.databaseInstallationFilesS3BucketName())
                && Objects.equals(databaseInstallationFilesS3Prefix(), other.databaseInstallationFilesS3Prefix())
                && Objects.equals(dbEngineVersionArn(), other.dbEngineVersionArn())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(createTime(), other.createTime())
                && hasTagList() == other.hasTagList() && Objects.equals(tagList(), other.tagList())
                && Objects.equals(supportsBabelfish(), other.supportsBabelfish());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyCustomDbEngineVersionResponse").add("Engine", engine())
                .add("EngineVersion", engineVersion()).add("DBParameterGroupFamily", dbParameterGroupFamily())
                .add("DBEngineDescription", dbEngineDescription())
                .add("DBEngineVersionDescription", dbEngineVersionDescription())
                .add("DefaultCharacterSet", defaultCharacterSet())
                .add("SupportedCharacterSets", hasSupportedCharacterSets() ? supportedCharacterSets() : null)
                .add("SupportedNcharCharacterSets", hasSupportedNcharCharacterSets() ? supportedNcharCharacterSets() : null)
                .add("ValidUpgradeTarget", hasValidUpgradeTarget() ? validUpgradeTarget() : null)
                .add("SupportedTimezones", hasSupportedTimezones() ? supportedTimezones() : null)
                .add("ExportableLogTypes", hasExportableLogTypes() ? exportableLogTypes() : null)
                .add("SupportsLogExportsToCloudwatchLogs", supportsLogExportsToCloudwatchLogs())
                .add("SupportsReadReplica", supportsReadReplica())
                .add("SupportedEngineModes", hasSupportedEngineModes() ? supportedEngineModes() : null)
                .add("SupportedFeatureNames", hasSupportedFeatureNames() ? supportedFeatureNames() : null)
                .add("Status", status()).add("SupportsParallelQuery", supportsParallelQuery())
                .add("SupportsGlobalDatabases", supportsGlobalDatabases()).add("MajorEngineVersion", majorEngineVersion())
                .add("DatabaseInstallationFilesS3BucketName", databaseInstallationFilesS3BucketName())
                .add("DatabaseInstallationFilesS3Prefix", databaseInstallationFilesS3Prefix())
                .add("DBEngineVersionArn", dbEngineVersionArn()).add("KMSKeyId", kmsKeyId()).add("CreateTime", createTime())
                .add("TagList", hasTagList() ? tagList() : null).add("SupportsBabelfish", supportsBabelfish()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "DBParameterGroupFamily":
            return Optional.ofNullable(clazz.cast(dbParameterGroupFamily()));
        case "DBEngineDescription":
            return Optional.ofNullable(clazz.cast(dbEngineDescription()));
        case "DBEngineVersionDescription":
            return Optional.ofNullable(clazz.cast(dbEngineVersionDescription()));
        case "DefaultCharacterSet":
            return Optional.ofNullable(clazz.cast(defaultCharacterSet()));
        case "SupportedCharacterSets":
            return Optional.ofNullable(clazz.cast(supportedCharacterSets()));
        case "SupportedNcharCharacterSets":
            return Optional.ofNullable(clazz.cast(supportedNcharCharacterSets()));
        case "ValidUpgradeTarget":
            return Optional.ofNullable(clazz.cast(validUpgradeTarget()));
        case "SupportedTimezones":
            return Optional.ofNullable(clazz.cast(supportedTimezones()));
        case "ExportableLogTypes":
            return Optional.ofNullable(clazz.cast(exportableLogTypes()));
        case "SupportsLogExportsToCloudwatchLogs":
            return Optional.ofNullable(clazz.cast(supportsLogExportsToCloudwatchLogs()));
        case "SupportsReadReplica":
            return Optional.ofNullable(clazz.cast(supportsReadReplica()));
        case "SupportedEngineModes":
            return Optional.ofNullable(clazz.cast(supportedEngineModes()));
        case "SupportedFeatureNames":
            return Optional.ofNullable(clazz.cast(supportedFeatureNames()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "SupportsParallelQuery":
            return Optional.ofNullable(clazz.cast(supportsParallelQuery()));
        case "SupportsGlobalDatabases":
            return Optional.ofNullable(clazz.cast(supportsGlobalDatabases()));
        case "MajorEngineVersion":
            return Optional.ofNullable(clazz.cast(majorEngineVersion()));
        case "DatabaseInstallationFilesS3BucketName":
            return Optional.ofNullable(clazz.cast(databaseInstallationFilesS3BucketName()));
        case "DatabaseInstallationFilesS3Prefix":
            return Optional.ofNullable(clazz.cast(databaseInstallationFilesS3Prefix()));
        case "DBEngineVersionArn":
            return Optional.ofNullable(clazz.cast(dbEngineVersionArn()));
        case "KMSKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "TagList":
            return Optional.ofNullable(clazz.cast(tagList()));
        case "SupportsBabelfish":
            return Optional.ofNullable(clazz.cast(supportsBabelfish()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCustomDbEngineVersionResponse, T> g) {
        return obj -> g.apply((ModifyCustomDbEngineVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ModifyCustomDbEngineVersionResponse> {
        /**
         * <p>
         * The name of the database engine.
         * </p>
         * 
         * @param engine
         *        The name of the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version number of the database engine.
         * </p>
         * 
         * @param engineVersion
         *        The version number of the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The name of the DB parameter group family for the database engine.
         * </p>
         * 
         * @param dbParameterGroupFamily
         *        The name of the DB parameter group family for the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupFamily(String dbParameterGroupFamily);

        /**
         * <p>
         * The description of the database engine.
         * </p>
         * 
         * @param dbEngineDescription
         *        The description of the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbEngineDescription(String dbEngineDescription);

        /**
         * <p>
         * The description of the database engine version.
         * </p>
         * 
         * @param dbEngineVersionDescription
         *        The description of the database engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbEngineVersionDescription(String dbEngineVersionDescription);

        /**
         * <p>
         * The default character set for new instances of this engine version, if the <code>CharacterSetName</code>
         * parameter of the CreateDBInstance API isn't specified.
         * </p>
         * 
         * @param defaultCharacterSet
         *        The default character set for new instances of this engine version, if the
         *        <code>CharacterSetName</code> parameter of the CreateDBInstance API isn't specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCharacterSet(CharacterSet defaultCharacterSet);

        /**
         * <p>
         * The default character set for new instances of this engine version, if the <code>CharacterSetName</code>
         * parameter of the CreateDBInstance API isn't specified.
         * </p>
         * This is a convenience method that creates an instance of the {@link CharacterSet.Builder} avoiding the need
         * to create one manually via {@link CharacterSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CharacterSet.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultCharacterSet(CharacterSet)}.
         * 
         * @param defaultCharacterSet
         *        a consumer that will call methods on {@link CharacterSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultCharacterSet(CharacterSet)
         */
        default Builder defaultCharacterSet(Consumer<CharacterSet.Builder> defaultCharacterSet) {
            return defaultCharacterSet(CharacterSet.builder().applyMutation(defaultCharacterSet).build());
        }

        /**
         * <p>
         * A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the
         * <code>CreateDBInstance</code> operation.
         * </p>
         * 
         * @param supportedCharacterSets
         *        A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter
         *        of the <code>CreateDBInstance</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedCharacterSets(Collection<CharacterSet> supportedCharacterSets);

        /**
         * <p>
         * A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the
         * <code>CreateDBInstance</code> operation.
         * </p>
         * 
         * @param supportedCharacterSets
         *        A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter
         *        of the <code>CreateDBInstance</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedCharacterSets(CharacterSet... supportedCharacterSets);

        /**
         * <p>
         * A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the
         * <code>CreateDBInstance</code> operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.CharacterSet.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.CharacterSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.CharacterSet.Builder#build()} is called immediately and its
         * result is passed to {@link #supportedCharacterSets(List<CharacterSet>)}.
         * 
         * @param supportedCharacterSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.CharacterSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedCharacterSets(java.util.Collection<CharacterSet>)
         */
        Builder supportedCharacterSets(Consumer<CharacterSet.Builder>... supportedCharacterSets);

        /**
         * <p>
         * A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code>
         * parameter of the <code>CreateDBInstance</code> operation.
         * </p>
         * 
         * @param supportedNcharCharacterSets
         *        A list of the character sets supported by the Oracle DB engine for the
         *        <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedNcharCharacterSets(Collection<CharacterSet> supportedNcharCharacterSets);

        /**
         * <p>
         * A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code>
         * parameter of the <code>CreateDBInstance</code> operation.
         * </p>
         * 
         * @param supportedNcharCharacterSets
         *        A list of the character sets supported by the Oracle DB engine for the
         *        <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedNcharCharacterSets(CharacterSet... supportedNcharCharacterSets);

        /**
         * <p>
         * A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code>
         * parameter of the <code>CreateDBInstance</code> operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.CharacterSet.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.CharacterSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.CharacterSet.Builder#build()} is called immediately and its
         * result is passed to {@link #supportedNcharCharacterSets(List<CharacterSet>)}.
         * 
         * @param supportedNcharCharacterSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.CharacterSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedNcharCharacterSets(java.util.Collection<CharacterSet>)
         */
        Builder supportedNcharCharacterSets(Consumer<CharacterSet.Builder>... supportedNcharCharacterSets);

        /**
         * <p>
         * A list of engine versions that this database engine version can be upgraded to.
         * </p>
         * 
         * @param validUpgradeTarget
         *        A list of engine versions that this database engine version can be upgraded to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUpgradeTarget(Collection<UpgradeTarget> validUpgradeTarget);

        /**
         * <p>
         * A list of engine versions that this database engine version can be upgraded to.
         * </p>
         * 
         * @param validUpgradeTarget
         *        A list of engine versions that this database engine version can be upgraded to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUpgradeTarget(UpgradeTarget... validUpgradeTarget);

        /**
         * <p>
         * A list of engine versions that this database engine version can be upgraded to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.UpgradeTarget.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.UpgradeTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.UpgradeTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #validUpgradeTarget(List<UpgradeTarget>)}.
         * 
         * @param validUpgradeTarget
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.UpgradeTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validUpgradeTarget(java.util.Collection<UpgradeTarget>)
         */
        Builder validUpgradeTarget(Consumer<UpgradeTarget.Builder>... validUpgradeTarget);

        /**
         * <p>
         * A list of the time zones supported by this engine for the <code>Timezone</code> parameter of the
         * <code>CreateDBInstance</code> action.
         * </p>
         * 
         * @param supportedTimezones
         *        A list of the time zones supported by this engine for the <code>Timezone</code> parameter of the
         *        <code>CreateDBInstance</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTimezones(Collection<Timezone> supportedTimezones);

        /**
         * <p>
         * A list of the time zones supported by this engine for the <code>Timezone</code> parameter of the
         * <code>CreateDBInstance</code> action.
         * </p>
         * 
         * @param supportedTimezones
         *        A list of the time zones supported by this engine for the <code>Timezone</code> parameter of the
         *        <code>CreateDBInstance</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTimezones(Timezone... supportedTimezones);

        /**
         * <p>
         * A list of the time zones supported by this engine for the <code>Timezone</code> parameter of the
         * <code>CreateDBInstance</code> action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Timezone.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.rds.model.Timezone#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.Timezone.Builder#build()} is called immediately and its
         * result is passed to {@link #supportedTimezones(List<Timezone>)}.
         * 
         * @param supportedTimezones
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.Timezone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedTimezones(java.util.Collection<Timezone>)
         */
        Builder supportedTimezones(Consumer<Timezone.Builder>... supportedTimezones);

        /**
         * <p>
         * The types of logs that the database engine has available for export to CloudWatch Logs.
         * </p>
         * 
         * @param exportableLogTypes
         *        The types of logs that the database engine has available for export to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportableLogTypes(Collection<String> exportableLogTypes);

        /**
         * <p>
         * The types of logs that the database engine has available for export to CloudWatch Logs.
         * </p>
         * 
         * @param exportableLogTypes
         *        The types of logs that the database engine has available for export to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportableLogTypes(String... exportableLogTypes);

        /**
         * <p>
         * A value that indicates whether the engine version supports exporting the log types specified by
         * ExportableLogTypes to CloudWatch Logs.
         * </p>
         * 
         * @param supportsLogExportsToCloudwatchLogs
         *        A value that indicates whether the engine version supports exporting the log types specified by
         *        ExportableLogTypes to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs);

        /**
         * <p>
         * Indicates whether the database engine version supports read replicas.
         * </p>
         * 
         * @param supportsReadReplica
         *        Indicates whether the database engine version supports read replicas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsReadReplica(Boolean supportsReadReplica);

        /**
         * <p>
         * A list of the supported DB engine modes.
         * </p>
         * 
         * @param supportedEngineModes
         *        A list of the supported DB engine modes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEngineModes(Collection<String> supportedEngineModes);

        /**
         * <p>
         * A list of the supported DB engine modes.
         * </p>
         * 
         * @param supportedEngineModes
         *        A list of the supported DB engine modes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEngineModes(String... supportedEngineModes);

        /**
         * <p>
         * A list of features supported by the DB engine.
         * </p>
         * <p>
         * The supported features vary by DB engine and DB engine version.
         * </p>
         * <p>
         * To determine the supported features for a specific DB engine and DB engine version using the CLI, use the
         * following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine &lt;engine_name&gt; --engine-version &lt;engine_version&gt;</code>
         * </p>
         * <p>
         * For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI, use the
         * following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
         * </p>
         * <p>
         * The supported features are listed under <code>SupportedFeatureNames</code> in the output.
         * </p>
         * 
         * @param supportedFeatureNames
         *        A list of features supported by the DB engine.</p>
         *        <p>
         *        The supported features vary by DB engine and DB engine version.
         *        </p>
         *        <p>
         *        To determine the supported features for a specific DB engine and DB engine version using the CLI, use
         *        the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine &lt;engine_name&gt; --engine-version &lt;engine_version&gt;</code>
         *        </p>
         *        <p>
         *        For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI,
         *        use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
         *        </p>
         *        <p>
         *        The supported features are listed under <code>SupportedFeatureNames</code> in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedFeatureNames(Collection<String> supportedFeatureNames);

        /**
         * <p>
         * A list of features supported by the DB engine.
         * </p>
         * <p>
         * The supported features vary by DB engine and DB engine version.
         * </p>
         * <p>
         * To determine the supported features for a specific DB engine and DB engine version using the CLI, use the
         * following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine &lt;engine_name&gt; --engine-version &lt;engine_version&gt;</code>
         * </p>
         * <p>
         * For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI, use the
         * following command:
         * </p>
         * <p>
         * <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
         * </p>
         * <p>
         * The supported features are listed under <code>SupportedFeatureNames</code> in the output.
         * </p>
         * 
         * @param supportedFeatureNames
         *        A list of features supported by the DB engine.</p>
         *        <p>
         *        The supported features vary by DB engine and DB engine version.
         *        </p>
         *        <p>
         *        To determine the supported features for a specific DB engine and DB engine version using the CLI, use
         *        the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine &lt;engine_name&gt; --engine-version &lt;engine_version&gt;</code>
         *        </p>
         *        <p>
         *        For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI,
         *        use the following command:
         *        </p>
         *        <p>
         *        <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
         *        </p>
         *        <p>
         *        The supported features are listed under <code>SupportedFeatureNames</code> in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedFeatureNames(String... supportedFeatureNames);

        /**
         * <p>
         * The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.
         * </p>
         * 
         * @param status
         *        The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A value that indicates whether you can use Aurora parallel query with a specific DB engine version.
         * </p>
         * 
         * @param supportsParallelQuery
         *        A value that indicates whether you can use Aurora parallel query with a specific DB engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsParallelQuery(Boolean supportsParallelQuery);

        /**
         * <p>
         * A value that indicates whether you can use Aurora global databases with a specific DB engine version.
         * </p>
         * 
         * @param supportsGlobalDatabases
         *        A value that indicates whether you can use Aurora global databases with a specific DB engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsGlobalDatabases(Boolean supportsGlobalDatabases);

        /**
         * <p>
         * The major engine version of the CEV.
         * </p>
         * 
         * @param majorEngineVersion
         *        The major engine version of the CEV.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorEngineVersion(String majorEngineVersion);

        /**
         * <p>
         * The name of the Amazon S3 bucket that contains your database installation files.
         * </p>
         * 
         * @param databaseInstallationFilesS3BucketName
         *        The name of the Amazon S3 bucket that contains your database installation files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseInstallationFilesS3BucketName(String databaseInstallationFilesS3BucketName);

        /**
         * <p>
         * The Amazon S3 directory that contains the database installation files. If not specified, then no prefix is
         * assumed.
         * </p>
         * 
         * @param databaseInstallationFilesS3Prefix
         *        The Amazon S3 directory that contains the database installation files. If not specified, then no
         *        prefix is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseInstallationFilesS3Prefix(String databaseInstallationFilesS3Prefix);

        /**
         * <p>
         * The ARN of the custom engine version.
         * </p>
         * 
         * @param dbEngineVersionArn
         *        The ARN of the custom engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbEngineVersionArn(String dbEngineVersionArn);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for RDS Custom,
         * but optional for Amazon RDS.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for RDS
         *        Custom, but optional for Amazon RDS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The creation time of the DB engine version.
         * </p>
         * 
         * @param createTime
         *        The creation time of the DB engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<Tag> tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Tag... tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tagList(List<Tag>)}.
         * 
         * @param tagList
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagList(java.util.Collection<Tag>)
         */
        Builder tagList(Consumer<Tag.Builder>... tagList);

        /**
         * <p>
         * A value that indicates whether the engine version supports Babelfish for Aurora PostgreSQL.
         * </p>
         * 
         * @param supportsBabelfish
         *        A value that indicates whether the engine version supports Babelfish for Aurora PostgreSQL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsBabelfish(Boolean supportsBabelfish);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String engine;

        private String engineVersion;

        private String dbParameterGroupFamily;

        private String dbEngineDescription;

        private String dbEngineVersionDescription;

        private CharacterSet defaultCharacterSet;

        private List<CharacterSet> supportedCharacterSets = DefaultSdkAutoConstructList.getInstance();

        private List<CharacterSet> supportedNcharCharacterSets = DefaultSdkAutoConstructList.getInstance();

        private List<UpgradeTarget> validUpgradeTarget = DefaultSdkAutoConstructList.getInstance();

        private List<Timezone> supportedTimezones = DefaultSdkAutoConstructList.getInstance();

        private List<String> exportableLogTypes = DefaultSdkAutoConstructList.getInstance();

        private Boolean supportsLogExportsToCloudwatchLogs;

        private Boolean supportsReadReplica;

        private List<String> supportedEngineModes = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedFeatureNames = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Boolean supportsParallelQuery;

        private Boolean supportsGlobalDatabases;

        private String majorEngineVersion;

        private String databaseInstallationFilesS3BucketName;

        private String databaseInstallationFilesS3Prefix;

        private String dbEngineVersionArn;

        private String kmsKeyId;

        private Instant createTime;

        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private Boolean supportsBabelfish;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCustomDbEngineVersionResponse model) {
            super(model);
            engine(model.engine);
            engineVersion(model.engineVersion);
            dbParameterGroupFamily(model.dbParameterGroupFamily);
            dbEngineDescription(model.dbEngineDescription);
            dbEngineVersionDescription(model.dbEngineVersionDescription);
            defaultCharacterSet(model.defaultCharacterSet);
            supportedCharacterSets(model.supportedCharacterSets);
            supportedNcharCharacterSets(model.supportedNcharCharacterSets);
            validUpgradeTarget(model.validUpgradeTarget);
            supportedTimezones(model.supportedTimezones);
            exportableLogTypes(model.exportableLogTypes);
            supportsLogExportsToCloudwatchLogs(model.supportsLogExportsToCloudwatchLogs);
            supportsReadReplica(model.supportsReadReplica);
            supportedEngineModes(model.supportedEngineModes);
            supportedFeatureNames(model.supportedFeatureNames);
            status(model.status);
            supportsParallelQuery(model.supportsParallelQuery);
            supportsGlobalDatabases(model.supportsGlobalDatabases);
            majorEngineVersion(model.majorEngineVersion);
            databaseInstallationFilesS3BucketName(model.databaseInstallationFilesS3BucketName);
            databaseInstallationFilesS3Prefix(model.databaseInstallationFilesS3Prefix);
            dbEngineVersionArn(model.dbEngineVersionArn);
            kmsKeyId(model.kmsKeyId);
            createTime(model.createTime);
            tagList(model.tagList);
            supportsBabelfish(model.supportsBabelfish);
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDbParameterGroupFamily() {
            return dbParameterGroupFamily;
        }

        public final void setDbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final String getDbEngineDescription() {
            return dbEngineDescription;
        }

        public final void setDbEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
        }

        @Override
        public final Builder dbEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
            return this;
        }

        public final String getDbEngineVersionDescription() {
            return dbEngineVersionDescription;
        }

        public final void setDbEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
        }

        @Override
        public final Builder dbEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
            return this;
        }

        public final CharacterSet.Builder getDefaultCharacterSet() {
            return defaultCharacterSet != null ? defaultCharacterSet.toBuilder() : null;
        }

        public final void setDefaultCharacterSet(CharacterSet.BuilderImpl defaultCharacterSet) {
            this.defaultCharacterSet = defaultCharacterSet != null ? defaultCharacterSet.build() : null;
        }

        @Override
        public final Builder defaultCharacterSet(CharacterSet defaultCharacterSet) {
            this.defaultCharacterSet = defaultCharacterSet;
            return this;
        }

        public final List<CharacterSet.Builder> getSupportedCharacterSets() {
            List<CharacterSet.Builder> result = SupportedCharacterSetsListCopier.copyToBuilder(this.supportedCharacterSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedCharacterSets(Collection<CharacterSet.BuilderImpl> supportedCharacterSets) {
            this.supportedCharacterSets = SupportedCharacterSetsListCopier.copyFromBuilder(supportedCharacterSets);
        }

        @Override
        public final Builder supportedCharacterSets(Collection<CharacterSet> supportedCharacterSets) {
            this.supportedCharacterSets = SupportedCharacterSetsListCopier.copy(supportedCharacterSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedCharacterSets(CharacterSet... supportedCharacterSets) {
            supportedCharacterSets(Arrays.asList(supportedCharacterSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedCharacterSets(Consumer<CharacterSet.Builder>... supportedCharacterSets) {
            supportedCharacterSets(Stream.of(supportedCharacterSets).map(c -> CharacterSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CharacterSet.Builder> getSupportedNcharCharacterSets() {
            List<CharacterSet.Builder> result = SupportedCharacterSetsListCopier.copyToBuilder(this.supportedNcharCharacterSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedNcharCharacterSets(Collection<CharacterSet.BuilderImpl> supportedNcharCharacterSets) {
            this.supportedNcharCharacterSets = SupportedCharacterSetsListCopier.copyFromBuilder(supportedNcharCharacterSets);
        }

        @Override
        public final Builder supportedNcharCharacterSets(Collection<CharacterSet> supportedNcharCharacterSets) {
            this.supportedNcharCharacterSets = SupportedCharacterSetsListCopier.copy(supportedNcharCharacterSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNcharCharacterSets(CharacterSet... supportedNcharCharacterSets) {
            supportedNcharCharacterSets(Arrays.asList(supportedNcharCharacterSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNcharCharacterSets(Consumer<CharacterSet.Builder>... supportedNcharCharacterSets) {
            supportedNcharCharacterSets(Stream.of(supportedNcharCharacterSets)
                    .map(c -> CharacterSet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UpgradeTarget.Builder> getValidUpgradeTarget() {
            List<UpgradeTarget.Builder> result = ValidUpgradeTargetListCopier.copyToBuilder(this.validUpgradeTarget);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidUpgradeTarget(Collection<UpgradeTarget.BuilderImpl> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copyFromBuilder(validUpgradeTarget);
        }

        @Override
        public final Builder validUpgradeTarget(Collection<UpgradeTarget> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copy(validUpgradeTarget);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUpgradeTarget(UpgradeTarget... validUpgradeTarget) {
            validUpgradeTarget(Arrays.asList(validUpgradeTarget));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUpgradeTarget(Consumer<UpgradeTarget.Builder>... validUpgradeTarget) {
            validUpgradeTarget(Stream.of(validUpgradeTarget).map(c -> UpgradeTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Timezone.Builder> getSupportedTimezones() {
            List<Timezone.Builder> result = SupportedTimezonesListCopier.copyToBuilder(this.supportedTimezones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedTimezones(Collection<Timezone.BuilderImpl> supportedTimezones) {
            this.supportedTimezones = SupportedTimezonesListCopier.copyFromBuilder(supportedTimezones);
        }

        @Override
        public final Builder supportedTimezones(Collection<Timezone> supportedTimezones) {
            this.supportedTimezones = SupportedTimezonesListCopier.copy(supportedTimezones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTimezones(Timezone... supportedTimezones) {
            supportedTimezones(Arrays.asList(supportedTimezones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTimezones(Consumer<Timezone.Builder>... supportedTimezones) {
            supportedTimezones(Stream.of(supportedTimezones).map(c -> Timezone.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getExportableLogTypes() {
            if (exportableLogTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return exportableLogTypes;
        }

        public final void setExportableLogTypes(Collection<String> exportableLogTypes) {
            this.exportableLogTypes = LogTypeListCopier.copy(exportableLogTypes);
        }

        @Override
        public final Builder exportableLogTypes(Collection<String> exportableLogTypes) {
            this.exportableLogTypes = LogTypeListCopier.copy(exportableLogTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportableLogTypes(String... exportableLogTypes) {
            exportableLogTypes(Arrays.asList(exportableLogTypes));
            return this;
        }

        public final Boolean getSupportsLogExportsToCloudwatchLogs() {
            return supportsLogExportsToCloudwatchLogs;
        }

        public final void setSupportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs) {
            this.supportsLogExportsToCloudwatchLogs = supportsLogExportsToCloudwatchLogs;
        }

        @Override
        public final Builder supportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs) {
            this.supportsLogExportsToCloudwatchLogs = supportsLogExportsToCloudwatchLogs;
            return this;
        }

        public final Boolean getSupportsReadReplica() {
            return supportsReadReplica;
        }

        public final void setSupportsReadReplica(Boolean supportsReadReplica) {
            this.supportsReadReplica = supportsReadReplica;
        }

        @Override
        public final Builder supportsReadReplica(Boolean supportsReadReplica) {
            this.supportsReadReplica = supportsReadReplica;
            return this;
        }

        public final Collection<String> getSupportedEngineModes() {
            if (supportedEngineModes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedEngineModes;
        }

        public final void setSupportedEngineModes(Collection<String> supportedEngineModes) {
            this.supportedEngineModes = EngineModeListCopier.copy(supportedEngineModes);
        }

        @Override
        public final Builder supportedEngineModes(Collection<String> supportedEngineModes) {
            this.supportedEngineModes = EngineModeListCopier.copy(supportedEngineModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEngineModes(String... supportedEngineModes) {
            supportedEngineModes(Arrays.asList(supportedEngineModes));
            return this;
        }

        public final Collection<String> getSupportedFeatureNames() {
            if (supportedFeatureNames instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedFeatureNames;
        }

        public final void setSupportedFeatureNames(Collection<String> supportedFeatureNames) {
            this.supportedFeatureNames = FeatureNameListCopier.copy(supportedFeatureNames);
        }

        @Override
        public final Builder supportedFeatureNames(Collection<String> supportedFeatureNames) {
            this.supportedFeatureNames = FeatureNameListCopier.copy(supportedFeatureNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFeatureNames(String... supportedFeatureNames) {
            supportedFeatureNames(Arrays.asList(supportedFeatureNames));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getSupportsParallelQuery() {
            return supportsParallelQuery;
        }

        public final void setSupportsParallelQuery(Boolean supportsParallelQuery) {
            this.supportsParallelQuery = supportsParallelQuery;
        }

        @Override
        public final Builder supportsParallelQuery(Boolean supportsParallelQuery) {
            this.supportsParallelQuery = supportsParallelQuery;
            return this;
        }

        public final Boolean getSupportsGlobalDatabases() {
            return supportsGlobalDatabases;
        }

        public final void setSupportsGlobalDatabases(Boolean supportsGlobalDatabases) {
            this.supportsGlobalDatabases = supportsGlobalDatabases;
        }

        @Override
        public final Builder supportsGlobalDatabases(Boolean supportsGlobalDatabases) {
            this.supportsGlobalDatabases = supportsGlobalDatabases;
            return this;
        }

        public final String getMajorEngineVersion() {
            return majorEngineVersion;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final String getDatabaseInstallationFilesS3BucketName() {
            return databaseInstallationFilesS3BucketName;
        }

        public final void setDatabaseInstallationFilesS3BucketName(String databaseInstallationFilesS3BucketName) {
            this.databaseInstallationFilesS3BucketName = databaseInstallationFilesS3BucketName;
        }

        @Override
        public final Builder databaseInstallationFilesS3BucketName(String databaseInstallationFilesS3BucketName) {
            this.databaseInstallationFilesS3BucketName = databaseInstallationFilesS3BucketName;
            return this;
        }

        public final String getDatabaseInstallationFilesS3Prefix() {
            return databaseInstallationFilesS3Prefix;
        }

        public final void setDatabaseInstallationFilesS3Prefix(String databaseInstallationFilesS3Prefix) {
            this.databaseInstallationFilesS3Prefix = databaseInstallationFilesS3Prefix;
        }

        @Override
        public final Builder databaseInstallationFilesS3Prefix(String databaseInstallationFilesS3Prefix) {
            this.databaseInstallationFilesS3Prefix = databaseInstallationFilesS3Prefix;
            return this;
        }

        public final String getDbEngineVersionArn() {
            return dbEngineVersionArn;
        }

        public final void setDbEngineVersionArn(String dbEngineVersionArn) {
            this.dbEngineVersionArn = dbEngineVersionArn;
        }

        @Override
        public final Builder dbEngineVersionArn(String dbEngineVersionArn) {
            this.dbEngineVersionArn = dbEngineVersionArn;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag... tagList) {
            tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder>... tagList) {
            tagList(Stream.of(tagList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSupportsBabelfish() {
            return supportsBabelfish;
        }

        public final void setSupportsBabelfish(Boolean supportsBabelfish) {
            this.supportsBabelfish = supportsBabelfish;
        }

        @Override
        public final Builder supportsBabelfish(Boolean supportsBabelfish) {
            this.supportsBabelfish = supportsBabelfish;
            return this;
        }

        @Override
        public ModifyCustomDbEngineVersionResponse build() {
            return new ModifyCustomDbEngineVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
