/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbProxyEndpointRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyDbProxyEndpointRequest.Builder, ModifyDbProxyEndpointRequest> {
    private static final SdkField<String> DB_PROXY_ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBProxyEndpointName").getter(getter(ModifyDbProxyEndpointRequest::dbProxyEndpointName))
            .setter(setter(Builder::dbProxyEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyEndpointName").build())
            .build();

    private static final SdkField<String> NEW_DB_PROXY_ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewDBProxyEndpointName").getter(getter(ModifyDbProxyEndpointRequest::newDBProxyEndpointName))
            .setter(setter(Builder::newDBProxyEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDBProxyEndpointName").build())
            .build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(ModifyDbProxyEndpointRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_ENDPOINT_NAME_FIELD,
            NEW_DB_PROXY_ENDPOINT_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD));

    private final String dbProxyEndpointName;

    private final String newDBProxyEndpointName;

    private final List<String> vpcSecurityGroupIds;

    private ModifyDbProxyEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dbProxyEndpointName = builder.dbProxyEndpointName;
        this.newDBProxyEndpointName = builder.newDBProxyEndpointName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The name of the DB proxy sociated with the DB proxy endpoint that you want to modify.
     * </p>
     * 
     * @return The name of the DB proxy sociated with the DB proxy endpoint that you want to modify.
     */
    public final String dbProxyEndpointName() {
        return dbProxyEndpointName;
    }

    /**
     * <p>
     * The new identifier for the <code>DBProxyEndpoint</code>. An identifier must begin with a letter and must contain
     * only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * 
     * @return The new identifier for the <code>DBProxyEndpoint</code>. An identifier must begin with a letter and must
     *         contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive
     *         hyphens.
     */
    public final String newDBProxyEndpointName() {
        return newDBProxyEndpointName;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC security group IDs for the DB proxy endpoint. When the DB proxy endpoint uses a different VPC than the
     * original proxy, you also specify a different set of security group IDs than for the original proxy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return The VPC security group IDs for the DB proxy endpoint. When the DB proxy endpoint uses a different VPC
     *         than the original proxy, you also specify a different set of security group IDs than for the original
     *         proxy.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbProxyEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(newDBProxyEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbProxyEndpointRequest)) {
            return false;
        }
        ModifyDbProxyEndpointRequest other = (ModifyDbProxyEndpointRequest) obj;
        return Objects.equals(dbProxyEndpointName(), other.dbProxyEndpointName())
                && Objects.equals(newDBProxyEndpointName(), other.newDBProxyEndpointName())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbProxyEndpointRequest").add("DBProxyEndpointName", dbProxyEndpointName())
                .add("NewDBProxyEndpointName", newDBProxyEndpointName())
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBProxyEndpointName":
            return Optional.ofNullable(clazz.cast(dbProxyEndpointName()));
        case "NewDBProxyEndpointName":
            return Optional.ofNullable(clazz.cast(newDBProxyEndpointName()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbProxyEndpointRequest, T> g) {
        return obj -> g.apply((ModifyDbProxyEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbProxyEndpointRequest> {
        /**
         * <p>
         * The name of the DB proxy sociated with the DB proxy endpoint that you want to modify.
         * </p>
         * 
         * @param dbProxyEndpointName
         *        The name of the DB proxy sociated with the DB proxy endpoint that you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbProxyEndpointName(String dbProxyEndpointName);

        /**
         * <p>
         * The new identifier for the <code>DBProxyEndpoint</code>. An identifier must begin with a letter and must
         * contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive
         * hyphens.
         * </p>
         * 
         * @param newDBProxyEndpointName
         *        The new identifier for the <code>DBProxyEndpoint</code>. An identifier must begin with a letter and
         *        must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two
         *        consecutive hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDBProxyEndpointName(String newDBProxyEndpointName);

        /**
         * <p>
         * The VPC security group IDs for the DB proxy endpoint. When the DB proxy endpoint uses a different VPC than
         * the original proxy, you also specify a different set of security group IDs than for the original proxy.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        The VPC security group IDs for the DB proxy endpoint. When the DB proxy endpoint uses a different VPC
         *        than the original proxy, you also specify a different set of security group IDs than for the original
         *        proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * The VPC security group IDs for the DB proxy endpoint. When the DB proxy endpoint uses a different VPC than
         * the original proxy, you also specify a different set of security group IDs than for the original proxy.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        The VPC security group IDs for the DB proxy endpoint. When the DB proxy endpoint uses a different VPC
         *        than the original proxy, you also specify a different set of security group IDs than for the original
         *        proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbProxyEndpointName;

        private String newDBProxyEndpointName;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbProxyEndpointRequest model) {
            super(model);
            dbProxyEndpointName(model.dbProxyEndpointName);
            newDBProxyEndpointName(model.newDBProxyEndpointName);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
        }

        public final String getDbProxyEndpointName() {
            return dbProxyEndpointName;
        }

        public final void setDbProxyEndpointName(String dbProxyEndpointName) {
            this.dbProxyEndpointName = dbProxyEndpointName;
        }

        @Override
        public final Builder dbProxyEndpointName(String dbProxyEndpointName) {
            this.dbProxyEndpointName = dbProxyEndpointName;
            return this;
        }

        public final String getNewDBProxyEndpointName() {
            return newDBProxyEndpointName;
        }

        public final void setNewDBProxyEndpointName(String newDBProxyEndpointName) {
            this.newDBProxyEndpointName = newDBProxyEndpointName;
        }

        @Override
        public final Builder newDBProxyEndpointName(String newDBProxyEndpointName) {
            this.newDBProxyEndpointName = newDBProxyEndpointName;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbProxyEndpointRequest build() {
            return new ModifyDbProxyEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
