/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Shows the scaling configuration for an Aurora DB cluster in <code>serverless</code> DB engine mode.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora
 * Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingConfigurationInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ScalingConfigurationInfo.Builder, ScalingConfigurationInfo> {
    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinCapacity").getter(getter(ScalingConfigurationInfo::minCapacity)).setter(setter(Builder::minCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()).build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxCapacity").getter(getter(ScalingConfigurationInfo::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<Boolean> AUTO_PAUSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoPause").getter(getter(ScalingConfigurationInfo::autoPause)).setter(setter(Builder::autoPause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPause").build()).build();

    private static final SdkField<Integer> SECONDS_UNTIL_AUTO_PAUSE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondsUntilAutoPause").getter(getter(ScalingConfigurationInfo::secondsUntilAutoPause))
            .setter(setter(Builder::secondsUntilAutoPause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondsUntilAutoPause").build())
            .build();

    private static final SdkField<String> TIMEOUT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeoutAction").getter(getter(ScalingConfigurationInfo::timeoutAction))
            .setter(setter(Builder::timeoutAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutAction").build()).build();

    private static final SdkField<Integer> SECONDS_BEFORE_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondsBeforeTimeout").getter(getter(ScalingConfigurationInfo::secondsBeforeTimeout))
            .setter(setter(Builder::secondsBeforeTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondsBeforeTimeout").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CAPACITY_FIELD,
            MAX_CAPACITY_FIELD, AUTO_PAUSE_FIELD, SECONDS_UNTIL_AUTO_PAUSE_FIELD, TIMEOUT_ACTION_FIELD,
            SECONDS_BEFORE_TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minCapacity;

    private final Integer maxCapacity;

    private final Boolean autoPause;

    private final Integer secondsUntilAutoPause;

    private final String timeoutAction;

    private final Integer secondsBeforeTimeout;

    private ScalingConfigurationInfo(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.autoPause = builder.autoPause;
        this.secondsUntilAutoPause = builder.secondsUntilAutoPause;
        this.timeoutAction = builder.timeoutAction;
        this.secondsBeforeTimeout = builder.secondsBeforeTimeout;
    }

    /**
     * <p>
     * The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
     * </p>
     * 
     * @return The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
     */
    public final Integer minCapacity() {
        return minCapacity;
    }

    /**
     * <p>
     * The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
     * </p>
     * 
     * @return The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
     */
    public final Integer maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * A value that indicates whether automatic pause is allowed for the Aurora DB cluster in <code>serverless</code> DB
     * engine mode.
     * </p>
     * <p>
     * When the value is set to false for an Aurora Serverless v1 DB cluster, the DB cluster automatically resumes.
     * </p>
     * 
     * @return A value that indicates whether automatic pause is allowed for the Aurora DB cluster in
     *         <code>serverless</code> DB engine mode.</p>
     *         <p>
     *         When the value is set to false for an Aurora Serverless v1 DB cluster, the DB cluster automatically
     *         resumes.
     */
    public final Boolean autoPause() {
        return autoPause;
    }

    /**
     * <p>
     * The remaining amount of time, in seconds, before the Aurora DB cluster in <code>serverless</code> mode is paused.
     * A DB cluster can be paused only when it's idle (it has no connections).
     * </p>
     * 
     * @return The remaining amount of time, in seconds, before the Aurora DB cluster in <code>serverless</code> mode is
     *         paused. A DB cluster can be paused only when it's idle (it has no connections).
     */
    public final Integer secondsUntilAutoPause() {
        return secondsUntilAutoPause;
    }

    /**
     * <p>
     * The action that occurs when Aurora times out while attempting to change the capacity of an Aurora Serverless v1
     * cluster. The value is either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.
     * </p>
     * <p>
     * <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as possible.
     * </p>
     * <p>
     * <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the timeout
     * period.
     * </p>
     * 
     * @return The action that occurs when Aurora times out while attempting to change the capacity of an Aurora
     *         Serverless v1 cluster. The value is either <code>ForceApplyCapacityChange</code> or
     *         <code>RollbackCapacityChange</code>.</p>
     *         <p>
     *         <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as
     *         possible.
     *         </p>
     *         <p>
     *         <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the
     *         timeout period.
     */
    public final String timeoutAction() {
        return timeoutAction;
    }

    /**
     * <p>
     * The number of seconds before scaling times out. What happens when an attempted scaling action times out is
     * determined by the <code>TimeoutAction</code> setting.
     * </p>
     * 
     * @return The number of seconds before scaling times out. What happens when an attempted scaling action times out
     *         is determined by the <code>TimeoutAction</code> setting.
     */
    public final Integer secondsBeforeTimeout() {
        return secondsBeforeTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(autoPause());
        hashCode = 31 * hashCode + Objects.hashCode(secondsUntilAutoPause());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutAction());
        hashCode = 31 * hashCode + Objects.hashCode(secondsBeforeTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingConfigurationInfo)) {
            return false;
        }
        ScalingConfigurationInfo other = (ScalingConfigurationInfo) obj;
        return Objects.equals(minCapacity(), other.minCapacity()) && Objects.equals(maxCapacity(), other.maxCapacity())
                && Objects.equals(autoPause(), other.autoPause())
                && Objects.equals(secondsUntilAutoPause(), other.secondsUntilAutoPause())
                && Objects.equals(timeoutAction(), other.timeoutAction())
                && Objects.equals(secondsBeforeTimeout(), other.secondsBeforeTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalingConfigurationInfo").add("MinCapacity", minCapacity()).add("MaxCapacity", maxCapacity())
                .add("AutoPause", autoPause()).add("SecondsUntilAutoPause", secondsUntilAutoPause())
                .add("TimeoutAction", timeoutAction()).add("SecondsBeforeTimeout", secondsBeforeTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinCapacity":
            return Optional.ofNullable(clazz.cast(minCapacity()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "AutoPause":
            return Optional.ofNullable(clazz.cast(autoPause()));
        case "SecondsUntilAutoPause":
            return Optional.ofNullable(clazz.cast(secondsUntilAutoPause()));
        case "TimeoutAction":
            return Optional.ofNullable(clazz.cast(timeoutAction()));
        case "SecondsBeforeTimeout":
            return Optional.ofNullable(clazz.cast(secondsBeforeTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingConfigurationInfo, T> g) {
        return obj -> g.apply((ScalingConfigurationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingConfigurationInfo> {
        /**
         * <p>
         * The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
         * </p>
         * 
         * @param minCapacity
         *        The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCapacity(Integer minCapacity);

        /**
         * <p>
         * The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);

        /**
         * <p>
         * A value that indicates whether automatic pause is allowed for the Aurora DB cluster in
         * <code>serverless</code> DB engine mode.
         * </p>
         * <p>
         * When the value is set to false for an Aurora Serverless v1 DB cluster, the DB cluster automatically resumes.
         * </p>
         * 
         * @param autoPause
         *        A value that indicates whether automatic pause is allowed for the Aurora DB cluster in
         *        <code>serverless</code> DB engine mode.</p>
         *        <p>
         *        When the value is set to false for an Aurora Serverless v1 DB cluster, the DB cluster automatically
         *        resumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoPause(Boolean autoPause);

        /**
         * <p>
         * The remaining amount of time, in seconds, before the Aurora DB cluster in <code>serverless</code> mode is
         * paused. A DB cluster can be paused only when it's idle (it has no connections).
         * </p>
         * 
         * @param secondsUntilAutoPause
         *        The remaining amount of time, in seconds, before the Aurora DB cluster in <code>serverless</code> mode
         *        is paused. A DB cluster can be paused only when it's idle (it has no connections).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondsUntilAutoPause(Integer secondsUntilAutoPause);

        /**
         * <p>
         * The action that occurs when Aurora times out while attempting to change the capacity of an Aurora Serverless
         * v1 cluster. The value is either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.
         * </p>
         * <p>
         * <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as
         * possible.
         * </p>
         * <p>
         * <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the timeout
         * period.
         * </p>
         * 
         * @param timeoutAction
         *        The action that occurs when Aurora times out while attempting to change the capacity of an Aurora
         *        Serverless v1 cluster. The value is either <code>ForceApplyCapacityChange</code> or
         *        <code>RollbackCapacityChange</code>.</p>
         *        <p>
         *        <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon
         *        as possible.
         *        </p>
         *        <p>
         *        <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the
         *        timeout period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutAction(String timeoutAction);

        /**
         * <p>
         * The number of seconds before scaling times out. What happens when an attempted scaling action times out is
         * determined by the <code>TimeoutAction</code> setting.
         * </p>
         * 
         * @param secondsBeforeTimeout
         *        The number of seconds before scaling times out. What happens when an attempted scaling action times
         *        out is determined by the <code>TimeoutAction</code> setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondsBeforeTimeout(Integer secondsBeforeTimeout);
    }

    static final class BuilderImpl implements Builder {
        private Integer minCapacity;

        private Integer maxCapacity;

        private Boolean autoPause;

        private Integer secondsUntilAutoPause;

        private String timeoutAction;

        private Integer secondsBeforeTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingConfigurationInfo model) {
            minCapacity(model.minCapacity);
            maxCapacity(model.maxCapacity);
            autoPause(model.autoPause);
            secondsUntilAutoPause(model.secondsUntilAutoPause);
            timeoutAction(model.timeoutAction);
            secondsBeforeTimeout(model.secondsBeforeTimeout);
        }

        public final Integer getMinCapacity() {
            return minCapacity;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Boolean getAutoPause() {
            return autoPause;
        }

        public final void setAutoPause(Boolean autoPause) {
            this.autoPause = autoPause;
        }

        @Override
        public final Builder autoPause(Boolean autoPause) {
            this.autoPause = autoPause;
            return this;
        }

        public final Integer getSecondsUntilAutoPause() {
            return secondsUntilAutoPause;
        }

        public final void setSecondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
        }

        @Override
        public final Builder secondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
            return this;
        }

        public final String getTimeoutAction() {
            return timeoutAction;
        }

        public final void setTimeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
        }

        @Override
        public final Builder timeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }

        public final Integer getSecondsBeforeTimeout() {
            return secondsBeforeTimeout;
        }

        public final void setSecondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
        }

        @Override
        public final Builder secondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
            return this;
        }

        @Override
        public ScalingConfigurationInfo build() {
            return new ScalingConfigurationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
