/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about valid modifications that you can make to your DB instance. Contains the result of a successful call
 * to the <code>DescribeValidDBInstanceModifications</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidStorageOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidStorageOptions.Builder, ValidStorageOptions> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(ValidStorageOptions::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<List<Range>> STORAGE_SIZE_FIELD = SdkField
            .<List<Range>> builder(MarshallingType.LIST)
            .memberName("StorageSize")
            .getter(getter(ValidStorageOptions::storageSize))
            .setter(setter(Builder::storageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSize").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Range")
                            .memberFieldInfo(
                                    SdkField.<Range> builder(MarshallingType.SDK_POJO)
                                            .constructor(Range::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Range").build()).build()).build()).build();

    private static final SdkField<List<Range>> PROVISIONED_IOPS_FIELD = SdkField
            .<List<Range>> builder(MarshallingType.LIST)
            .memberName("ProvisionedIops")
            .getter(getter(ValidStorageOptions::provisionedIops))
            .setter(setter(Builder::provisionedIops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedIops").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Range")
                            .memberFieldInfo(
                                    SdkField.<Range> builder(MarshallingType.SDK_POJO)
                                            .constructor(Range::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Range").build()).build()).build()).build();

    private static final SdkField<List<DoubleRange>> IOPS_TO_STORAGE_RATIO_FIELD = SdkField
            .<List<DoubleRange>> builder(MarshallingType.LIST)
            .memberName("IopsToStorageRatio")
            .getter(getter(ValidStorageOptions::iopsToStorageRatio))
            .setter(setter(Builder::iopsToStorageRatio))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IopsToStorageRatio").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DoubleRange")
                            .memberFieldInfo(
                                    SdkField.<DoubleRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DoubleRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DoubleRange").build()).build()).build()).build();

    private static final SdkField<Boolean> SUPPORTS_STORAGE_AUTOSCALING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SupportsStorageAutoscaling")
            .getter(getter(ValidStorageOptions::supportsStorageAutoscaling))
            .setter(setter(Builder::supportsStorageAutoscaling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsStorageAutoscaling").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD,
            STORAGE_SIZE_FIELD, PROVISIONED_IOPS_FIELD, IOPS_TO_STORAGE_RATIO_FIELD, SUPPORTS_STORAGE_AUTOSCALING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String storageType;

    private final List<Range> storageSize;

    private final List<Range> provisionedIops;

    private final List<DoubleRange> iopsToStorageRatio;

    private final Boolean supportsStorageAutoscaling;

    private ValidStorageOptions(BuilderImpl builder) {
        this.storageType = builder.storageType;
        this.storageSize = builder.storageSize;
        this.provisionedIops = builder.provisionedIops;
        this.iopsToStorageRatio = builder.iopsToStorageRatio;
        this.supportsStorageAutoscaling = builder.supportsStorageAutoscaling;
    }

    /**
     * <p>
     * The valid storage types for your DB instance. For example, gp2, io1.
     * </p>
     * 
     * @return The valid storage types for your DB instance. For example, gp2, io1.
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * For responses, this returns true if the service returned a value for the StorageSize property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStorageSize() {
        return storageSize != null && !(storageSize instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The valid range of storage in gibibytes (GiB). For example, 100 to 16384.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorageSize} method.
     * </p>
     * 
     * @return The valid range of storage in gibibytes (GiB). For example, 100 to 16384.
     */
    public final List<Range> storageSize() {
        return storageSize;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisionedIops property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProvisionedIops() {
        return provisionedIops != null && !(provisionedIops instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The valid range of provisioned IOPS. For example, 1000-20000.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisionedIops} method.
     * </p>
     * 
     * @return The valid range of provisioned IOPS. For example, 1000-20000.
     */
    public final List<Range> provisionedIops() {
        return provisionedIops;
    }

    /**
     * For responses, this returns true if the service returned a value for the IopsToStorageRatio property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIopsToStorageRatio() {
        return iopsToStorageRatio != null && !(iopsToStorageRatio instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that
     * provisioned IOPS can be between 3 and 10 times storage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIopsToStorageRatio} method.
     * </p>
     * 
     * @return The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means
     *         that provisioned IOPS can be between 3 and 10 times storage.
     */
    public final List<DoubleRange> iopsToStorageRatio() {
        return iopsToStorageRatio;
    }

    /**
     * <p>
     * Whether or not Amazon RDS can automatically scale storage for DB instances that use the new instance class.
     * </p>
     * 
     * @return Whether or not Amazon RDS can automatically scale storage for DB instances that use the new instance
     *         class.
     */
    public final Boolean supportsStorageAutoscaling() {
        return supportsStorageAutoscaling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageSize() ? storageSize() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisionedIops() ? provisionedIops() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIopsToStorageRatio() ? iopsToStorageRatio() : null);
        hashCode = 31 * hashCode + Objects.hashCode(supportsStorageAutoscaling());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidStorageOptions)) {
            return false;
        }
        ValidStorageOptions other = (ValidStorageOptions) obj;
        return Objects.equals(storageType(), other.storageType()) && hasStorageSize() == other.hasStorageSize()
                && Objects.equals(storageSize(), other.storageSize()) && hasProvisionedIops() == other.hasProvisionedIops()
                && Objects.equals(provisionedIops(), other.provisionedIops())
                && hasIopsToStorageRatio() == other.hasIopsToStorageRatio()
                && Objects.equals(iopsToStorageRatio(), other.iopsToStorageRatio())
                && Objects.equals(supportsStorageAutoscaling(), other.supportsStorageAutoscaling());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidStorageOptions").add("StorageType", storageType())
                .add("StorageSize", hasStorageSize() ? storageSize() : null)
                .add("ProvisionedIops", hasProvisionedIops() ? provisionedIops() : null)
                .add("IopsToStorageRatio", hasIopsToStorageRatio() ? iopsToStorageRatio() : null)
                .add("SupportsStorageAutoscaling", supportsStorageAutoscaling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "StorageSize":
            return Optional.ofNullable(clazz.cast(storageSize()));
        case "ProvisionedIops":
            return Optional.ofNullable(clazz.cast(provisionedIops()));
        case "IopsToStorageRatio":
            return Optional.ofNullable(clazz.cast(iopsToStorageRatio()));
        case "SupportsStorageAutoscaling":
            return Optional.ofNullable(clazz.cast(supportsStorageAutoscaling()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidStorageOptions, T> g) {
        return obj -> g.apply((ValidStorageOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidStorageOptions> {
        /**
         * <p>
         * The valid storage types for your DB instance. For example, gp2, io1.
         * </p>
         * 
         * @param storageType
         *        The valid storage types for your DB instance. For example, gp2, io1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The valid range of storage in gibibytes (GiB). For example, 100 to 16384.
         * </p>
         * 
         * @param storageSize
         *        The valid range of storage in gibibytes (GiB). For example, 100 to 16384.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSize(Collection<Range> storageSize);

        /**
         * <p>
         * The valid range of storage in gibibytes (GiB). For example, 100 to 16384.
         * </p>
         * 
         * @param storageSize
         *        The valid range of storage in gibibytes (GiB). For example, 100 to 16384.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSize(Range... storageSize);

        /**
         * <p>
         * The valid range of storage in gibibytes (GiB). For example, 100 to 16384.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Range.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Range#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Range.Builder#build()}
         * is called immediately and its result is passed to {@link #storageSize(List<Range>)}.
         * 
         * @param storageSize
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Range.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageSize(java.util.Collection<Range>)
         */
        Builder storageSize(Consumer<Range.Builder>... storageSize);

        /**
         * <p>
         * The valid range of provisioned IOPS. For example, 1000-20000.
         * </p>
         * 
         * @param provisionedIops
         *        The valid range of provisioned IOPS. For example, 1000-20000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedIops(Collection<Range> provisionedIops);

        /**
         * <p>
         * The valid range of provisioned IOPS. For example, 1000-20000.
         * </p>
         * 
         * @param provisionedIops
         *        The valid range of provisioned IOPS. For example, 1000-20000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedIops(Range... provisionedIops);

        /**
         * <p>
         * The valid range of provisioned IOPS. For example, 1000-20000.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Range.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Range#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Range.Builder#build()}
         * is called immediately and its result is passed to {@link #provisionedIops(List<Range>)}.
         * 
         * @param provisionedIops
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Range.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedIops(java.util.Collection<Range>)
         */
        Builder provisionedIops(Consumer<Range.Builder>... provisionedIops);

        /**
         * <p>
         * The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that
         * provisioned IOPS can be between 3 and 10 times storage.
         * </p>
         * 
         * @param iopsToStorageRatio
         *        The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means
         *        that provisioned IOPS can be between 3 and 10 times storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iopsToStorageRatio(Collection<DoubleRange> iopsToStorageRatio);

        /**
         * <p>
         * The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that
         * provisioned IOPS can be between 3 and 10 times storage.
         * </p>
         * 
         * @param iopsToStorageRatio
         *        The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means
         *        that provisioned IOPS can be between 3 and 10 times storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iopsToStorageRatio(DoubleRange... iopsToStorageRatio);

        /**
         * <p>
         * The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that
         * provisioned IOPS can be between 3 and 10 times storage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.DoubleRange.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.DoubleRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.DoubleRange.Builder#build()} is called immediately and its
         * result is passed to {@link #iopsToStorageRatio(List<DoubleRange>)}.
         * 
         * @param iopsToStorageRatio
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.DoubleRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iopsToStorageRatio(java.util.Collection<DoubleRange>)
         */
        Builder iopsToStorageRatio(Consumer<DoubleRange.Builder>... iopsToStorageRatio);

        /**
         * <p>
         * Whether or not Amazon RDS can automatically scale storage for DB instances that use the new instance class.
         * </p>
         * 
         * @param supportsStorageAutoscaling
         *        Whether or not Amazon RDS can automatically scale storage for DB instances that use the new instance
         *        class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsStorageAutoscaling(Boolean supportsStorageAutoscaling);
    }

    static final class BuilderImpl implements Builder {
        private String storageType;

        private List<Range> storageSize = DefaultSdkAutoConstructList.getInstance();

        private List<Range> provisionedIops = DefaultSdkAutoConstructList.getInstance();

        private List<DoubleRange> iopsToStorageRatio = DefaultSdkAutoConstructList.getInstance();

        private Boolean supportsStorageAutoscaling;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidStorageOptions model) {
            storageType(model.storageType);
            storageSize(model.storageSize);
            provisionedIops(model.provisionedIops);
            iopsToStorageRatio(model.iopsToStorageRatio);
            supportsStorageAutoscaling(model.supportsStorageAutoscaling);
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final List<Range.Builder> getStorageSize() {
            List<Range.Builder> result = RangeListCopier.copyToBuilder(this.storageSize);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageSize(Collection<Range.BuilderImpl> storageSize) {
            this.storageSize = RangeListCopier.copyFromBuilder(storageSize);
        }

        @Override
        public final Builder storageSize(Collection<Range> storageSize) {
            this.storageSize = RangeListCopier.copy(storageSize);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageSize(Range... storageSize) {
            storageSize(Arrays.asList(storageSize));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageSize(Consumer<Range.Builder>... storageSize) {
            storageSize(Stream.of(storageSize).map(c -> Range.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Range.Builder> getProvisionedIops() {
            List<Range.Builder> result = RangeListCopier.copyToBuilder(this.provisionedIops);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisionedIops(Collection<Range.BuilderImpl> provisionedIops) {
            this.provisionedIops = RangeListCopier.copyFromBuilder(provisionedIops);
        }

        @Override
        public final Builder provisionedIops(Collection<Range> provisionedIops) {
            this.provisionedIops = RangeListCopier.copy(provisionedIops);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedIops(Range... provisionedIops) {
            provisionedIops(Arrays.asList(provisionedIops));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedIops(Consumer<Range.Builder>... provisionedIops) {
            provisionedIops(Stream.of(provisionedIops).map(c -> Range.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DoubleRange.Builder> getIopsToStorageRatio() {
            List<DoubleRange.Builder> result = DoubleRangeListCopier.copyToBuilder(this.iopsToStorageRatio);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIopsToStorageRatio(Collection<DoubleRange.BuilderImpl> iopsToStorageRatio) {
            this.iopsToStorageRatio = DoubleRangeListCopier.copyFromBuilder(iopsToStorageRatio);
        }

        @Override
        public final Builder iopsToStorageRatio(Collection<DoubleRange> iopsToStorageRatio) {
            this.iopsToStorageRatio = DoubleRangeListCopier.copy(iopsToStorageRatio);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iopsToStorageRatio(DoubleRange... iopsToStorageRatio) {
            iopsToStorageRatio(Arrays.asList(iopsToStorageRatio));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iopsToStorageRatio(Consumer<DoubleRange.Builder>... iopsToStorageRatio) {
            iopsToStorageRatio(Stream.of(iopsToStorageRatio).map(c -> DoubleRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSupportsStorageAutoscaling() {
            return supportsStorageAutoscaling;
        }

        public final void setSupportsStorageAutoscaling(Boolean supportsStorageAutoscaling) {
            this.supportsStorageAutoscaling = supportsStorageAutoscaling;
        }

        @Override
        public final Builder supportsStorageAutoscaling(Boolean supportsStorageAutoscaling) {
            this.supportsStorageAutoscaling = supportsStorageAutoscaling;
            return this;
        }

        @Override
        public ValidStorageOptions build() {
            return new ValidStorageOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
