/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.AppAssessmentScheduleType;
import software.amazon.awssdk.services.resiliencehub.model.EventSubscription;
import software.amazon.awssdk.services.resiliencehub.model.EventSubscriptionListCopier;
import software.amazon.awssdk.services.resiliencehub.model.PermissionModel;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAppRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, UpdateAppRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(UpdateAppRequest.getter(UpdateAppRequest::appArn)).setter(UpdateAppRequest.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> ASSESSMENT_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentSchedule").getter(UpdateAppRequest.getter(UpdateAppRequest::assessmentScheduleAsString)).setter(UpdateAppRequest.setter(Builder::assessmentSchedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentSchedule").build()}).build();
    private static final SdkField<Boolean> CLEAR_RESILIENCY_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("clearResiliencyPolicyArn").getter(UpdateAppRequest.getter(UpdateAppRequest::clearResiliencyPolicyArn)).setter(UpdateAppRequest.setter(Builder::clearResiliencyPolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clearResiliencyPolicyArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAppRequest.getter(UpdateAppRequest::description)).setter(UpdateAppRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<EventSubscription>> EVENT_SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventSubscriptions").getter(UpdateAppRequest.getter(UpdateAppRequest::eventSubscriptions)).setter(UpdateAppRequest.setter(Builder::eventSubscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSubscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventSubscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PermissionModel> PERMISSION_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("permissionModel").getter(UpdateAppRequest.getter(UpdateAppRequest::permissionModel)).setter(UpdateAppRequest.setter(Builder::permissionModel)).constructor(PermissionModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionModel").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(UpdateAppRequest.getter(UpdateAppRequest::policyArn)).setter(UpdateAppRequest.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, ASSESSMENT_SCHEDULE_FIELD, CLEAR_RESILIENCY_POLICY_ARN_FIELD, DESCRIPTION_FIELD, EVENT_SUBSCRIPTIONS_FIELD, PERMISSION_MODEL_FIELD, POLICY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAppRequest.memberNameToFieldInitializer();
    private final String appArn;
    private final String assessmentSchedule;
    private final Boolean clearResiliencyPolicyArn;
    private final String description;
    private final List<EventSubscription> eventSubscriptions;
    private final PermissionModel permissionModel;
    private final String policyArn;

    private UpdateAppRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.assessmentSchedule = builder.assessmentSchedule;
        this.clearResiliencyPolicyArn = builder.clearResiliencyPolicyArn;
        this.description = builder.description;
        this.eventSubscriptions = builder.eventSubscriptions;
        this.permissionModel = builder.permissionModel;
        this.policyArn = builder.policyArn;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final AppAssessmentScheduleType assessmentSchedule() {
        return AppAssessmentScheduleType.fromValue(this.assessmentSchedule);
    }

    public final String assessmentScheduleAsString() {
        return this.assessmentSchedule;
    }

    public final Boolean clearResiliencyPolicyArn() {
        return this.clearResiliencyPolicyArn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEventSubscriptions() {
        return this.eventSubscriptions != null && !(this.eventSubscriptions instanceof SdkAutoConstructList);
    }

    public final List<EventSubscription> eventSubscriptions() {
        return this.eventSubscriptions;
    }

    public final PermissionModel permissionModel() {
        return this.permissionModel;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clearResiliencyPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventSubscriptions() ? this.eventSubscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppRequest)) {
            return false;
        }
        UpdateAppRequest other = (UpdateAppRequest)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.assessmentScheduleAsString(), other.assessmentScheduleAsString()) && Objects.equals(this.clearResiliencyPolicyArn(), other.clearResiliencyPolicyArn()) && Objects.equals(this.description(), other.description()) && this.hasEventSubscriptions() == other.hasEventSubscriptions() && Objects.equals(this.eventSubscriptions(), other.eventSubscriptions()) && Objects.equals(this.permissionModel(), other.permissionModel()) && Objects.equals(this.policyArn(), other.policyArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAppRequest").add("AppArn", (Object)this.appArn()).add("AssessmentSchedule", (Object)this.assessmentScheduleAsString()).add("ClearResiliencyPolicyArn", (Object)this.clearResiliencyPolicyArn()).add("Description", (Object)this.description()).add("EventSubscriptions", this.hasEventSubscriptions() ? this.eventSubscriptions() : null).add("PermissionModel", (Object)this.permissionModel()).add("PolicyArn", (Object)this.policyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "assessmentSchedule": {
                return Optional.ofNullable(clazz.cast(this.assessmentScheduleAsString()));
            }
            case "clearResiliencyPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.clearResiliencyPolicyArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "eventSubscriptions": {
                return Optional.ofNullable(clazz.cast(this.eventSubscriptions()));
            }
            case "permissionModel": {
                return Optional.ofNullable(clazz.cast(this.permissionModel()));
            }
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appArn", APP_ARN_FIELD);
        map.put("assessmentSchedule", ASSESSMENT_SCHEDULE_FIELD);
        map.put("clearResiliencyPolicyArn", CLEAR_RESILIENCY_POLICY_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("eventSubscriptions", EVENT_SUBSCRIPTIONS_FIELD);
        map.put("permissionModel", PERMISSION_MODEL_FIELD);
        map.put("policyArn", POLICY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppRequest, T> g) {
        return obj -> g.apply((UpdateAppRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private String appArn;
        private String assessmentSchedule;
        private Boolean clearResiliencyPolicyArn;
        private String description;
        private List<EventSubscription> eventSubscriptions = DefaultSdkAutoConstructList.getInstance();
        private PermissionModel permissionModel;
        private String policyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppRequest model) {
            super(model);
            this.appArn(model.appArn);
            this.assessmentSchedule(model.assessmentSchedule);
            this.clearResiliencyPolicyArn(model.clearResiliencyPolicyArn);
            this.description(model.description);
            this.eventSubscriptions(model.eventSubscriptions);
            this.permissionModel(model.permissionModel);
            this.policyArn(model.policyArn);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAssessmentSchedule() {
            return this.assessmentSchedule;
        }

        public final void setAssessmentSchedule(String assessmentSchedule) {
            this.assessmentSchedule = assessmentSchedule;
        }

        @Override
        public final Builder assessmentSchedule(String assessmentSchedule) {
            this.assessmentSchedule = assessmentSchedule;
            return this;
        }

        @Override
        public final Builder assessmentSchedule(AppAssessmentScheduleType assessmentSchedule) {
            this.assessmentSchedule(assessmentSchedule == null ? null : assessmentSchedule.toString());
            return this;
        }

        public final Boolean getClearResiliencyPolicyArn() {
            return this.clearResiliencyPolicyArn;
        }

        public final void setClearResiliencyPolicyArn(Boolean clearResiliencyPolicyArn) {
            this.clearResiliencyPolicyArn = clearResiliencyPolicyArn;
        }

        @Override
        public final Builder clearResiliencyPolicyArn(Boolean clearResiliencyPolicyArn) {
            this.clearResiliencyPolicyArn = clearResiliencyPolicyArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EventSubscription.Builder> getEventSubscriptions() {
            List<EventSubscription.Builder> result = EventSubscriptionListCopier.copyToBuilder(this.eventSubscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventSubscriptions(Collection<EventSubscription.BuilderImpl> eventSubscriptions) {
            this.eventSubscriptions = EventSubscriptionListCopier.copyFromBuilder(eventSubscriptions);
        }

        @Override
        public final Builder eventSubscriptions(Collection<EventSubscription> eventSubscriptions) {
            this.eventSubscriptions = EventSubscriptionListCopier.copy(eventSubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptions(EventSubscription ... eventSubscriptions) {
            this.eventSubscriptions(Arrays.asList(eventSubscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptions(Consumer<EventSubscription.Builder> ... eventSubscriptions) {
            this.eventSubscriptions(Stream.of(eventSubscriptions).map(c -> (EventSubscription)((EventSubscription.Builder)EventSubscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final PermissionModel.Builder getPermissionModel() {
            return this.permissionModel != null ? this.permissionModel.toBuilder() : null;
        }

        public final void setPermissionModel(PermissionModel.BuilderImpl permissionModel) {
            this.permissionModel = permissionModel != null ? permissionModel.build() : null;
        }

        @Override
        public final Builder permissionModel(PermissionModel permissionModel) {
            this.permissionModel = permissionModel;
            return this;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppRequest build() {
            return new UpdateAppRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAppRequest> {
        public Builder appArn(String var1);

        public Builder assessmentSchedule(String var1);

        public Builder assessmentSchedule(AppAssessmentScheduleType var1);

        public Builder clearResiliencyPolicyArn(Boolean var1);

        public Builder description(String var1);

        public Builder eventSubscriptions(Collection<EventSubscription> var1);

        public Builder eventSubscriptions(EventSubscription ... var1);

        public Builder eventSubscriptions(Consumer<EventSubscription.Builder> ... var1);

        public Builder permissionModel(PermissionModel var1);

        default public Builder permissionModel(Consumer<PermissionModel.Builder> permissionModel) {
            return this.permissionModel((PermissionModel)((PermissionModel.Builder)PermissionModel.builder().applyMutation(permissionModel)).build());
        }

        public Builder policyArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

