/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentResourceDriftsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentResourceDriftsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResourceDrift;

public class ListAppAssessmentResourceDriftsIterable
implements SdkIterable<ListAppAssessmentResourceDriftsResponse> {
    private final ResiliencehubClient client;
    private final ListAppAssessmentResourceDriftsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppAssessmentResourceDriftsIterable(ResiliencehubClient client, ListAppAssessmentResourceDriftsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAppAssessmentResourceDriftsResponseFetcher();
    }

    public Iterator<ListAppAssessmentResourceDriftsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceDrift> resourceDrifts() {
        Function<ListAppAssessmentResourceDriftsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceDrifts() != null) {
                return response.resourceDrifts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAppAssessmentResourceDriftsResponseFetcher
    implements SyncPageFetcher<ListAppAssessmentResourceDriftsResponse> {
        private ListAppAssessmentResourceDriftsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppAssessmentResourceDriftsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppAssessmentResourceDriftsResponse nextPage(ListAppAssessmentResourceDriftsResponse previousPage) {
            if (previousPage == null) {
                return ListAppAssessmentResourceDriftsIterable.this.client.listAppAssessmentResourceDrifts(ListAppAssessmentResourceDriftsIterable.this.firstRequest);
            }
            return ListAppAssessmentResourceDriftsIterable.this.client.listAppAssessmentResourceDrifts((ListAppAssessmentResourceDriftsRequest)((Object)ListAppAssessmentResourceDriftsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

