/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubAsyncClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.GroupingRecommendation;
import software.amazon.awssdk.services.resiliencehub.model.ListResourceGroupingRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListResourceGroupingRecommendationsResponse;

public class ListResourceGroupingRecommendationsPublisher
implements SdkPublisher<ListResourceGroupingRecommendationsResponse> {
    private final ResiliencehubAsyncClient client;
    private final ListResourceGroupingRecommendationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceGroupingRecommendationsPublisher(ResiliencehubAsyncClient client, ListResourceGroupingRecommendationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceGroupingRecommendationsPublisher(ResiliencehubAsyncClient client, ListResourceGroupingRecommendationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceGroupingRecommendationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceGroupingRecommendationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroupingRecommendation> groupingRecommendations() {
        Function<ListResourceGroupingRecommendationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groupingRecommendations() != null) {
                return response.groupingRecommendations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceGroupingRecommendationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceGroupingRecommendationsResponseFetcher
    implements AsyncPageFetcher<ListResourceGroupingRecommendationsResponse> {
        private ListResourceGroupingRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceGroupingRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceGroupingRecommendationsResponse> nextPage(ListResourceGroupingRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceGroupingRecommendationsPublisher.this.client.listResourceGroupingRecommendations(ListResourceGroupingRecommendationsPublisher.this.firstRequest);
            }
            return ListResourceGroupingRecommendationsPublisher.this.client.listResourceGroupingRecommendations((ListResourceGroupingRecommendationsRequest)((Object)ListResourceGroupingRecommendationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

