/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CheckDomainAvailability response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckDomainAvailabilityResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<CheckDomainAvailabilityResponse.Builder, CheckDomainAvailabilityResponse> {
    private static final SdkField<String> AVAILABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CheckDomainAvailabilityResponse::availabilityAsString)).setter(setter(Builder::availability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Availability").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_FIELD));

    private final String availability;

    private CheckDomainAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.availability = builder.availability;
    }

    /**
     * <p>
     * Whether the domain name is available for registering.
     * </p>
     * <note>
     * <p>
     * You can register only domains designated as <code>AVAILABLE</code>.
     * </p>
     * </note>
     * <p>
     * Valid values:
     * </p>
     * <dl>
     * <dt>AVAILABLE</dt>
     * <dd>
     * <p>
     * The domain name is available.
     * </p>
     * </dd>
     * <dt>AVAILABLE_RESERVED</dt>
     * <dd>
     * <p>
     * The domain name is reserved under specific conditions.
     * </p>
     * </dd>
     * <dt>AVAILABLE_PREORDER</dt>
     * <dd>
     * <p>
     * The domain name is available and can be preordered.
     * </p>
     * </dd>
     * <dt>DONT_KNOW</dt>
     * <dd>
     * <p>
     * The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon Route
     * 53 can return this response for a variety of reasons, for example, the registry is performing maintenance. Try
     * again later.
     * </p>
     * </dd>
     * <dt>PENDING</dt>
     * <dd>
     * <p>
     * The TLD registry didn't return a response in the expected amount of time. When the response is delayed, it
     * usually takes just a few extra seconds. You can resubmit the request immediately.
     * </p>
     * </dd>
     * <dt>RESERVED</dt>
     * <dd>
     * <p>
     * The domain name has been reserved for another person or organization.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE</dt>
     * <dd>
     * <p>
     * The domain name is not available.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE_PREMIUM</dt>
     * <dd>
     * <p>
     * The domain name is not available.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE_RESTRICTED</dt>
     * <dd>
     * <p>
     * The domain name is forbidden.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #availability} will
     * return {@link DomainAvailability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #availabilityAsString}.
     * </p>
     * 
     * @return Whether the domain name is available for registering.</p> <note>
     *         <p>
     *         You can register only domains designated as <code>AVAILABLE</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Valid values:
     *         </p>
     *         <dl>
     *         <dt>AVAILABLE</dt>
     *         <dd>
     *         <p>
     *         The domain name is available.
     *         </p>
     *         </dd>
     *         <dt>AVAILABLE_RESERVED</dt>
     *         <dd>
     *         <p>
     *         The domain name is reserved under specific conditions.
     *         </p>
     *         </dd>
     *         <dt>AVAILABLE_PREORDER</dt>
     *         <dd>
     *         <p>
     *         The domain name is available and can be preordered.
     *         </p>
     *         </dd>
     *         <dt>DONT_KNOW</dt>
     *         <dd>
     *         <p>
     *         The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon
     *         Route 53 can return this response for a variety of reasons, for example, the registry is performing
     *         maintenance. Try again later.
     *         </p>
     *         </dd>
     *         <dt>PENDING</dt>
     *         <dd>
     *         <p>
     *         The TLD registry didn't return a response in the expected amount of time. When the response is delayed,
     *         it usually takes just a few extra seconds. You can resubmit the request immediately.
     *         </p>
     *         </dd>
     *         <dt>RESERVED</dt>
     *         <dd>
     *         <p>
     *         The domain name has been reserved for another person or organization.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE</dt>
     *         <dd>
     *         <p>
     *         The domain name is not available.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE_PREMIUM</dt>
     *         <dd>
     *         <p>
     *         The domain name is not available.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE_RESTRICTED</dt>
     *         <dd>
     *         <p>
     *         The domain name is forbidden.
     *         </p>
     *         </dd>
     * @see DomainAvailability
     */
    public DomainAvailability availability() {
        return DomainAvailability.fromValue(availability);
    }

    /**
     * <p>
     * Whether the domain name is available for registering.
     * </p>
     * <note>
     * <p>
     * You can register only domains designated as <code>AVAILABLE</code>.
     * </p>
     * </note>
     * <p>
     * Valid values:
     * </p>
     * <dl>
     * <dt>AVAILABLE</dt>
     * <dd>
     * <p>
     * The domain name is available.
     * </p>
     * </dd>
     * <dt>AVAILABLE_RESERVED</dt>
     * <dd>
     * <p>
     * The domain name is reserved under specific conditions.
     * </p>
     * </dd>
     * <dt>AVAILABLE_PREORDER</dt>
     * <dd>
     * <p>
     * The domain name is available and can be preordered.
     * </p>
     * </dd>
     * <dt>DONT_KNOW</dt>
     * <dd>
     * <p>
     * The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon Route
     * 53 can return this response for a variety of reasons, for example, the registry is performing maintenance. Try
     * again later.
     * </p>
     * </dd>
     * <dt>PENDING</dt>
     * <dd>
     * <p>
     * The TLD registry didn't return a response in the expected amount of time. When the response is delayed, it
     * usually takes just a few extra seconds. You can resubmit the request immediately.
     * </p>
     * </dd>
     * <dt>RESERVED</dt>
     * <dd>
     * <p>
     * The domain name has been reserved for another person or organization.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE</dt>
     * <dd>
     * <p>
     * The domain name is not available.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE_PREMIUM</dt>
     * <dd>
     * <p>
     * The domain name is not available.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE_RESTRICTED</dt>
     * <dd>
     * <p>
     * The domain name is forbidden.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #availability} will
     * return {@link DomainAvailability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #availabilityAsString}.
     * </p>
     * 
     * @return Whether the domain name is available for registering.</p> <note>
     *         <p>
     *         You can register only domains designated as <code>AVAILABLE</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Valid values:
     *         </p>
     *         <dl>
     *         <dt>AVAILABLE</dt>
     *         <dd>
     *         <p>
     *         The domain name is available.
     *         </p>
     *         </dd>
     *         <dt>AVAILABLE_RESERVED</dt>
     *         <dd>
     *         <p>
     *         The domain name is reserved under specific conditions.
     *         </p>
     *         </dd>
     *         <dt>AVAILABLE_PREORDER</dt>
     *         <dd>
     *         <p>
     *         The domain name is available and can be preordered.
     *         </p>
     *         </dd>
     *         <dt>DONT_KNOW</dt>
     *         <dd>
     *         <p>
     *         The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon
     *         Route 53 can return this response for a variety of reasons, for example, the registry is performing
     *         maintenance. Try again later.
     *         </p>
     *         </dd>
     *         <dt>PENDING</dt>
     *         <dd>
     *         <p>
     *         The TLD registry didn't return a response in the expected amount of time. When the response is delayed,
     *         it usually takes just a few extra seconds. You can resubmit the request immediately.
     *         </p>
     *         </dd>
     *         <dt>RESERVED</dt>
     *         <dd>
     *         <p>
     *         The domain name has been reserved for another person or organization.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE</dt>
     *         <dd>
     *         <p>
     *         The domain name is not available.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE_PREMIUM</dt>
     *         <dd>
     *         <p>
     *         The domain name is not available.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE_RESTRICTED</dt>
     *         <dd>
     *         <p>
     *         The domain name is forbidden.
     *         </p>
     *         </dd>
     * @see DomainAvailability
     */
    public String availabilityAsString() {
        return availability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(availabilityAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDomainAvailabilityResponse)) {
            return false;
        }
        CheckDomainAvailabilityResponse other = (CheckDomainAvailabilityResponse) obj;
        return Objects.equals(availabilityAsString(), other.availabilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CheckDomainAvailabilityResponse").add("Availability", availabilityAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Availability":
            return Optional.ofNullable(clazz.cast(availabilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckDomainAvailabilityResponse, T> g) {
        return obj -> g.apply((CheckDomainAvailabilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CheckDomainAvailabilityResponse> {
        /**
         * <p>
         * Whether the domain name is available for registering.
         * </p>
         * <note>
         * <p>
         * You can register only domains designated as <code>AVAILABLE</code>.
         * </p>
         * </note>
         * <p>
         * Valid values:
         * </p>
         * <dl>
         * <dt>AVAILABLE</dt>
         * <dd>
         * <p>
         * The domain name is available.
         * </p>
         * </dd>
         * <dt>AVAILABLE_RESERVED</dt>
         * <dd>
         * <p>
         * The domain name is reserved under specific conditions.
         * </p>
         * </dd>
         * <dt>AVAILABLE_PREORDER</dt>
         * <dd>
         * <p>
         * The domain name is available and can be preordered.
         * </p>
         * </dd>
         * <dt>DONT_KNOW</dt>
         * <dd>
         * <p>
         * The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon
         * Route 53 can return this response for a variety of reasons, for example, the registry is performing
         * maintenance. Try again later.
         * </p>
         * </dd>
         * <dt>PENDING</dt>
         * <dd>
         * <p>
         * The TLD registry didn't return a response in the expected amount of time. When the response is delayed, it
         * usually takes just a few extra seconds. You can resubmit the request immediately.
         * </p>
         * </dd>
         * <dt>RESERVED</dt>
         * <dd>
         * <p>
         * The domain name has been reserved for another person or organization.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE</dt>
         * <dd>
         * <p>
         * The domain name is not available.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE_PREMIUM</dt>
         * <dd>
         * <p>
         * The domain name is not available.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE_RESTRICTED</dt>
         * <dd>
         * <p>
         * The domain name is forbidden.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param availability
         *        Whether the domain name is available for registering.</p> <note>
         *        <p>
         *        You can register only domains designated as <code>AVAILABLE</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Valid values:
         *        </p>
         *        <dl>
         *        <dt>AVAILABLE</dt>
         *        <dd>
         *        <p>
         *        The domain name is available.
         *        </p>
         *        </dd>
         *        <dt>AVAILABLE_RESERVED</dt>
         *        <dd>
         *        <p>
         *        The domain name is reserved under specific conditions.
         *        </p>
         *        </dd>
         *        <dt>AVAILABLE_PREORDER</dt>
         *        <dd>
         *        <p>
         *        The domain name is available and can be preordered.
         *        </p>
         *        </dd>
         *        <dt>DONT_KNOW</dt>
         *        <dd>
         *        <p>
         *        The TLD registry didn't reply with a definitive answer about whether the domain name is available.
         *        Amazon Route 53 can return this response for a variety of reasons, for example, the registry is
         *        performing maintenance. Try again later.
         *        </p>
         *        </dd>
         *        <dt>PENDING</dt>
         *        <dd>
         *        <p>
         *        The TLD registry didn't return a response in the expected amount of time. When the response is
         *        delayed, it usually takes just a few extra seconds. You can resubmit the request immediately.
         *        </p>
         *        </dd>
         *        <dt>RESERVED</dt>
         *        <dd>
         *        <p>
         *        The domain name has been reserved for another person or organization.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE</dt>
         *        <dd>
         *        <p>
         *        The domain name is not available.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE_PREMIUM</dt>
         *        <dd>
         *        <p>
         *        The domain name is not available.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE_RESTRICTED</dt>
         *        <dd>
         *        <p>
         *        The domain name is forbidden.
         *        </p>
         *        </dd>
         * @see DomainAvailability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainAvailability
         */
        Builder availability(String availability);

        /**
         * <p>
         * Whether the domain name is available for registering.
         * </p>
         * <note>
         * <p>
         * You can register only domains designated as <code>AVAILABLE</code>.
         * </p>
         * </note>
         * <p>
         * Valid values:
         * </p>
         * <dl>
         * <dt>AVAILABLE</dt>
         * <dd>
         * <p>
         * The domain name is available.
         * </p>
         * </dd>
         * <dt>AVAILABLE_RESERVED</dt>
         * <dd>
         * <p>
         * The domain name is reserved under specific conditions.
         * </p>
         * </dd>
         * <dt>AVAILABLE_PREORDER</dt>
         * <dd>
         * <p>
         * The domain name is available and can be preordered.
         * </p>
         * </dd>
         * <dt>DONT_KNOW</dt>
         * <dd>
         * <p>
         * The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon
         * Route 53 can return this response for a variety of reasons, for example, the registry is performing
         * maintenance. Try again later.
         * </p>
         * </dd>
         * <dt>PENDING</dt>
         * <dd>
         * <p>
         * The TLD registry didn't return a response in the expected amount of time. When the response is delayed, it
         * usually takes just a few extra seconds. You can resubmit the request immediately.
         * </p>
         * </dd>
         * <dt>RESERVED</dt>
         * <dd>
         * <p>
         * The domain name has been reserved for another person or organization.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE</dt>
         * <dd>
         * <p>
         * The domain name is not available.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE_PREMIUM</dt>
         * <dd>
         * <p>
         * The domain name is not available.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE_RESTRICTED</dt>
         * <dd>
         * <p>
         * The domain name is forbidden.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param availability
         *        Whether the domain name is available for registering.</p> <note>
         *        <p>
         *        You can register only domains designated as <code>AVAILABLE</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Valid values:
         *        </p>
         *        <dl>
         *        <dt>AVAILABLE</dt>
         *        <dd>
         *        <p>
         *        The domain name is available.
         *        </p>
         *        </dd>
         *        <dt>AVAILABLE_RESERVED</dt>
         *        <dd>
         *        <p>
         *        The domain name is reserved under specific conditions.
         *        </p>
         *        </dd>
         *        <dt>AVAILABLE_PREORDER</dt>
         *        <dd>
         *        <p>
         *        The domain name is available and can be preordered.
         *        </p>
         *        </dd>
         *        <dt>DONT_KNOW</dt>
         *        <dd>
         *        <p>
         *        The TLD registry didn't reply with a definitive answer about whether the domain name is available.
         *        Amazon Route 53 can return this response for a variety of reasons, for example, the registry is
         *        performing maintenance. Try again later.
         *        </p>
         *        </dd>
         *        <dt>PENDING</dt>
         *        <dd>
         *        <p>
         *        The TLD registry didn't return a response in the expected amount of time. When the response is
         *        delayed, it usually takes just a few extra seconds. You can resubmit the request immediately.
         *        </p>
         *        </dd>
         *        <dt>RESERVED</dt>
         *        <dd>
         *        <p>
         *        The domain name has been reserved for another person or organization.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE</dt>
         *        <dd>
         *        <p>
         *        The domain name is not available.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE_PREMIUM</dt>
         *        <dd>
         *        <p>
         *        The domain name is not available.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE_RESTRICTED</dt>
         *        <dd>
         *        <p>
         *        The domain name is forbidden.
         *        </p>
         *        </dd>
         * @see DomainAvailability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainAvailability
         */
        Builder availability(DomainAvailability availability);
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private String availability;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDomainAvailabilityResponse model) {
            super(model);
            availability(model.availability);
        }

        public final String getAvailabilityAsString() {
            return availability;
        }

        @Override
        public final Builder availability(String availability) {
            this.availability = availability;
            return this;
        }

        @Override
        public final Builder availability(DomainAvailability availability) {
            this.availability(availability == null ? null : availability.toString());
            return this;
        }

        public final void setAvailability(String availability) {
            this.availability = availability;
        }

        @Override
        public CheckDomainAvailabilityResponse build() {
            return new CheckDomainAvailabilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
