/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CheckDomainTransferability response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckDomainTransferabilityResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<CheckDomainTransferabilityResponse.Builder, CheckDomainTransferabilityResponse> {
    private static final SdkField<DomainTransferability> TRANSFERABILITY_FIELD = SdkField
            .<DomainTransferability> builder(MarshallingType.SDK_POJO)
            .getter(getter(CheckDomainTransferabilityResponse::transferability)).setter(setter(Builder::transferability))
            .constructor(DomainTransferability::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transferability").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFERABILITY_FIELD));

    private final DomainTransferability transferability;

    private CheckDomainTransferabilityResponse(BuilderImpl builder) {
        super(builder);
        this.transferability = builder.transferability;
    }

    /**
     * <p>
     * A complex type that contains information about whether the specified domain can be transferred to Amazon Route
     * 53.
     * </p>
     * 
     * @return A complex type that contains information about whether the specified domain can be transferred to Amazon
     *         Route 53.
     */
    public DomainTransferability transferability() {
        return transferability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transferability());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDomainTransferabilityResponse)) {
            return false;
        }
        CheckDomainTransferabilityResponse other = (CheckDomainTransferabilityResponse) obj;
        return Objects.equals(transferability(), other.transferability());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CheckDomainTransferabilityResponse").add("Transferability", transferability()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transferability":
            return Optional.ofNullable(clazz.cast(transferability()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckDomainTransferabilityResponse, T> g) {
        return obj -> g.apply((CheckDomainTransferabilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CheckDomainTransferabilityResponse> {
        /**
         * <p>
         * A complex type that contains information about whether the specified domain can be transferred to Amazon
         * Route 53.
         * </p>
         * 
         * @param transferability
         *        A complex type that contains information about whether the specified domain can be transferred to
         *        Amazon Route 53.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferability(DomainTransferability transferability);

        /**
         * <p>
         * A complex type that contains information about whether the specified domain can be transferred to Amazon
         * Route 53.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainTransferability.Builder} avoiding the need
         * to create one manually via {@link DomainTransferability#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainTransferability.Builder#build()} is called immediately and
         * its result is passed to {@link #transferability(DomainTransferability)}.
         * 
         * @param transferability
         *        a consumer that will call methods on {@link DomainTransferability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transferability(DomainTransferability)
         */
        default Builder transferability(Consumer<DomainTransferability.Builder> transferability) {
            return transferability(DomainTransferability.builder().applyMutation(transferability).build());
        }
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private DomainTransferability transferability;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDomainTransferabilityResponse model) {
            super(model);
            transferability(model.transferability);
        }

        public final DomainTransferability.Builder getTransferability() {
            return transferability != null ? transferability.toBuilder() : null;
        }

        @Override
        public final Builder transferability(DomainTransferability transferability) {
            this.transferability = transferability;
            return this;
        }

        public final void setTransferability(DomainTransferability.BuilderImpl transferability) {
            this.transferability = transferability != null ? transferability.build() : null;
        }

        @Override
        public CheckDomainTransferabilityResponse build() {
            return new CheckDomainTransferabilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
