/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about one domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainSummary implements SdkPojo, Serializable, ToCopyableBuilder<DomainSummary.Builder, DomainSummary> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainSummary::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<Boolean> AUTO_RENEW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DomainSummary::autoRenew)).setter(setter(Builder::autoRenew))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRenew").build()).build();

    private static final SdkField<Boolean> TRANSFER_LOCK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DomainSummary::transferLock)).setter(setter(Builder::transferLock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferLock").build()).build();

    private static final SdkField<Instant> EXPIRY_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DomainSummary::expiry)).setter(setter(Builder::expiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            AUTO_RENEW_FIELD, TRANSFER_LOCK_FIELD, EXPIRY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final Boolean autoRenew;

    private final Boolean transferLock;

    private final Instant expiry;

    private DomainSummary(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.autoRenew = builder.autoRenew;
        this.transferLock = builder.transferLock;
        this.expiry = builder.expiry;
    }

    /**
     * <p>
     * The name of the domain that the summary information applies to.
     * </p>
     * 
     * @return The name of the domain that the summary information applies to.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Indicates whether the domain is automatically renewed upon expiration.
     * </p>
     * 
     * @return Indicates whether the domain is automatically renewed upon expiration.
     */
    public Boolean autoRenew() {
        return autoRenew;
    }

    /**
     * <p>
     * Indicates whether a domain is locked from unauthorized transfer to another party.
     * </p>
     * 
     * @return Indicates whether a domain is locked from unauthorized transfer to another party.
     */
    public Boolean transferLock() {
        return transferLock;
    }

    /**
     * <p>
     * Expiration date of the domain in Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return Expiration date of the domain in Coordinated Universal Time (UTC).
     */
    public Instant expiry() {
        return expiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(transferLock());
        hashCode = 31 * hashCode + Objects.hashCode(expiry());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSummary)) {
            return false;
        }
        DomainSummary other = (DomainSummary) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(autoRenew(), other.autoRenew())
                && Objects.equals(transferLock(), other.transferLock()) && Objects.equals(expiry(), other.expiry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DomainSummary").add("DomainName", domainName()).add("AutoRenew", autoRenew())
                .add("TransferLock", transferLock()).add("Expiry", expiry()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "AutoRenew":
            return Optional.ofNullable(clazz.cast(autoRenew()));
        case "TransferLock":
            return Optional.ofNullable(clazz.cast(transferLock()));
        case "Expiry":
            return Optional.ofNullable(clazz.cast(expiry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainSummary, T> g) {
        return obj -> g.apply((DomainSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainSummary> {
        /**
         * <p>
         * The name of the domain that the summary information applies to.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that the summary information applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Indicates whether the domain is automatically renewed upon expiration.
         * </p>
         * 
         * @param autoRenew
         *        Indicates whether the domain is automatically renewed upon expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRenew(Boolean autoRenew);

        /**
         * <p>
         * Indicates whether a domain is locked from unauthorized transfer to another party.
         * </p>
         * 
         * @param transferLock
         *        Indicates whether a domain is locked from unauthorized transfer to another party.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferLock(Boolean transferLock);

        /**
         * <p>
         * Expiration date of the domain in Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param expiry
         *        Expiration date of the domain in Coordinated Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiry(Instant expiry);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private Boolean autoRenew;

        private Boolean transferLock;

        private Instant expiry;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSummary model) {
            domainName(model.domainName);
            autoRenew(model.autoRenew);
            transferLock(model.transferLock);
            expiry(model.expiry);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getAutoRenew() {
            return autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final Boolean getTransferLock() {
            return transferLock;
        }

        @Override
        public final Builder transferLock(Boolean transferLock) {
            this.transferLock = transferLock;
            return this;
        }

        public final void setTransferLock(Boolean transferLock) {
            this.transferLock = transferLock;
        }

        public final Instant getExpiry() {
            return expiry;
        }

        @Override
        public final Builder expiry(Instant expiry) {
            this.expiry = expiry;
            return this;
        }

        public final void setExpiry(Instant expiry) {
            this.expiry = expiry;
        }

        @Override
        public DomainSummary build() {
            return new DomainSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
