/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ExtraParam includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExtraParam implements SdkPojo, Serializable, ToCopyableBuilder<ExtraParam.Builder, ExtraParam> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExtraParam::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExtraParam::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String value;

    private ExtraParam(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * Name of the additional parameter required by the top-level domain. Here are the top-level domains that require
     * additional parameters and which parameters they require:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>.com.au and .net.au:</b> <code>AU_ID_NUMBER</code> and <code>AU_ID_TYPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.ca:</b> <code>BRAND_NUMBER</code>, <code>CA_LEGAL_TYPE</code>, and <code>CA_BUSINESS_ENTITY_TYPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.es:</b> <code>ES_IDENTIFICATION</code>, <code>ES_IDENTIFICATION_TYPE</code>, and <code>ES_LEGAL_FORM</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.fi:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code>, <code>FI_BUSINESS_NUMBER</code>, <code>FI_ID_NUMBER</code>,
     * <code>FI_NATIONALITY</code>, and <code>FI_ORGANIZATION_TYPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.fr:</b> <code>BRAND_NUMBER</code>, <code>BIRTH_DEPARTMENT</code>, <code>BIRTH_DATE_IN_YYYY_MM_DD</code>,
     * <code>BIRTH_COUNTRY</code>, and <code>BIRTH_CITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.it:</b> <code>BIRTH_COUNTRY</code>, <code>IT_PIN</code>, and <code>IT_REGISTRANT_ENTITY_TYPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.ru:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code> and <code>RU_PASSPORT_DATA</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.se:</b> <code>BIRTH_COUNTRY</code> and <code>SE_ID_NUMBER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.sg:</b> <code>SG_ID_NUMBER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.co.uk, .me.uk, and .org.uk:</b> <code>UK_CONTACT_TYPE</code> and <code>UK_COMPANY_NUMBER</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * In addition, many TLDs require <code>VAT_NUMBER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ExtraParamName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Name of the additional parameter required by the top-level domain. Here are the top-level domains that
     *         require additional parameters and which parameters they require:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>.com.au and .net.au:</b> <code>AU_ID_NUMBER</code> and <code>AU_ID_TYPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.ca:</b> <code>BRAND_NUMBER</code>, <code>CA_LEGAL_TYPE</code>, and
     *         <code>CA_BUSINESS_ENTITY_TYPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.es:</b> <code>ES_IDENTIFICATION</code>, <code>ES_IDENTIFICATION_TYPE</code>, and
     *         <code>ES_LEGAL_FORM</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.fi:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code>, <code>FI_BUSINESS_NUMBER</code>,
     *         <code>FI_ID_NUMBER</code>, <code>FI_NATIONALITY</code>, and <code>FI_ORGANIZATION_TYPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.fr:</b> <code>BRAND_NUMBER</code>, <code>BIRTH_DEPARTMENT</code>,
     *         <code>BIRTH_DATE_IN_YYYY_MM_DD</code>, <code>BIRTH_COUNTRY</code>, and <code>BIRTH_CITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.it:</b> <code>BIRTH_COUNTRY</code>, <code>IT_PIN</code>, and <code>IT_REGISTRANT_ENTITY_TYPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.ru:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code> and <code>RU_PASSPORT_DATA</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.se:</b> <code>BIRTH_COUNTRY</code> and <code>SE_ID_NUMBER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.sg:</b> <code>SG_ID_NUMBER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.co.uk, .me.uk, and .org.uk:</b> <code>UK_CONTACT_TYPE</code> and <code>UK_COMPANY_NUMBER</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         In addition, many TLDs require <code>VAT_NUMBER</code>.
     * @see ExtraParamName
     */
    public ExtraParamName name() {
        return ExtraParamName.fromValue(name);
    }

    /**
     * <p>
     * Name of the additional parameter required by the top-level domain. Here are the top-level domains that require
     * additional parameters and which parameters they require:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>.com.au and .net.au:</b> <code>AU_ID_NUMBER</code> and <code>AU_ID_TYPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.ca:</b> <code>BRAND_NUMBER</code>, <code>CA_LEGAL_TYPE</code>, and <code>CA_BUSINESS_ENTITY_TYPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.es:</b> <code>ES_IDENTIFICATION</code>, <code>ES_IDENTIFICATION_TYPE</code>, and <code>ES_LEGAL_FORM</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.fi:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code>, <code>FI_BUSINESS_NUMBER</code>, <code>FI_ID_NUMBER</code>,
     * <code>FI_NATIONALITY</code>, and <code>FI_ORGANIZATION_TYPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.fr:</b> <code>BRAND_NUMBER</code>, <code>BIRTH_DEPARTMENT</code>, <code>BIRTH_DATE_IN_YYYY_MM_DD</code>,
     * <code>BIRTH_COUNTRY</code>, and <code>BIRTH_CITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.it:</b> <code>BIRTH_COUNTRY</code>, <code>IT_PIN</code>, and <code>IT_REGISTRANT_ENTITY_TYPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.ru:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code> and <code>RU_PASSPORT_DATA</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.se:</b> <code>BIRTH_COUNTRY</code> and <code>SE_ID_NUMBER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.sg:</b> <code>SG_ID_NUMBER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>.co.uk, .me.uk, and .org.uk:</b> <code>UK_CONTACT_TYPE</code> and <code>UK_COMPANY_NUMBER</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * In addition, many TLDs require <code>VAT_NUMBER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ExtraParamName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Name of the additional parameter required by the top-level domain. Here are the top-level domains that
     *         require additional parameters and which parameters they require:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>.com.au and .net.au:</b> <code>AU_ID_NUMBER</code> and <code>AU_ID_TYPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.ca:</b> <code>BRAND_NUMBER</code>, <code>CA_LEGAL_TYPE</code>, and
     *         <code>CA_BUSINESS_ENTITY_TYPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.es:</b> <code>ES_IDENTIFICATION</code>, <code>ES_IDENTIFICATION_TYPE</code>, and
     *         <code>ES_LEGAL_FORM</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.fi:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code>, <code>FI_BUSINESS_NUMBER</code>,
     *         <code>FI_ID_NUMBER</code>, <code>FI_NATIONALITY</code>, and <code>FI_ORGANIZATION_TYPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.fr:</b> <code>BRAND_NUMBER</code>, <code>BIRTH_DEPARTMENT</code>,
     *         <code>BIRTH_DATE_IN_YYYY_MM_DD</code>, <code>BIRTH_COUNTRY</code>, and <code>BIRTH_CITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.it:</b> <code>BIRTH_COUNTRY</code>, <code>IT_PIN</code>, and <code>IT_REGISTRANT_ENTITY_TYPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.ru:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code> and <code>RU_PASSPORT_DATA</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.se:</b> <code>BIRTH_COUNTRY</code> and <code>SE_ID_NUMBER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.sg:</b> <code>SG_ID_NUMBER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>.co.uk, .me.uk, and .org.uk:</b> <code>UK_CONTACT_TYPE</code> and <code>UK_COMPANY_NUMBER</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         In addition, many TLDs require <code>VAT_NUMBER</code>.
     * @see ExtraParamName
     */
    public String nameAsString() {
        return name;
    }

    /**
     * <p>
     * Values corresponding to the additional parameter names required by some top-level domains.
     * </p>
     * 
     * @return Values corresponding to the additional parameter names required by some top-level domains.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtraParam)) {
            return false;
        }
        ExtraParam other = (ExtraParam) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExtraParam").add("Name", nameAsString()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExtraParam, T> g) {
        return obj -> g.apply((ExtraParam) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExtraParam> {
        /**
         * <p>
         * Name of the additional parameter required by the top-level domain. Here are the top-level domains that
         * require additional parameters and which parameters they require:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>.com.au and .net.au:</b> <code>AU_ID_NUMBER</code> and <code>AU_ID_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.ca:</b> <code>BRAND_NUMBER</code>, <code>CA_LEGAL_TYPE</code>, and <code>CA_BUSINESS_ENTITY_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.es:</b> <code>ES_IDENTIFICATION</code>, <code>ES_IDENTIFICATION_TYPE</code>, and
         * <code>ES_LEGAL_FORM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.fi:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code>, <code>FI_BUSINESS_NUMBER</code>, <code>FI_ID_NUMBER</code>, <code>FI_NATIONALITY</code>, and <code>FI_ORGANIZATION_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.fr:</b> <code>BRAND_NUMBER</code>, <code>BIRTH_DEPARTMENT</code>, <code>BIRTH_DATE_IN_YYYY_MM_DD</code>,
         * <code>BIRTH_COUNTRY</code>, and <code>BIRTH_CITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.it:</b> <code>BIRTH_COUNTRY</code>, <code>IT_PIN</code>, and <code>IT_REGISTRANT_ENTITY_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.ru:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code> and <code>RU_PASSPORT_DATA</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.se:</b> <code>BIRTH_COUNTRY</code> and <code>SE_ID_NUMBER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.sg:</b> <code>SG_ID_NUMBER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.co.uk, .me.uk, and .org.uk:</b> <code>UK_CONTACT_TYPE</code> and <code>UK_COMPANY_NUMBER</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * In addition, many TLDs require <code>VAT_NUMBER</code>.
         * </p>
         * 
         * @param name
         *        Name of the additional parameter required by the top-level domain. Here are the top-level domains that
         *        require additional parameters and which parameters they require:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>.com.au and .net.au:</b> <code>AU_ID_NUMBER</code> and <code>AU_ID_TYPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.ca:</b> <code>BRAND_NUMBER</code>, <code>CA_LEGAL_TYPE</code>, and
         *        <code>CA_BUSINESS_ENTITY_TYPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.es:</b> <code>ES_IDENTIFICATION</code>, <code>ES_IDENTIFICATION_TYPE</code>, and
         *        <code>ES_LEGAL_FORM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.fi:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code>, <code>FI_BUSINESS_NUMBER</code>,
         *        <code>FI_ID_NUMBER</code>, <code>FI_NATIONALITY</code>, and <code>FI_ORGANIZATION_TYPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.fr:</b> <code>BRAND_NUMBER</code>, <code>BIRTH_DEPARTMENT</code>,
         *        <code>BIRTH_DATE_IN_YYYY_MM_DD</code>, <code>BIRTH_COUNTRY</code>, and <code>BIRTH_CITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.it:</b> <code>BIRTH_COUNTRY</code>, <code>IT_PIN</code>, and
         *        <code>IT_REGISTRANT_ENTITY_TYPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.ru:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code> and <code>RU_PASSPORT_DATA</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.se:</b> <code>BIRTH_COUNTRY</code> and <code>SE_ID_NUMBER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.sg:</b> <code>SG_ID_NUMBER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.co.uk, .me.uk, and .org.uk:</b> <code>UK_CONTACT_TYPE</code> and <code>UK_COMPANY_NUMBER</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        In addition, many TLDs require <code>VAT_NUMBER</code>.
         * @see ExtraParamName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExtraParamName
         */
        Builder name(String name);

        /**
         * <p>
         * Name of the additional parameter required by the top-level domain. Here are the top-level domains that
         * require additional parameters and which parameters they require:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>.com.au and .net.au:</b> <code>AU_ID_NUMBER</code> and <code>AU_ID_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.ca:</b> <code>BRAND_NUMBER</code>, <code>CA_LEGAL_TYPE</code>, and <code>CA_BUSINESS_ENTITY_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.es:</b> <code>ES_IDENTIFICATION</code>, <code>ES_IDENTIFICATION_TYPE</code>, and
         * <code>ES_LEGAL_FORM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.fi:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code>, <code>FI_BUSINESS_NUMBER</code>, <code>FI_ID_NUMBER</code>, <code>FI_NATIONALITY</code>, and <code>FI_ORGANIZATION_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.fr:</b> <code>BRAND_NUMBER</code>, <code>BIRTH_DEPARTMENT</code>, <code>BIRTH_DATE_IN_YYYY_MM_DD</code>,
         * <code>BIRTH_COUNTRY</code>, and <code>BIRTH_CITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.it:</b> <code>BIRTH_COUNTRY</code>, <code>IT_PIN</code>, and <code>IT_REGISTRANT_ENTITY_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.ru:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code> and <code>RU_PASSPORT_DATA</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.se:</b> <code>BIRTH_COUNTRY</code> and <code>SE_ID_NUMBER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.sg:</b> <code>SG_ID_NUMBER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>.co.uk, .me.uk, and .org.uk:</b> <code>UK_CONTACT_TYPE</code> and <code>UK_COMPANY_NUMBER</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * In addition, many TLDs require <code>VAT_NUMBER</code>.
         * </p>
         * 
         * @param name
         *        Name of the additional parameter required by the top-level domain. Here are the top-level domains that
         *        require additional parameters and which parameters they require:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>.com.au and .net.au:</b> <code>AU_ID_NUMBER</code> and <code>AU_ID_TYPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.ca:</b> <code>BRAND_NUMBER</code>, <code>CA_LEGAL_TYPE</code>, and
         *        <code>CA_BUSINESS_ENTITY_TYPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.es:</b> <code>ES_IDENTIFICATION</code>, <code>ES_IDENTIFICATION_TYPE</code>, and
         *        <code>ES_LEGAL_FORM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.fi:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code>, <code>FI_BUSINESS_NUMBER</code>,
         *        <code>FI_ID_NUMBER</code>, <code>FI_NATIONALITY</code>, and <code>FI_ORGANIZATION_TYPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.fr:</b> <code>BRAND_NUMBER</code>, <code>BIRTH_DEPARTMENT</code>,
         *        <code>BIRTH_DATE_IN_YYYY_MM_DD</code>, <code>BIRTH_COUNTRY</code>, and <code>BIRTH_CITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.it:</b> <code>BIRTH_COUNTRY</code>, <code>IT_PIN</code>, and
         *        <code>IT_REGISTRANT_ENTITY_TYPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.ru:</b> <code>BIRTH_DATE_IN_YYYY_MM_DD</code> and <code>RU_PASSPORT_DATA</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.se:</b> <code>BIRTH_COUNTRY</code> and <code>SE_ID_NUMBER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.sg:</b> <code>SG_ID_NUMBER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>.co.uk, .me.uk, and .org.uk:</b> <code>UK_CONTACT_TYPE</code> and <code>UK_COMPANY_NUMBER</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        In addition, many TLDs require <code>VAT_NUMBER</code>.
         * @see ExtraParamName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExtraParamName
         */
        Builder name(ExtraParamName name);

        /**
         * <p>
         * Values corresponding to the additional parameter names required by some top-level domains.
         * </p>
         * 
         * @param value
         *        Values corresponding to the additional parameter names required by some top-level domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtraParam model) {
            name(model.name);
            value(model.value);
        }

        public final String getNameAsString() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ExtraParamName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public ExtraParam build() {
            return new ExtraParam(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
