/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDomainSuggestionsRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<GetDomainSuggestionsRequest.Builder, GetDomainSuggestionsRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDomainSuggestionsRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<Integer> SUGGESTION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetDomainSuggestionsRequest::suggestionCount)).setter(setter(Builder::suggestionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestionCount").build()).build();

    private static final SdkField<Boolean> ONLY_AVAILABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetDomainSuggestionsRequest::onlyAvailable)).setter(setter(Builder::onlyAvailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlyAvailable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            SUGGESTION_COUNT_FIELD, ONLY_AVAILABLE_FIELD));

    private final String domainName;

    private final Integer suggestionCount;

    private final Boolean onlyAvailable;

    private GetDomainSuggestionsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.suggestionCount = builder.suggestionCount;
        this.onlyAvailable = builder.onlyAvailable;
    }

    /**
     * <p>
     * A domain name that you want to use as the basis for a list of possible domain names. The domain name must contain
     * a top-level domain (TLD), such as .com, that Amazon Route 53 supports. For a list of TLDs, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
     * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * 
     * @return A domain name that you want to use as the basis for a list of possible domain names. The domain name must
     *         contain a top-level domain (TLD), such as .com, that Amazon Route 53 supports. For a list of TLDs, see <a
     *         href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You
     *         Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The number of suggested domain names that you want Amazon Route 53 to return.
     * </p>
     * 
     * @return The number of suggested domain names that you want Amazon Route 53 to return.
     */
    public Integer suggestionCount() {
        return suggestionCount;
    }

    /**
     * <p>
     * If <code>OnlyAvailable</code> is <code>true</code>, Amazon Route 53 returns only domain names that are available.
     * If <code>OnlyAvailable</code> is <code>false</code>, Amazon Route 53 returns domain names without checking
     * whether they're available to be registered. To determine whether the domain is available, you can call
     * <code>checkDomainAvailability</code> for each suggestion.
     * </p>
     * 
     * @return If <code>OnlyAvailable</code> is <code>true</code>, Amazon Route 53 returns only domain names that are
     *         available. If <code>OnlyAvailable</code> is <code>false</code>, Amazon Route 53 returns domain names
     *         without checking whether they're available to be registered. To determine whether the domain is
     *         available, you can call <code>checkDomainAvailability</code> for each suggestion.
     */
    public Boolean onlyAvailable() {
        return onlyAvailable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(suggestionCount());
        hashCode = 31 * hashCode + Objects.hashCode(onlyAvailable());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainSuggestionsRequest)) {
            return false;
        }
        GetDomainSuggestionsRequest other = (GetDomainSuggestionsRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(suggestionCount(), other.suggestionCount())
                && Objects.equals(onlyAvailable(), other.onlyAvailable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDomainSuggestionsRequest").add("DomainName", domainName())
                .add("SuggestionCount", suggestionCount()).add("OnlyAvailable", onlyAvailable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "SuggestionCount":
            return Optional.ofNullable(clazz.cast(suggestionCount()));
        case "OnlyAvailable":
            return Optional.ofNullable(clazz.cast(onlyAvailable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainSuggestionsRequest, T> g) {
        return obj -> g.apply((GetDomainSuggestionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDomainSuggestionsRequest> {
        /**
         * <p>
         * A domain name that you want to use as the basis for a list of possible domain names. The domain name must
         * contain a top-level domain (TLD), such as .com, that Amazon Route 53 supports. For a list of TLDs, see <a
         * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
         * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * 
         * @param domainName
         *        A domain name that you want to use as the basis for a list of possible domain names. The domain name
         *        must contain a top-level domain (TLD), such as .com, that Amazon Route 53 supports. For a list of
         *        TLDs, see <a
         *        href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that
         *        You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The number of suggested domain names that you want Amazon Route 53 to return.
         * </p>
         * 
         * @param suggestionCount
         *        The number of suggested domain names that you want Amazon Route 53 to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionCount(Integer suggestionCount);

        /**
         * <p>
         * If <code>OnlyAvailable</code> is <code>true</code>, Amazon Route 53 returns only domain names that are
         * available. If <code>OnlyAvailable</code> is <code>false</code>, Amazon Route 53 returns domain names without
         * checking whether they're available to be registered. To determine whether the domain is available, you can
         * call <code>checkDomainAvailability</code> for each suggestion.
         * </p>
         * 
         * @param onlyAvailable
         *        If <code>OnlyAvailable</code> is <code>true</code>, Amazon Route 53 returns only domain names that are
         *        available. If <code>OnlyAvailable</code> is <code>false</code>, Amazon Route 53 returns domain names
         *        without checking whether they're available to be registered. To determine whether the domain is
         *        available, you can call <code>checkDomainAvailability</code> for each suggestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onlyAvailable(Boolean onlyAvailable);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private Integer suggestionCount;

        private Boolean onlyAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainSuggestionsRequest model) {
            super(model);
            domainName(model.domainName);
            suggestionCount(model.suggestionCount);
            onlyAvailable(model.onlyAvailable);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Integer getSuggestionCount() {
            return suggestionCount;
        }

        @Override
        public final Builder suggestionCount(Integer suggestionCount) {
            this.suggestionCount = suggestionCount;
            return this;
        }

        public final void setSuggestionCount(Integer suggestionCount) {
            this.suggestionCount = suggestionCount;
        }

        public final Boolean getOnlyAvailable() {
            return onlyAvailable;
        }

        @Override
        public final Builder onlyAvailable(Boolean onlyAvailable) {
            this.onlyAvailable = onlyAvailable;
            return this;
        }

        public final void setOnlyAvailable(Boolean onlyAvailable) {
            this.onlyAvailable = onlyAvailable;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDomainSuggestionsRequest build() {
            return new GetDomainSuggestionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
