/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDomainSuggestionsResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<GetDomainSuggestionsResponse.Builder, GetDomainSuggestionsResponse> {
    private static final SdkField<List<DomainSuggestion>> SUGGESTIONS_LIST_FIELD = SdkField
            .<List<DomainSuggestion>> builder(MarshallingType.LIST)
            .getter(getter(GetDomainSuggestionsResponse::suggestionsList))
            .setter(setter(Builder::suggestionsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestionsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainSuggestion> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainSuggestion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUGGESTIONS_LIST_FIELD));

    private final List<DomainSuggestion> suggestionsList;

    private GetDomainSuggestionsResponse(BuilderImpl builder) {
        super(builder);
        this.suggestionsList = builder.suggestionsList;
    }

    /**
     * Returns true if the SuggestionsList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSuggestionsList() {
        return suggestionsList != null && !(suggestionsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
     * request, the list contains only domains that are available for registration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuggestionsList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
     *         request, the list contains only domains that are available for registration.
     */
    public List<DomainSuggestion> suggestionsList() {
        return suggestionsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suggestionsList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainSuggestionsResponse)) {
            return false;
        }
        GetDomainSuggestionsResponse other = (GetDomainSuggestionsResponse) obj;
        return Objects.equals(suggestionsList(), other.suggestionsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDomainSuggestionsResponse").add("SuggestionsList", suggestionsList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuggestionsList":
            return Optional.ofNullable(clazz.cast(suggestionsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainSuggestionsResponse, T> g) {
        return obj -> g.apply((GetDomainSuggestionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDomainSuggestionsResponse> {
        /**
         * <p>
         * A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
         * request, the list contains only domains that are available for registration.
         * </p>
         * 
         * @param suggestionsList
         *        A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in
         *        the request, the list contains only domains that are available for registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionsList(Collection<DomainSuggestion> suggestionsList);

        /**
         * <p>
         * A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
         * request, the list contains only domains that are available for registration.
         * </p>
         * 
         * @param suggestionsList
         *        A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in
         *        the request, the list contains only domains that are available for registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionsList(DomainSuggestion... suggestionsList);

        /**
         * <p>
         * A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
         * request, the list contains only domains that are available for registration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DomainSuggestion>.Builder} avoiding the
         * need to create one manually via {@link List<DomainSuggestion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainSuggestion>.Builder#build()} is called immediately and
         * its result is passed to {@link #suggestionsList(List<DomainSuggestion>)}.
         * 
         * @param suggestionsList
         *        a consumer that will call methods on {@link List<DomainSuggestion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suggestionsList(List<DomainSuggestion>)
         */
        Builder suggestionsList(Consumer<DomainSuggestion.Builder>... suggestionsList);
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private List<DomainSuggestion> suggestionsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainSuggestionsResponse model) {
            super(model);
            suggestionsList(model.suggestionsList);
        }

        public final Collection<DomainSuggestion.Builder> getSuggestionsList() {
            return suggestionsList != null ? suggestionsList.stream().map(DomainSuggestion::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder suggestionsList(Collection<DomainSuggestion> suggestionsList) {
            this.suggestionsList = DomainSuggestionsListCopier.copy(suggestionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionsList(DomainSuggestion... suggestionsList) {
            suggestionsList(Arrays.asList(suggestionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionsList(Consumer<DomainSuggestion.Builder>... suggestionsList) {
            suggestionsList(Stream.of(suggestionsList).map(c -> DomainSuggestion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSuggestionsList(Collection<DomainSuggestion.BuilderImpl> suggestionsList) {
            this.suggestionsList = DomainSuggestionsListCopier.copyFromBuilder(suggestionsList);
        }

        @Override
        public GetDomainSuggestionsResponse build() {
            return new GetDomainSuggestionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
