/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ListOperations request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOperationsRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<ListOperationsRequest.Builder, ListOperationsRequest> {
    private static final SdkField<Instant> SUBMITTED_SINCE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListOperationsRequest::submittedSince)).setter(setter(Builder::submittedSince))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedSince").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOperationsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListOperationsRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBMITTED_SINCE_FIELD,
            MARKER_FIELD, MAX_ITEMS_FIELD));

    private final Instant submittedSince;

    private final String marker;

    private final Integer maxItems;

    private ListOperationsRequest(BuilderImpl builder) {
        super(builder);
        this.submittedSince = builder.submittedSince;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * An optional parameter that lets you get information about all the operations that you submitted after a specified
     * date and time. Specify the date and time in Coordinated Universal time (UTC).
     * </p>
     * 
     * @return An optional parameter that lets you get information about all the operations that you submitted after a
     *         specified date and time. Specify the date and time in Coordinated Universal time (UTC).
     */
    public Instant submittedSince() {
        return submittedSince;
    }

    /**
     * <p>
     * For an initial request for a list of operations, omit this element. If the number of operations that are not yet
     * complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code>
     * to return additional operations. Get the value of <code>NextPageMarker</code> from the previous response, and
     * submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.
     * </p>
     * 
     * @return For an initial request for a list of operations, omit this element. If the number of operations that are
     *         not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use
     *         <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code> from
     *         the previous response, and submit another request that includes the value of <code>NextPageMarker</code>
     *         in the <code>Marker</code> element.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Number of domains to be returned.
     * </p>
     * <p>
     * Default: 20
     * </p>
     * 
     * @return Number of domains to be returned.</p>
     *         <p>
     *         Default: 20
     */
    public Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(submittedSince());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsRequest)) {
            return false;
        }
        ListOperationsRequest other = (ListOperationsRequest) obj;
        return Objects.equals(submittedSince(), other.submittedSince()) && Objects.equals(marker(), other.marker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListOperationsRequest").add("SubmittedSince", submittedSince()).add("Marker", marker())
                .add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubmittedSince":
            return Optional.ofNullable(clazz.cast(submittedSince()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOperationsRequest, T> g) {
        return obj -> g.apply((ListOperationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListOperationsRequest> {
        /**
         * <p>
         * An optional parameter that lets you get information about all the operations that you submitted after a
         * specified date and time. Specify the date and time in Coordinated Universal time (UTC).
         * </p>
         * 
         * @param submittedSince
         *        An optional parameter that lets you get information about all the operations that you submitted after
         *        a specified date and time. Specify the date and time in Coordinated Universal time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedSince(Instant submittedSince);

        /**
         * <p>
         * For an initial request for a list of operations, omit this element. If the number of operations that are not
         * yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use
         * <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code> from the
         * previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the
         * <code>Marker</code> element.
         * </p>
         * 
         * @param marker
         *        For an initial request for a list of operations, omit this element. If the number of operations that
         *        are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can
         *        use <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code>
         *        from the previous response, and submit another request that includes the value of
         *        <code>NextPageMarker</code> in the <code>Marker</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Number of domains to be returned.
         * </p>
         * <p>
         * Default: 20
         * </p>
         * 
         * @param maxItems
         *        Number of domains to be returned.</p>
         *        <p>
         *        Default: 20
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private Instant submittedSince;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsRequest model) {
            super(model);
            submittedSince(model.submittedSince);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final Instant getSubmittedSince() {
            return submittedSince;
        }

        @Override
        public final Builder submittedSince(Instant submittedSince) {
            this.submittedSince = submittedSince;
            return this;
        }

        public final void setSubmittedSince(Instant submittedSince) {
            this.submittedSince = submittedSince;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOperationsRequest build() {
            return new ListOperationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
