/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Nameserver includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Nameserver implements SdkPojo, Serializable, ToCopyableBuilder<Nameserver.Builder, Nameserver> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Nameserver::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> GLUE_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Nameserver::glueIps))
            .setter(setter(Builder::glueIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, GLUE_IPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> glueIps;

    private Nameserver(BuilderImpl builder) {
        this.name = builder.name;
        this.glueIps = builder.glueIps;
    }

    /**
     * <p>
     * The fully qualified host name of the name server.
     * </p>
     * <p>
     * Constraint: Maximum 255 characters
     * </p>
     * 
     * @return The fully qualified host name of the name server.</p>
     *         <p>
     *         Constraint: Maximum 255 characters
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the GlueIps property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasGlueIps() {
        return glueIps != null && !(glueIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name server is a
     * subdomain of the domain. For example, if your domain is example.com and the name server for the domain is
     * ns.example.com, you need to specify the IP address for ns.example.com.
     * </p>
     * <p>
     * Constraints: The list can contain only one IPv4 and one IPv6 address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGlueIps()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name
     *         server is a subdomain of the domain. For example, if your domain is example.com and the name server for
     *         the domain is ns.example.com, you need to specify the IP address for ns.example.com.</p>
     *         <p>
     *         Constraints: The list can contain only one IPv4 and one IPv6 address.
     */
    public List<String> glueIps() {
        return glueIps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(glueIps());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Nameserver)) {
            return false;
        }
        Nameserver other = (Nameserver) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(glueIps(), other.glueIps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Nameserver").add("Name", name()).add("GlueIps", glueIps()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "GlueIps":
            return Optional.ofNullable(clazz.cast(glueIps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Nameserver, T> g) {
        return obj -> g.apply((Nameserver) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Nameserver> {
        /**
         * <p>
         * The fully qualified host name of the name server.
         * </p>
         * <p>
         * Constraint: Maximum 255 characters
         * </p>
         * 
         * @param name
         *        The fully qualified host name of the name server.</p>
         *        <p>
         *        Constraint: Maximum 255 characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name server
         * is a subdomain of the domain. For example, if your domain is example.com and the name server for the domain
         * is ns.example.com, you need to specify the IP address for ns.example.com.
         * </p>
         * <p>
         * Constraints: The list can contain only one IPv4 and one IPv6 address.
         * </p>
         * 
         * @param glueIps
         *        Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name
         *        server is a subdomain of the domain. For example, if your domain is example.com and the name server
         *        for the domain is ns.example.com, you need to specify the IP address for ns.example.com.</p>
         *        <p>
         *        Constraints: The list can contain only one IPv4 and one IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueIps(Collection<String> glueIps);

        /**
         * <p>
         * Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name server
         * is a subdomain of the domain. For example, if your domain is example.com and the name server for the domain
         * is ns.example.com, you need to specify the IP address for ns.example.com.
         * </p>
         * <p>
         * Constraints: The list can contain only one IPv4 and one IPv6 address.
         * </p>
         * 
         * @param glueIps
         *        Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name
         *        server is a subdomain of the domain. For example, if your domain is example.com and the name server
         *        for the domain is ns.example.com, you need to specify the IP address for ns.example.com.</p>
         *        <p>
         *        Constraints: The list can contain only one IPv4 and one IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueIps(String... glueIps);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> glueIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Nameserver model) {
            name(model.name);
            glueIps(model.glueIps);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getGlueIps() {
            return glueIps;
        }

        @Override
        public final Builder glueIps(Collection<String> glueIps) {
            this.glueIps = GlueIpListCopier.copy(glueIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glueIps(String... glueIps) {
            glueIps(Arrays.asList(glueIps));
            return this;
        }

        public final void setGlueIps(Collection<String> glueIps) {
            this.glueIps = GlueIpListCopier.copy(glueIps);
        }

        @Override
        public Nameserver build() {
            return new Nameserver(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
