/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The RetrieveDomainAuthCode response includes the following element.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieveDomainAuthCodeResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<RetrieveDomainAuthCodeResponse.Builder, RetrieveDomainAuthCodeResponse> {
    private static final SdkField<String> AUTH_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RetrieveDomainAuthCodeResponse::authCode)).setter(setter(Builder::authCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_CODE_FIELD));

    private final String authCode;

    private RetrieveDomainAuthCodeResponse(BuilderImpl builder) {
        super(builder);
        this.authCode = builder.authCode;
    }

    /**
     * <p>
     * The authorization code for the domain.
     * </p>
     * 
     * @return The authorization code for the domain.
     */
    public String authCode() {
        return authCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveDomainAuthCodeResponse)) {
            return false;
        }
        RetrieveDomainAuthCodeResponse other = (RetrieveDomainAuthCodeResponse) obj;
        return Objects.equals(authCode(), other.authCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RetrieveDomainAuthCodeResponse")
                .add("AuthCode", authCode() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthCode":
            return Optional.ofNullable(clazz.cast(authCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveDomainAuthCodeResponse, T> g) {
        return obj -> g.apply((RetrieveDomainAuthCodeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RetrieveDomainAuthCodeResponse> {
        /**
         * <p>
         * The authorization code for the domain.
         * </p>
         * 
         * @param authCode
         *        The authorization code for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authCode(String authCode);
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private String authCode;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveDomainAuthCodeResponse model) {
            super(model);
            authCode(model.authCode);
        }

        public final String getAuthCode() {
            return authCode;
        }

        @Override
        public final Builder authCode(String authCode) {
            this.authCode = authCode;
            return this;
        }

        public final void setAuthCode(String authCode) {
            this.authCode = authCode;
        }

        @Override
        public RetrieveDomainAuthCodeResponse build() {
            return new RetrieveDomainAuthCodeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
