/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The UpdateDomainContactPrivacy request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainContactPrivacyRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<UpdateDomainContactPrivacyRequest.Builder, UpdateDomainContactPrivacyRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDomainContactPrivacyRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<Boolean> ADMIN_PRIVACY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateDomainContactPrivacyRequest::adminPrivacy)).setter(setter(Builder::adminPrivacy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminPrivacy").build()).build();

    private static final SdkField<Boolean> REGISTRANT_PRIVACY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateDomainContactPrivacyRequest::registrantPrivacy)).setter(setter(Builder::registrantPrivacy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrantPrivacy").build()).build();

    private static final SdkField<Boolean> TECH_PRIVACY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateDomainContactPrivacyRequest::techPrivacy)).setter(setter(Builder::techPrivacy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechPrivacy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            ADMIN_PRIVACY_FIELD, REGISTRANT_PRIVACY_FIELD, TECH_PRIVACY_FIELD));

    private final String domainName;

    private final Boolean adminPrivacy;

    private final Boolean registrantPrivacy;

    private final Boolean techPrivacy;

    private UpdateDomainContactPrivacyRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.adminPrivacy = builder.adminPrivacy;
        this.registrantPrivacy = builder.registrantPrivacy;
        this.techPrivacy = builder.techPrivacy;
    }

    /**
     * <p>
     * The name of the domain that you want to update the privacy setting for.
     * </p>
     * 
     * @return The name of the domain that you want to update the privacy setting for.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or
     * for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return
     * the information that you entered for the admin contact.
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org
     *         domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
     *         WHOIS queries return the information that you entered for the admin contact.
     */
    public Boolean adminPrivacy() {
        return adminPrivacy;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or
     * for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return
     * the information that you entered for the registrant contact (domain owner).
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org
     *         domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
     *         WHOIS queries return the information that you entered for the registrant contact (domain owner).
     */
    public Boolean registrantPrivacy() {
        return registrantPrivacy;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or
     * for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return
     * the information that you entered for the technical contact.
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org
     *         domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
     *         WHOIS queries return the information that you entered for the technical contact.
     */
    public Boolean techPrivacy() {
        return techPrivacy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(adminPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(registrantPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(techPrivacy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainContactPrivacyRequest)) {
            return false;
        }
        UpdateDomainContactPrivacyRequest other = (UpdateDomainContactPrivacyRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(adminPrivacy(), other.adminPrivacy())
                && Objects.equals(registrantPrivacy(), other.registrantPrivacy())
                && Objects.equals(techPrivacy(), other.techPrivacy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDomainContactPrivacyRequest").add("DomainName", domainName())
                .add("AdminPrivacy", adminPrivacy()).add("RegistrantPrivacy", registrantPrivacy())
                .add("TechPrivacy", techPrivacy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "AdminPrivacy":
            return Optional.ofNullable(clazz.cast(adminPrivacy()));
        case "RegistrantPrivacy":
            return Optional.ofNullable(clazz.cast(registrantPrivacy()));
        case "TechPrivacy":
            return Optional.ofNullable(clazz.cast(techPrivacy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainContactPrivacyRequest, T> g) {
        return obj -> g.apply((UpdateDomainContactPrivacyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDomainContactPrivacyRequest> {
        /**
         * <p>
         * The name of the domain that you want to update the privacy setting for.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want to update the privacy setting for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
         * or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries
         * return the information that you entered for the admin contact.
         * </p>
         * 
         * @param adminPrivacy
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and
         *        .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify
         *        <code>false</code>, WHOIS queries return the information that you entered for the admin contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminPrivacy(Boolean adminPrivacy);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
         * or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries
         * return the information that you entered for the registrant contact (domain owner).
         * </p>
         * 
         * @param registrantPrivacy
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and
         *        .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify
         *        <code>false</code>, WHOIS queries return the information that you entered for the registrant contact
         *        (domain owner).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrantPrivacy(Boolean registrantPrivacy);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
         * or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries
         * return the information that you entered for the technical contact.
         * </p>
         * 
         * @param techPrivacy
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and
         *        .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify
         *        <code>false</code>, WHOIS queries return the information that you entered for the technical contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder techPrivacy(Boolean techPrivacy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private Boolean adminPrivacy;

        private Boolean registrantPrivacy;

        private Boolean techPrivacy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainContactPrivacyRequest model) {
            super(model);
            domainName(model.domainName);
            adminPrivacy(model.adminPrivacy);
            registrantPrivacy(model.registrantPrivacy);
            techPrivacy(model.techPrivacy);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getAdminPrivacy() {
            return adminPrivacy;
        }

        @Override
        public final Builder adminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
            return this;
        }

        public final void setAdminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
        }

        public final Boolean getRegistrantPrivacy() {
            return registrantPrivacy;
        }

        @Override
        public final Builder registrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
            return this;
        }

        public final void setRegistrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
        }

        public final Boolean getTechPrivacy() {
            return techPrivacy;
        }

        @Override
        public final Builder techPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
            return this;
        }

        public final void setTechPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainContactPrivacyRequest build() {
            return new UpdateDomainContactPrivacyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
