/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The UpdateTagsForDomainRequest includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTagsForDomainRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<UpdateTagsForDomainRequest.Builder, UpdateTagsForDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTagsForDomainRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<List<Tag>> TAGS_TO_UPDATE_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(UpdateTagsForDomainRequest::tagsToUpdate))
            .setter(setter(Builder::tagsToUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsToUpdate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            TAGS_TO_UPDATE_FIELD));

    private final String domainName;

    private final List<Tag> tagsToUpdate;

    private UpdateTagsForDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.tagsToUpdate = builder.tagsToUpdate;
    }

    /**
     * <p>
     * The domain for which you want to add or update tags.
     * </p>
     * 
     * @return The domain for which you want to add or update tags.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * Returns true if the TagsToUpdate property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTagsToUpdate() {
        return tagsToUpdate != null && !(tagsToUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the tag keys and values that you want to add or update. If you specify a key that already exists, the
     * corresponding value will be replaced.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagsToUpdate()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the tag keys and values that you want to add or update. If you specify a key that already
     *         exists, the corresponding value will be replaced.
     */
    public List<Tag> tagsToUpdate() {
        return tagsToUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(tagsToUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTagsForDomainRequest)) {
            return false;
        }
        UpdateTagsForDomainRequest other = (UpdateTagsForDomainRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(tagsToUpdate(), other.tagsToUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateTagsForDomainRequest").add("DomainName", domainName()).add("TagsToUpdate", tagsToUpdate())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "TagsToUpdate":
            return Optional.ofNullable(clazz.cast(tagsToUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTagsForDomainRequest, T> g) {
        return obj -> g.apply((UpdateTagsForDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTagsForDomainRequest> {
        /**
         * <p>
         * The domain for which you want to add or update tags.
         * </p>
         * 
         * @param domainName
         *        The domain for which you want to add or update tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A list of the tag keys and values that you want to add or update. If you specify a key that already exists,
         * the corresponding value will be replaced.
         * </p>
         * 
         * @param tagsToUpdate
         *        A list of the tag keys and values that you want to add or update. If you specify a key that already
         *        exists, the corresponding value will be replaced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToUpdate(Collection<Tag> tagsToUpdate);

        /**
         * <p>
         * A list of the tag keys and values that you want to add or update. If you specify a key that already exists,
         * the corresponding value will be replaced.
         * </p>
         * 
         * @param tagsToUpdate
         *        A list of the tag keys and values that you want to add or update. If you specify a key that already
         *        exists, the corresponding value will be replaced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToUpdate(Tag... tagsToUpdate);

        /**
         * <p>
         * A list of the tag keys and values that you want to add or update. If you specify a key that already exists,
         * the corresponding value will be replaced.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tagsToUpdate(List<Tag>)}.
         * 
         * @param tagsToUpdate
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagsToUpdate(List<Tag>)
         */
        Builder tagsToUpdate(Consumer<Tag.Builder>... tagsToUpdate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private List<Tag> tagsToUpdate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTagsForDomainRequest model) {
            super(model);
            domainName(model.domainName);
            tagsToUpdate(model.tagsToUpdate);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<Tag.Builder> getTagsToUpdate() {
            return tagsToUpdate != null ? tagsToUpdate.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagsToUpdate(Collection<Tag> tagsToUpdate) {
            this.tagsToUpdate = TagListCopier.copy(tagsToUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToUpdate(Tag... tagsToUpdate) {
            tagsToUpdate(Arrays.asList(tagsToUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToUpdate(Consumer<Tag.Builder>... tagsToUpdate) {
            tagsToUpdate(Stream.of(tagsToUpdate).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagsToUpdate(Collection<Tag.BuilderImpl> tagsToUpdate) {
            this.tagsToUpdate = TagListCopier.copyFromBuilder(tagsToUpdate);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTagsForDomainRequest build() {
            return new UpdateTagsForDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
