/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ViewBilling response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViewBillingResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<ViewBillingResponse.Builder, ViewBillingResponse> {
    private static final SdkField<String> NEXT_PAGE_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ViewBillingResponse::nextPageMarker)).setter(setter(Builder::nextPageMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageMarker").build()).build();

    private static final SdkField<List<BillingRecord>> BILLING_RECORDS_FIELD = SdkField
            .<List<BillingRecord>> builder(MarshallingType.LIST)
            .getter(getter(ViewBillingResponse::billingRecords))
            .setter(setter(Builder::billingRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BillingRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(BillingRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_PAGE_MARKER_FIELD,
            BILLING_RECORDS_FIELD));

    private final String nextPageMarker;

    private final List<BillingRecord> billingRecords;

    private ViewBillingResponse(BuilderImpl builder) {
        super(builder);
        this.nextPageMarker = builder.nextPageMarker;
        this.billingRecords = builder.billingRecords;
    }

    /**
     * <p>
     * If there are more billing records than you specified for <code>MaxItems</code> in the request, submit another
     * request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
     * </p>
     * 
     * @return If there are more billing records than you specified for <code>MaxItems</code> in the request, submit
     *         another request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
     */
    public String nextPageMarker() {
        return nextPageMarker;
    }

    /**
     * Returns true if the BillingRecords property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasBillingRecords() {
        return billingRecords != null && !(billingRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of billing records.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBillingRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A summary of billing records.
     */
    public List<BillingRecord> billingRecords() {
        return billingRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextPageMarker());
        hashCode = 31 * hashCode + Objects.hashCode(billingRecords());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewBillingResponse)) {
            return false;
        }
        ViewBillingResponse other = (ViewBillingResponse) obj;
        return Objects.equals(nextPageMarker(), other.nextPageMarker())
                && Objects.equals(billingRecords(), other.billingRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ViewBillingResponse").add("NextPageMarker", nextPageMarker())
                .add("BillingRecords", billingRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextPageMarker":
            return Optional.ofNullable(clazz.cast(nextPageMarker()));
        case "BillingRecords":
            return Optional.ofNullable(clazz.cast(billingRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ViewBillingResponse, T> g) {
        return obj -> g.apply((ViewBillingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ViewBillingResponse> {
        /**
         * <p>
         * If there are more billing records than you specified for <code>MaxItems</code> in the request, submit another
         * request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
         * </p>
         * 
         * @param nextPageMarker
         *        If there are more billing records than you specified for <code>MaxItems</code> in the request, submit
         *        another request and include the value of <code>NextPageMarker</code> in the value of
         *        <code>Marker</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageMarker(String nextPageMarker);

        /**
         * <p>
         * A summary of billing records.
         * </p>
         * 
         * @param billingRecords
         *        A summary of billing records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingRecords(Collection<BillingRecord> billingRecords);

        /**
         * <p>
         * A summary of billing records.
         * </p>
         * 
         * @param billingRecords
         *        A summary of billing records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingRecords(BillingRecord... billingRecords);

        /**
         * <p>
         * A summary of billing records.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BillingRecord>.Builder} avoiding the need
         * to create one manually via {@link List<BillingRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BillingRecord>.Builder#build()} is called immediately and
         * its result is passed to {@link #billingRecords(List<BillingRecord>)}.
         * 
         * @param billingRecords
         *        a consumer that will call methods on {@link List<BillingRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingRecords(List<BillingRecord>)
         */
        Builder billingRecords(Consumer<BillingRecord.Builder>... billingRecords);
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private String nextPageMarker;

        private List<BillingRecord> billingRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ViewBillingResponse model) {
            super(model);
            nextPageMarker(model.nextPageMarker);
            billingRecords(model.billingRecords);
        }

        public final String getNextPageMarker() {
            return nextPageMarker;
        }

        @Override
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        public final Collection<BillingRecord.Builder> getBillingRecords() {
            return billingRecords != null ? billingRecords.stream().map(BillingRecord::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder billingRecords(Collection<BillingRecord> billingRecords) {
            this.billingRecords = BillingRecordsCopier.copy(billingRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingRecords(BillingRecord... billingRecords) {
            billingRecords(Arrays.asList(billingRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingRecords(Consumer<BillingRecord.Builder>... billingRecords) {
            billingRecords(Stream.of(billingRecords).map(c -> BillingRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBillingRecords(Collection<BillingRecord.BuilderImpl> billingRecords) {
            this.billingRecords = BillingRecordsCopier.copyFromBuilder(billingRecords);
        }

        @Override
        public ViewBillingResponse build() {
            return new ViewBillingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
