/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53domains.Route53DomainsAsyncClient;
import software.amazon.awssdk.services.route53domains.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53domains.model.BillingRecord;
import software.amazon.awssdk.services.route53domains.model.ViewBillingRequest;
import software.amazon.awssdk.services.route53domains.model.ViewBillingResponse;

public class ViewBillingPublisher
implements SdkPublisher<ViewBillingResponse> {
    private final Route53DomainsAsyncClient client;
    private final ViewBillingRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ViewBillingPublisher(Route53DomainsAsyncClient client, ViewBillingRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ViewBillingPublisher(Route53DomainsAsyncClient client, ViewBillingRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ViewBillingResponseFetcher();
    }

    public void subscribe(Subscriber<? super ViewBillingResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BillingRecord> billingRecords() {
        Function<ViewBillingResponse, Iterator> getIterator = response -> {
            if (response != null && response.billingRecords() != null) {
                return response.billingRecords().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ViewBillingResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ViewBillingResponseFetcher
    implements AsyncPageFetcher<ViewBillingResponse> {
        private ViewBillingResponseFetcher() {
        }

        public boolean hasNextPage(ViewBillingResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageMarker());
        }

        public CompletableFuture<ViewBillingResponse> nextPage(ViewBillingResponse previousPage) {
            if (previousPage == null) {
                return ViewBillingPublisher.this.client.viewBilling(ViewBillingPublisher.this.firstRequest);
            }
            return ViewBillingPublisher.this.client.viewBilling((ViewBillingRequest)((Object)ViewBillingPublisher.this.firstRequest.toBuilder().marker(previousPage.nextPageMarker()).build()));
        }
    }
}

