/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime.endpoints;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.services.sagemakera2iruntime.endpoints.internal.DefaultSageMakerA2IRuntimeEndpointProvider;

/**
 * An endpoint provider for SageMakerA2IRuntime. The endpoint provider takes a set of parameters using
 * {@link SageMakerA2IRuntimeEndpointParams}, and resolves an {@link Endpoint} base on the given parameters.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface SageMakerA2IRuntimeEndpointProvider extends EndpointProvider {
    /**
     * Compute the endpoint based on the given set of parameters.
     */
    CompletableFuture<Endpoint> resolveEndpoint(SageMakerA2IRuntimeEndpointParams endpointParams);

    /**
     * Compute the endpoint based on the given set of parameters.
     */
    default CompletableFuture<Endpoint> resolveEndpoint(Consumer<SageMakerA2IRuntimeEndpointParams.Builder> endpointParamsConsumer) {
        SageMakerA2IRuntimeEndpointParams.Builder paramsBuilder = SageMakerA2IRuntimeEndpointParams.builder();
        endpointParamsConsumer.accept(paramsBuilder);
        return resolveEndpoint(paramsBuilder.build());
    }

    static SageMakerA2IRuntimeEndpointProvider defaultProvider() {
        return new DefaultSageMakerA2IRuntimeEndpointProvider();
    }
}
