/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.schemas.model.SchemasResponse;
import software.amazon.awssdk.services.schemas.model.SearchSchemaSummary;
import software.amazon.awssdk.services.schemas.model.___listOfSearchSchemaSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchSchemasResponse
extends SchemasResponse
implements ToCopyableBuilder<Builder, SearchSchemasResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchSchemasResponse.getter(SearchSchemasResponse::nextToken)).setter(SearchSchemasResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<SearchSchemaSummary>> SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Schemas").getter(SearchSchemasResponse.getter(SearchSchemasResponse::schemas)).setter(SearchSchemasResponse.setter(Builder::schemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schemas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchSchemaSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SCHEMAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchSchemasResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<SearchSchemaSummary> schemas;

    private SearchSchemasResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.schemas = builder.schemas;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSchemas() {
        return this.schemas != null && !(this.schemas instanceof SdkAutoConstructList);
    }

    public final List<SearchSchemaSummary> schemas() {
        return this.schemas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemas() ? this.schemas() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSchemasResponse)) {
            return false;
        }
        SearchSchemasResponse other = (SearchSchemasResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSchemas() == other.hasSchemas() && Objects.equals(this.schemas(), other.schemas());
    }

    public final String toString() {
        return ToString.builder((String)"SearchSchemasResponse").add("NextToken", (Object)this.nextToken()).add("Schemas", this.hasSchemas() ? this.schemas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Schemas": {
                return Optional.ofNullable(clazz.cast(this.schemas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Schemas", SCHEMAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchSchemasResponse, T> g) {
        return obj -> g.apply((SearchSchemasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SearchSchemaSummary> schemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSchemasResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.schemas(model.schemas);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SearchSchemaSummary.Builder> getSchemas() {
            List<SearchSchemaSummary.Builder> result = ___listOfSearchSchemaSummaryCopier.copyToBuilder(this.schemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemas(Collection<SearchSchemaSummary.BuilderImpl> schemas) {
            this.schemas = ___listOfSearchSchemaSummaryCopier.copyFromBuilder(schemas);
        }

        @Override
        public final Builder schemas(Collection<SearchSchemaSummary> schemas) {
            this.schemas = ___listOfSearchSchemaSummaryCopier.copy(schemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(SearchSchemaSummary ... schemas) {
            this.schemas(Arrays.asList(schemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(Consumer<SearchSchemaSummary.Builder> ... schemas) {
            this.schemas(Stream.of(schemas).map(c -> (SearchSchemaSummary)((SearchSchemaSummary.Builder)SearchSchemaSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchSchemasResponse build() {
            return new SearchSchemasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SchemasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchSchemasResponse> {
        public Builder nextToken(String var1);

        public Builder schemas(Collection<SearchSchemaSummary> var1);

        public Builder schemas(SearchSchemaSummary ... var1);

        public Builder schemas(Consumer<SearchSchemaSummary.Builder> ... var1);
    }
}

