/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsRedshiftClusterRestoreStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsRedshiftClusterRestoreStatus> {
    private static final SdkField<Double> CURRENT_RESTORE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("CurrentRestoreRateInMegaBytesPerSecond").getter(AwsRedshiftClusterRestoreStatus.getter(AwsRedshiftClusterRestoreStatus::currentRestoreRateInMegaBytesPerSecond)).setter(AwsRedshiftClusterRestoreStatus.setter(Builder::currentRestoreRateInMegaBytesPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentRestoreRateInMegaBytesPerSecond").build()}).build();
    private static final SdkField<Long> ELAPSED_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ElapsedTimeInSeconds").getter(AwsRedshiftClusterRestoreStatus.getter(AwsRedshiftClusterRestoreStatus::elapsedTimeInSeconds)).setter(AwsRedshiftClusterRestoreStatus.setter(Builder::elapsedTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeInSeconds").build()}).build();
    private static final SdkField<Long> ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedTimeToCompletionInSeconds").getter(AwsRedshiftClusterRestoreStatus.getter(AwsRedshiftClusterRestoreStatus::estimatedTimeToCompletionInSeconds)).setter(AwsRedshiftClusterRestoreStatus.setter(Builder::estimatedTimeToCompletionInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeToCompletionInSeconds").build()}).build();
    private static final SdkField<Long> PROGRESS_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ProgressInMegaBytes").getter(AwsRedshiftClusterRestoreStatus.getter(AwsRedshiftClusterRestoreStatus::progressInMegaBytes)).setter(AwsRedshiftClusterRestoreStatus.setter(Builder::progressInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressInMegaBytes").build()}).build();
    private static final SdkField<Long> SNAPSHOT_SIZE_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SnapshotSizeInMegaBytes").getter(AwsRedshiftClusterRestoreStatus.getter(AwsRedshiftClusterRestoreStatus::snapshotSizeInMegaBytes)).setter(AwsRedshiftClusterRestoreStatus.setter(Builder::snapshotSizeInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSizeInMegaBytes").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AwsRedshiftClusterRestoreStatus.getter(AwsRedshiftClusterRestoreStatus::status)).setter(AwsRedshiftClusterRestoreStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_RESTORE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD, ELAPSED_TIME_IN_SECONDS_FIELD, ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD, PROGRESS_IN_MEGA_BYTES_FIELD, SNAPSHOT_SIZE_IN_MEGA_BYTES_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double currentRestoreRateInMegaBytesPerSecond;
    private final Long elapsedTimeInSeconds;
    private final Long estimatedTimeToCompletionInSeconds;
    private final Long progressInMegaBytes;
    private final Long snapshotSizeInMegaBytes;
    private final String status;

    private AwsRedshiftClusterRestoreStatus(BuilderImpl builder) {
        this.currentRestoreRateInMegaBytesPerSecond = builder.currentRestoreRateInMegaBytesPerSecond;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.estimatedTimeToCompletionInSeconds = builder.estimatedTimeToCompletionInSeconds;
        this.progressInMegaBytes = builder.progressInMegaBytes;
        this.snapshotSizeInMegaBytes = builder.snapshotSizeInMegaBytes;
        this.status = builder.status;
    }

    public final Double currentRestoreRateInMegaBytesPerSecond() {
        return this.currentRestoreRateInMegaBytesPerSecond;
    }

    public final Long elapsedTimeInSeconds() {
        return this.elapsedTimeInSeconds;
    }

    public final Long estimatedTimeToCompletionInSeconds() {
        return this.estimatedTimeToCompletionInSeconds;
    }

    public final Long progressInMegaBytes() {
        return this.progressInMegaBytes;
    }

    public final Long snapshotSizeInMegaBytes() {
        return this.snapshotSizeInMegaBytes;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRestoreRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.elapsedTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTimeToCompletionInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRedshiftClusterRestoreStatus)) {
            return false;
        }
        AwsRedshiftClusterRestoreStatus other = (AwsRedshiftClusterRestoreStatus)obj;
        return Objects.equals(this.currentRestoreRateInMegaBytesPerSecond(), other.currentRestoreRateInMegaBytesPerSecond()) && Objects.equals(this.elapsedTimeInSeconds(), other.elapsedTimeInSeconds()) && Objects.equals(this.estimatedTimeToCompletionInSeconds(), other.estimatedTimeToCompletionInSeconds()) && Objects.equals(this.progressInMegaBytes(), other.progressInMegaBytes()) && Objects.equals(this.snapshotSizeInMegaBytes(), other.snapshotSizeInMegaBytes()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"AwsRedshiftClusterRestoreStatus").add("CurrentRestoreRateInMegaBytesPerSecond", (Object)this.currentRestoreRateInMegaBytesPerSecond()).add("ElapsedTimeInSeconds", (Object)this.elapsedTimeInSeconds()).add("EstimatedTimeToCompletionInSeconds", (Object)this.estimatedTimeToCompletionInSeconds()).add("ProgressInMegaBytes", (Object)this.progressInMegaBytes()).add("SnapshotSizeInMegaBytes", (Object)this.snapshotSizeInMegaBytes()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrentRestoreRateInMegaBytesPerSecond": {
                return Optional.ofNullable(clazz.cast(this.currentRestoreRateInMegaBytesPerSecond()));
            }
            case "ElapsedTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.elapsedTimeInSeconds()));
            }
            case "EstimatedTimeToCompletionInSeconds": {
                return Optional.ofNullable(clazz.cast(this.estimatedTimeToCompletionInSeconds()));
            }
            case "ProgressInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.progressInMegaBytes()));
            }
            case "SnapshotSizeInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.snapshotSizeInMegaBytes()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRedshiftClusterRestoreStatus, T> g) {
        return obj -> g.apply((AwsRedshiftClusterRestoreStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double currentRestoreRateInMegaBytesPerSecond;
        private Long elapsedTimeInSeconds;
        private Long estimatedTimeToCompletionInSeconds;
        private Long progressInMegaBytes;
        private Long snapshotSizeInMegaBytes;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRedshiftClusterRestoreStatus model) {
            this.currentRestoreRateInMegaBytesPerSecond(model.currentRestoreRateInMegaBytesPerSecond);
            this.elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            this.estimatedTimeToCompletionInSeconds(model.estimatedTimeToCompletionInSeconds);
            this.progressInMegaBytes(model.progressInMegaBytes);
            this.snapshotSizeInMegaBytes(model.snapshotSizeInMegaBytes);
            this.status(model.status);
        }

        public final Double getCurrentRestoreRateInMegaBytesPerSecond() {
            return this.currentRestoreRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder currentRestoreRateInMegaBytesPerSecond(Double currentRestoreRateInMegaBytesPerSecond) {
            this.currentRestoreRateInMegaBytesPerSecond = currentRestoreRateInMegaBytesPerSecond;
            return this;
        }

        public final void setCurrentRestoreRateInMegaBytesPerSecond(Double currentRestoreRateInMegaBytesPerSecond) {
            this.currentRestoreRateInMegaBytesPerSecond = currentRestoreRateInMegaBytesPerSecond;
        }

        public final Long getElapsedTimeInSeconds() {
            return this.elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        public final Long getEstimatedTimeToCompletionInSeconds() {
            return this.estimatedTimeToCompletionInSeconds;
        }

        @Override
        public final Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
            return this;
        }

        public final void setEstimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
        }

        public final Long getProgressInMegaBytes() {
            return this.progressInMegaBytes;
        }

        @Override
        public final Builder progressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
            return this;
        }

        public final void setProgressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
        }

        public final Long getSnapshotSizeInMegaBytes() {
            return this.snapshotSizeInMegaBytes;
        }

        @Override
        public final Builder snapshotSizeInMegaBytes(Long snapshotSizeInMegaBytes) {
            this.snapshotSizeInMegaBytes = snapshotSizeInMegaBytes;
            return this;
        }

        public final void setSnapshotSizeInMegaBytes(Long snapshotSizeInMegaBytes) {
            this.snapshotSizeInMegaBytes = snapshotSizeInMegaBytes;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public AwsRedshiftClusterRestoreStatus build() {
            return new AwsRedshiftClusterRestoreStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsRedshiftClusterRestoreStatus> {
        public Builder currentRestoreRateInMegaBytesPerSecond(Double var1);

        public Builder elapsedTimeInSeconds(Long var1);

        public Builder estimatedTimeToCompletionInSeconds(Long var1);

        public Builder progressInMegaBytes(Long var1);

        public Builder snapshotSizeInMegaBytes(Long var1);

        public Builder status(String var1);
    }
}

