/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.ConfigurationPolicySummary;
import software.amazon.awssdk.services.securityhub.model.ListConfigurationPoliciesRequest;
import software.amazon.awssdk.services.securityhub.model.ListConfigurationPoliciesResponse;

public class ListConfigurationPoliciesPublisher
implements SdkPublisher<ListConfigurationPoliciesResponse> {
    private final SecurityHubAsyncClient client;
    private final ListConfigurationPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfigurationPoliciesPublisher(SecurityHubAsyncClient client, ListConfigurationPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfigurationPoliciesPublisher(SecurityHubAsyncClient client, ListConfigurationPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfigurationPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfigurationPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfigurationPolicySummary> configurationPolicySummaries() {
        Function<ListConfigurationPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationPolicySummaries() != null) {
                return response.configurationPolicySummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConfigurationPoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConfigurationPoliciesResponseFetcher
    implements AsyncPageFetcher<ListConfigurationPoliciesResponse> {
        private ListConfigurationPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfigurationPoliciesResponse> nextPage(ListConfigurationPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationPoliciesPublisher.this.client.listConfigurationPolicies(ListConfigurationPoliciesPublisher.this.firstRequest);
            }
            return ListConfigurationPoliciesPublisher.this.client.listConfigurationPolicies((ListConfigurationPoliciesRequest)((Object)ListConfigurationPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

