/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityir.model.SecurityIrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCaseCommentRequest
extends SecurityIrRequest
implements ToCopyableBuilder<Builder, CreateCaseCommentRequest> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caseId").getter(CreateCaseCommentRequest.getter(CreateCaseCommentRequest::caseId)).setter(CreateCaseCommentRequest.setter(Builder::caseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("caseId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateCaseCommentRequest.getter(CreateCaseCommentRequest::clientToken)).setter(CreateCaseCommentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("body").getter(CreateCaseCommentRequest.getter(CreateCaseCommentRequest::body)).setter(CreateCaseCommentRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD, CLIENT_TOKEN_FIELD, BODY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCaseCommentRequest.memberNameToFieldInitializer();
    private final String caseId;
    private final String clientToken;
    private final String body;

    private CreateCaseCommentRequest(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.clientToken = builder.clientToken;
        this.body = builder.body;
    }

    public final String caseId() {
        return this.caseId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String body() {
        return this.body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.caseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCaseCommentRequest)) {
            return false;
        }
        CreateCaseCommentRequest other = (CreateCaseCommentRequest)((Object)obj);
        return Objects.equals(this.caseId(), other.caseId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.body(), other.body());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCaseCommentRequest").add("CaseId", (Object)this.caseId()).add("ClientToken", (Object)this.clientToken()).add("Body", (Object)(this.body() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseId": {
                return Optional.ofNullable(clazz.cast(this.caseId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("caseId", CASE_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("body", BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCaseCommentRequest, T> g) {
        return obj -> g.apply((CreateCaseCommentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrRequest.BuilderImpl
    implements Builder {
        private String caseId;
        private String clientToken;
        private String body;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCaseCommentRequest model) {
            super(model);
            this.caseId(model.caseId);
            this.clientToken(model.clientToken);
            this.body(model.body);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCaseCommentRequest build() {
            return new CreateCaseCommentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityIrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCaseCommentRequest> {
        public Builder caseId(String var1);

        public Builder clientToken(String var1);

        public Builder body(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

