/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.DedicatedIp;
import software.amazon.awssdk.services.sesv2.model.DedicatedIpListCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDedicatedIpsResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, GetDedicatedIpsResponse> {
    private static final SdkField<List<DedicatedIp>> DEDICATED_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DedicatedIps").getter(GetDedicatedIpsResponse.getter(GetDedicatedIpsResponse::dedicatedIps)).setter(GetDedicatedIpsResponse.setter(Builder::dedicatedIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DedicatedIp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetDedicatedIpsResponse.getter(GetDedicatedIpsResponse::nextToken)).setter(GetDedicatedIpsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEDICATED_IPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DedicatedIp> dedicatedIps;
    private final String nextToken;

    private GetDedicatedIpsResponse(BuilderImpl builder) {
        super(builder);
        this.dedicatedIps = builder.dedicatedIps;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDedicatedIps() {
        return this.dedicatedIps != null && !(this.dedicatedIps instanceof SdkAutoConstructList);
    }

    public final List<DedicatedIp> dedicatedIps() {
        return this.dedicatedIps;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDedicatedIps() ? this.dedicatedIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDedicatedIpsResponse)) {
            return false;
        }
        GetDedicatedIpsResponse other = (GetDedicatedIpsResponse)((Object)obj);
        return this.hasDedicatedIps() == other.hasDedicatedIps() && Objects.equals(this.dedicatedIps(), other.dedicatedIps()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDedicatedIpsResponse").add("DedicatedIps", this.hasDedicatedIps() ? this.dedicatedIps() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DedicatedIps": {
                return Optional.ofNullable(clazz.cast(this.dedicatedIps()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDedicatedIpsResponse, T> g) {
        return obj -> g.apply((GetDedicatedIpsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private List<DedicatedIp> dedicatedIps = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDedicatedIpsResponse model) {
            super(model);
            this.dedicatedIps(model.dedicatedIps);
            this.nextToken(model.nextToken);
        }

        public final List<DedicatedIp.Builder> getDedicatedIps() {
            List<DedicatedIp.Builder> result = DedicatedIpListCopier.copyToBuilder(this.dedicatedIps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDedicatedIps(Collection<DedicatedIp.BuilderImpl> dedicatedIps) {
            this.dedicatedIps = DedicatedIpListCopier.copyFromBuilder(dedicatedIps);
        }

        @Override
        @Transient
        public final Builder dedicatedIps(Collection<DedicatedIp> dedicatedIps) {
            this.dedicatedIps = DedicatedIpListCopier.copy(dedicatedIps);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dedicatedIps(DedicatedIp ... dedicatedIps) {
            this.dedicatedIps(Arrays.asList(dedicatedIps));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dedicatedIps(Consumer<DedicatedIp.Builder> ... dedicatedIps) {
            this.dedicatedIps(Stream.of(dedicatedIps).map(c -> (DedicatedIp)((DedicatedIp.Builder)DedicatedIp.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetDedicatedIpsResponse build() {
            return new GetDedicatedIpsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDedicatedIpsResponse> {
        public Builder dedicatedIps(Collection<DedicatedIp> var1);

        public Builder dedicatedIps(DedicatedIp ... var1);

        public Builder dedicatedIps(Consumer<DedicatedIp.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

