/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SoftwareInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SoftwareInformation> {
    private static final SdkField<String> INSTALL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("installState").getter(SoftwareInformation.getter(SoftwareInformation::installState)).setter(SoftwareInformation.setter(Builder::installState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("installState").build()}).build();
    private static final SdkField<String> INSTALLED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("installedVersion").getter(SoftwareInformation.getter(SoftwareInformation::installedVersion)).setter(SoftwareInformation.setter(Builder::installedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("installedVersion").build()}).build();
    private static final SdkField<String> INSTALLING_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("installingVersion").getter(SoftwareInformation.getter(SoftwareInformation::installingVersion)).setter(SoftwareInformation.setter(Builder::installingVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("installingVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTALL_STATE_FIELD, INSTALLED_VERSION_FIELD, INSTALLING_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SoftwareInformation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String installState;
    private final String installedVersion;
    private final String installingVersion;

    private SoftwareInformation(BuilderImpl builder) {
        this.installState = builder.installState;
        this.installedVersion = builder.installedVersion;
        this.installingVersion = builder.installingVersion;
    }

    public final String installState() {
        return this.installState;
    }

    public final String installedVersion() {
        return this.installedVersion;
    }

    public final String installingVersion() {
        return this.installingVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.installState());
        hashCode = 31 * hashCode + Objects.hashCode(this.installedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.installingVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwareInformation)) {
            return false;
        }
        SoftwareInformation other = (SoftwareInformation)obj;
        return Objects.equals(this.installState(), other.installState()) && Objects.equals(this.installedVersion(), other.installedVersion()) && Objects.equals(this.installingVersion(), other.installingVersion());
    }

    public final String toString() {
        return ToString.builder((String)"SoftwareInformation").add("InstallState", (Object)this.installState()).add("InstalledVersion", (Object)this.installedVersion()).add("InstallingVersion", (Object)this.installingVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "installState": {
                return Optional.ofNullable(clazz.cast(this.installState()));
            }
            case "installedVersion": {
                return Optional.ofNullable(clazz.cast(this.installedVersion()));
            }
            case "installingVersion": {
                return Optional.ofNullable(clazz.cast(this.installingVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("installState", INSTALL_STATE_FIELD);
        map.put("installedVersion", INSTALLED_VERSION_FIELD);
        map.put("installingVersion", INSTALLING_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SoftwareInformation, T> g) {
        return obj -> g.apply((SoftwareInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String installState;
        private String installedVersion;
        private String installingVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwareInformation model) {
            this.installState(model.installState);
            this.installedVersion(model.installedVersion);
            this.installingVersion(model.installingVersion);
        }

        public final String getInstallState() {
            return this.installState;
        }

        public final void setInstallState(String installState) {
            this.installState = installState;
        }

        @Override
        public final Builder installState(String installState) {
            this.installState = installState;
            return this;
        }

        public final String getInstalledVersion() {
            return this.installedVersion;
        }

        public final void setInstalledVersion(String installedVersion) {
            this.installedVersion = installedVersion;
        }

        @Override
        public final Builder installedVersion(String installedVersion) {
            this.installedVersion = installedVersion;
            return this;
        }

        public final String getInstallingVersion() {
            return this.installingVersion;
        }

        public final void setInstallingVersion(String installingVersion) {
            this.installingVersion = installingVersion;
        }

        @Override
        public final Builder installingVersion(String installingVersion) {
            this.installingVersion = installingVersion;
            return this;
        }

        public SoftwareInformation build() {
            return new SoftwareInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SoftwareInformation> {
        public Builder installState(String var1);

        public Builder installedVersion(String var1);

        public Builder installingVersion(String var1);
    }
}

