/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sqs.model.QueueUrlListCopier;
import software.amazon.awssdk.services.sqs.model.SqsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueuesResponse
extends SqsResponse
implements ToCopyableBuilder<Builder, ListQueuesResponse> {
    private static final SdkField<List<String>> QUEUE_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueueUrls").getter(ListQueuesResponse.getter(ListQueuesResponse::queueUrls)).setter(ListQueuesResponse.setter(Builder::queueUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListQueuesResponse.getter(ListQueuesResponse::nextToken)).setter(ListQueuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_URLS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListQueuesResponse.memberNameToFieldInitializer();
    private final List<String> queueUrls;
    private final String nextToken;

    private ListQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.queueUrls = builder.queueUrls;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasQueueUrls() {
        return this.queueUrls != null && !(this.queueUrls instanceof SdkAutoConstructList);
    }

    public final List<String> queueUrls() {
        return this.queueUrls;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueueUrls() ? this.queueUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesResponse)) {
            return false;
        }
        ListQueuesResponse other = (ListQueuesResponse)((Object)obj);
        return this.hasQueueUrls() == other.hasQueueUrls() && Objects.equals(this.queueUrls(), other.queueUrls()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListQueuesResponse").add("QueueUrls", this.hasQueueUrls() ? this.queueUrls() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrls": {
                return Optional.ofNullable(clazz.cast(this.queueUrls()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QueueUrls", QUEUE_URLS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQueuesResponse, T> g) {
        return obj -> g.apply((ListQueuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SqsResponse.BuilderImpl
    implements Builder {
        private List<String> queueUrls = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesResponse model) {
            super(model);
            this.queueUrls(model.queueUrls);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getQueueUrls() {
            if (this.queueUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queueUrls;
        }

        public final void setQueueUrls(Collection<String> queueUrls) {
            this.queueUrls = QueueUrlListCopier.copy(queueUrls);
        }

        @Override
        public final Builder queueUrls(Collection<String> queueUrls) {
            this.queueUrls = QueueUrlListCopier.copy(queueUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueUrls(String ... queueUrls) {
            this.queueUrls(Arrays.asList(queueUrls));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListQueuesResponse build() {
            return new ListQueuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SqsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueuesResponse> {
        public Builder queueUrls(Collection<String> var1);

        public Builder queueUrls(String ... var1);

        public Builder nextToken(String var1);
    }
}

