/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

@SdkInternalApi
public final class RequestPayloadCalculator {
    private RequestPayloadCalculator() {
    }

    public static <RequestT> Optional<Integer> calculateMessageSize(RequestT request) {
        if (!(request instanceof SendMessageRequest)) {
            return Optional.empty();
        }
        SendMessageRequest sendMessageRequest = (SendMessageRequest)((Object)request);
        Integer totalSize = RequestPayloadCalculator.calculateBodySize(sendMessageRequest) + 16384;
        return Optional.of(totalSize);
    }

    private static int calculateBodySize(SendMessageRequest request) {
        return request.messageBody() != null ? request.messageBody().getBytes(StandardCharsets.UTF_8).length : 0;
    }
}

