/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.internal.batchmanager.ReceiveBatchManager;
import software.amazon.awssdk.services.sqs.internal.batchmanager.ResponseBatchConfiguration;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
public class ReceiveMessageBatchManager
implements SdkAutoCloseable {
    private static final Logger log = Logger.loggerFor(ReceiveMessageBatchManager.class);
    private final SqsAsyncClient sqsClient;
    private final ScheduledExecutorService executor;
    private final ResponseBatchConfiguration config;
    private final Map<String, ReceiveBatchManager> receiveBatchManagerMap = new ConcurrentHashMap<String, ReceiveBatchManager>();

    public ReceiveMessageBatchManager(SqsAsyncClient sqsClient, ScheduledExecutorService executor, ResponseBatchConfiguration config) {
        this.sqsClient = sqsClient;
        this.executor = executor;
        this.config = config;
    }

    public CompletableFuture<ReceiveMessageResponse> batchRequest(ReceiveMessageRequest request) {
        String ineligibleReason = this.checkBatchingEligibility(request);
        if (ineligibleReason == null) {
            return this.receiveBatchManagerMap.computeIfAbsent(this.generateBatchKey(request), key -> this.createReceiveBatchManager(request)).processRequest(request);
        }
        log.debug(() -> String.format("Batching skipped. Reason: %s", ineligibleReason));
        return this.sqsClient.receiveMessage(request);
    }

    private String generateBatchKey(ReceiveMessageRequest request) {
        return request.overrideConfiguration().map(config -> request.queueUrl() + config.hashCode()).orElse(request.queueUrl());
    }

    private ReceiveBatchManager createReceiveBatchManager(ReceiveMessageRequest request) {
        return new ReceiveBatchManager(this.sqsClient, this.executor, this.config, request.queueUrl());
    }

    public void close() {
        this.receiveBatchManagerMap.values().forEach(ReceiveBatchManager::close);
    }

    private String checkBatchingEligibility(ReceiveMessageRequest rq) {
        if (!this.hasCompatibleAttributes(rq)) {
            return "Incompatible attributes.";
        }
        if (rq.visibilityTimeout() != null) {
            return "Visibility timeout is set.";
        }
        if (!this.isBufferingEnabled()) {
            return "Buffering is disabled.";
        }
        if (rq.overrideConfiguration().isPresent()) {
            return "Request has override configurations.";
        }
        return null;
    }

    private boolean hasCompatibleAttributes(ReceiveMessageRequest rq) {
        return !rq.hasAttributeNames() && this.hasCompatibleSystemAttributes(rq) && this.hasCompatibleMessageAttributes(rq);
    }

    private boolean hasCompatibleSystemAttributes(ReceiveMessageRequest rq) {
        return !rq.hasMessageSystemAttributeNames() || this.config.messageSystemAttributeNames().equals(rq.messageSystemAttributeNames());
    }

    private boolean hasCompatibleMessageAttributes(ReceiveMessageRequest rq) {
        return !rq.hasMessageAttributeNames() || this.config.receiveMessageAttributeNames().equals(rq.messageAttributeNames());
    }

    private boolean isBufferingEnabled() {
        return this.config.maxInflightReceiveBatches() > 0 && this.config.maxDoneReceiveBatches() > 0;
    }
}

