/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmincidents.model.IntegerListCopier;
import software.amazon.awssdk.services.ssmincidents.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeValueList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeValueList> {
    private static final SdkField<List<Integer>> INTEGER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("integerValues").getter(AttributeValueList.getter(AttributeValueList::integerValues)).setter(AttributeValueList.setter(Builder::integerValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stringValues").getter(AttributeValueList.getter(AttributeValueList::stringValues)).setter(AttributeValueList.setter(Builder::stringValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_VALUES_FIELD, STRING_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttributeValueList.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Integer> integerValues;
    private final List<String> stringValues;
    private final Type type;

    private AttributeValueList(BuilderImpl builder) {
        this.integerValues = builder.integerValues;
        this.stringValues = builder.stringValues;
        this.type = builder.type;
    }

    public final boolean hasIntegerValues() {
        return this.integerValues != null && !(this.integerValues instanceof SdkAutoConstructList);
    }

    public final List<Integer> integerValues() {
        return this.integerValues;
    }

    public final boolean hasStringValues() {
        return this.stringValues != null && !(this.stringValues instanceof SdkAutoConstructList);
    }

    public final List<String> stringValues() {
        return this.stringValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegerValues() ? this.integerValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringValues() ? this.stringValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValueList)) {
            return false;
        }
        AttributeValueList other = (AttributeValueList)obj;
        return this.hasIntegerValues() == other.hasIntegerValues() && Objects.equals(this.integerValues(), other.integerValues()) && this.hasStringValues() == other.hasStringValues() && Objects.equals(this.stringValues(), other.stringValues());
    }

    public final String toString() {
        return ToString.builder((String)"AttributeValueList").add("IntegerValues", this.hasIntegerValues() ? this.integerValues() : null).add("StringValues", this.hasStringValues() ? this.stringValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "integerValues": {
                return Optional.ofNullable(clazz.cast(this.integerValues()));
            }
            case "stringValues": {
                return Optional.ofNullable(clazz.cast(this.stringValues()));
            }
        }
        return Optional.empty();
    }

    public static AttributeValueList fromIntegerValues(List<Integer> integerValues) {
        return (AttributeValueList)AttributeValueList.builder().integerValues(integerValues).build();
    }

    public static AttributeValueList fromStringValues(List<String> stringValues) {
        return (AttributeValueList)AttributeValueList.builder().stringValues(stringValues).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("integerValues", INTEGER_VALUES_FIELD);
        map.put("stringValues", STRING_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeValueList, T> g) {
        return obj -> g.apply((AttributeValueList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INTEGER_VALUES,
        STRING_VALUES,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<Integer> integerValues = DefaultSdkAutoConstructList.getInstance();
        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValueList model) {
            this.integerValues(model.integerValues);
            this.stringValues(model.stringValues);
        }

        public final Collection<Integer> getIntegerValues() {
            if (this.integerValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.integerValues;
        }

        public final void setIntegerValues(Collection<Integer> integerValues) {
            List<Integer> oldValue = this.integerValues;
            this.integerValues = IntegerListCopier.copy(integerValues);
            this.handleUnionValueChange(Type.INTEGER_VALUES, oldValue, this.integerValues);
        }

        @Override
        public final Builder integerValues(Collection<Integer> integerValues) {
            List<Integer> oldValue = this.integerValues;
            this.integerValues = IntegerListCopier.copy(integerValues);
            this.handleUnionValueChange(Type.INTEGER_VALUES, oldValue, this.integerValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerValues(Integer ... integerValues) {
            this.integerValues(Arrays.asList(integerValues));
            return this;
        }

        public final Collection<String> getStringValues() {
            if (this.stringValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stringValues;
        }

        public final void setStringValues(Collection<String> stringValues) {
            List<String> oldValue = this.stringValues;
            this.stringValues = StringListCopier.copy(stringValues);
            this.handleUnionValueChange(Type.STRING_VALUES, oldValue, this.stringValues);
        }

        @Override
        public final Builder stringValues(Collection<String> stringValues) {
            List<String> oldValue = this.stringValues;
            this.stringValues = StringListCopier.copy(stringValues);
            this.handleUnionValueChange(Type.STRING_VALUES, oldValue, this.stringValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValues(String ... stringValues) {
            this.stringValues(Arrays.asList(stringValues));
            return this;
        }

        public AttributeValueList build() {
            return new AttributeValueList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeValueList> {
        public Builder integerValues(Collection<Integer> var1);

        public Builder integerValues(Integer ... var1);

        public Builder stringValues(Collection<String> var1);

        public Builder stringValues(String ... var1);
    }
}

