/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.PoolStatus;
import software.amazon.awssdk.services.storagegateway.model.RetentionLockType;
import software.amazon.awssdk.services.storagegateway.model.TapeStorageClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PoolInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PoolInfo> {
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolARN").getter(PoolInfo.getter(PoolInfo::poolARN)).setter(PoolInfo.setter(Builder::poolARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolARN").build()}).build();
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolName").getter(PoolInfo.getter(PoolInfo::poolName)).setter(PoolInfo.setter(Builder::poolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()}).build();
    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageClass").getter(PoolInfo.getter(PoolInfo::storageClassAsString)).setter(PoolInfo.setter(Builder::storageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").build()}).build();
    private static final SdkField<String> RETENTION_LOCK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetentionLockType").getter(PoolInfo.getter(PoolInfo::retentionLockTypeAsString)).setter(PoolInfo.setter(Builder::retentionLockType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionLockType").build()}).build();
    private static final SdkField<Integer> RETENTION_LOCK_TIME_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetentionLockTimeInDays").getter(PoolInfo.getter(PoolInfo::retentionLockTimeInDays)).setter(PoolInfo.setter(Builder::retentionLockTimeInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionLockTimeInDays").build()}).build();
    private static final SdkField<String> POOL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolStatus").getter(PoolInfo.getter(PoolInfo::poolStatusAsString)).setter(PoolInfo.setter(Builder::poolStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ARN_FIELD, POOL_NAME_FIELD, STORAGE_CLASS_FIELD, RETENTION_LOCK_TYPE_FIELD, RETENTION_LOCK_TIME_IN_DAYS_FIELD, POOL_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PoolInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String poolARN;
    private final String poolName;
    private final String storageClass;
    private final String retentionLockType;
    private final Integer retentionLockTimeInDays;
    private final String poolStatus;

    private PoolInfo(BuilderImpl builder) {
        this.poolARN = builder.poolARN;
        this.poolName = builder.poolName;
        this.storageClass = builder.storageClass;
        this.retentionLockType = builder.retentionLockType;
        this.retentionLockTimeInDays = builder.retentionLockTimeInDays;
        this.poolStatus = builder.poolStatus;
    }

    public final String poolARN() {
        return this.poolARN;
    }

    public final String poolName() {
        return this.poolName;
    }

    public final TapeStorageClass storageClass() {
        return TapeStorageClass.fromValue(this.storageClass);
    }

    public final String storageClassAsString() {
        return this.storageClass;
    }

    public final RetentionLockType retentionLockType() {
        return RetentionLockType.fromValue(this.retentionLockType);
    }

    public final String retentionLockTypeAsString() {
        return this.retentionLockType;
    }

    public final Integer retentionLockTimeInDays() {
        return this.retentionLockTimeInDays;
    }

    public final PoolStatus poolStatus() {
        return PoolStatus.fromValue(this.poolStatus);
    }

    public final String poolStatusAsString() {
        return this.poolStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.poolARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolName());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionLockTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionLockTimeInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PoolInfo)) {
            return false;
        }
        PoolInfo other = (PoolInfo)obj;
        return Objects.equals(this.poolARN(), other.poolARN()) && Objects.equals(this.poolName(), other.poolName()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString()) && Objects.equals(this.retentionLockTypeAsString(), other.retentionLockTypeAsString()) && Objects.equals(this.retentionLockTimeInDays(), other.retentionLockTimeInDays()) && Objects.equals(this.poolStatusAsString(), other.poolStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PoolInfo").add("PoolARN", (Object)this.poolARN()).add("PoolName", (Object)this.poolName()).add("StorageClass", (Object)this.storageClassAsString()).add("RetentionLockType", (Object)this.retentionLockTypeAsString()).add("RetentionLockTimeInDays", (Object)this.retentionLockTimeInDays()).add("PoolStatus", (Object)this.poolStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolARN": {
                return Optional.ofNullable(clazz.cast(this.poolARN()));
            }
            case "PoolName": {
                return Optional.ofNullable(clazz.cast(this.poolName()));
            }
            case "StorageClass": {
                return Optional.ofNullable(clazz.cast(this.storageClassAsString()));
            }
            case "RetentionLockType": {
                return Optional.ofNullable(clazz.cast(this.retentionLockTypeAsString()));
            }
            case "RetentionLockTimeInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionLockTimeInDays()));
            }
            case "PoolStatus": {
                return Optional.ofNullable(clazz.cast(this.poolStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PoolARN", POOL_ARN_FIELD);
        map.put("PoolName", POOL_NAME_FIELD);
        map.put("StorageClass", STORAGE_CLASS_FIELD);
        map.put("RetentionLockType", RETENTION_LOCK_TYPE_FIELD);
        map.put("RetentionLockTimeInDays", RETENTION_LOCK_TIME_IN_DAYS_FIELD);
        map.put("PoolStatus", POOL_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PoolInfo, T> g) {
        return obj -> g.apply((PoolInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String poolARN;
        private String poolName;
        private String storageClass;
        private String retentionLockType;
        private Integer retentionLockTimeInDays;
        private String poolStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PoolInfo model) {
            this.poolARN(model.poolARN);
            this.poolName(model.poolName);
            this.storageClass(model.storageClass);
            this.retentionLockType(model.retentionLockType);
            this.retentionLockTimeInDays(model.retentionLockTimeInDays);
            this.poolStatus(model.poolStatus);
        }

        public final String getPoolARN() {
            return this.poolARN;
        }

        public final void setPoolARN(String poolARN) {
            this.poolARN = poolARN;
        }

        @Override
        public final Builder poolARN(String poolARN) {
            this.poolARN = poolARN;
            return this;
        }

        public final String getPoolName() {
            return this.poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(TapeStorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        public final String getRetentionLockType() {
            return this.retentionLockType;
        }

        public final void setRetentionLockType(String retentionLockType) {
            this.retentionLockType = retentionLockType;
        }

        @Override
        public final Builder retentionLockType(String retentionLockType) {
            this.retentionLockType = retentionLockType;
            return this;
        }

        @Override
        public final Builder retentionLockType(RetentionLockType retentionLockType) {
            this.retentionLockType(retentionLockType == null ? null : retentionLockType.toString());
            return this;
        }

        public final Integer getRetentionLockTimeInDays() {
            return this.retentionLockTimeInDays;
        }

        public final void setRetentionLockTimeInDays(Integer retentionLockTimeInDays) {
            this.retentionLockTimeInDays = retentionLockTimeInDays;
        }

        @Override
        public final Builder retentionLockTimeInDays(Integer retentionLockTimeInDays) {
            this.retentionLockTimeInDays = retentionLockTimeInDays;
            return this;
        }

        public final String getPoolStatus() {
            return this.poolStatus;
        }

        public final void setPoolStatus(String poolStatus) {
            this.poolStatus = poolStatus;
        }

        @Override
        public final Builder poolStatus(String poolStatus) {
            this.poolStatus = poolStatus;
            return this;
        }

        @Override
        public final Builder poolStatus(PoolStatus poolStatus) {
            this.poolStatus(poolStatus == null ? null : poolStatus.toString());
            return this;
        }

        public PoolInfo build() {
            return new PoolInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PoolInfo> {
        public Builder poolARN(String var1);

        public Builder poolName(String var1);

        public Builder storageClass(String var1);

        public Builder storageClass(TapeStorageClass var1);

        public Builder retentionLockType(String var1);

        public Builder retentionLockType(RetentionLockType var1);

        public Builder retentionLockTimeInDays(Integer var1);

        public Builder poolStatus(String var1);

        public Builder poolStatus(PoolStatus var1);
    }
}

