/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignalWorkflowExecutionRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, SignalWorkflowExecutionRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(SignalWorkflowExecutionRequest.getter(SignalWorkflowExecutionRequest::domain)).setter(SignalWorkflowExecutionRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(SignalWorkflowExecutionRequest.getter(SignalWorkflowExecutionRequest::workflowId)).setter(SignalWorkflowExecutionRequest.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runId").getter(SignalWorkflowExecutionRequest.getter(SignalWorkflowExecutionRequest::runId)).setter(SignalWorkflowExecutionRequest.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()}).build();
    private static final SdkField<String> SIGNAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signalName").getter(SignalWorkflowExecutionRequest.getter(SignalWorkflowExecutionRequest::signalName)).setter(SignalWorkflowExecutionRequest.setter(Builder::signalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalName").build()}).build();
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("input").getter(SignalWorkflowExecutionRequest.getter(SignalWorkflowExecutionRequest::input)).setter(SignalWorkflowExecutionRequest.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, WORKFLOW_ID_FIELD, RUN_ID_FIELD, SIGNAL_NAME_FIELD, INPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SignalWorkflowExecutionRequest.memberNameToFieldInitializer();
    private final String domain;
    private final String workflowId;
    private final String runId;
    private final String signalName;
    private final String input;

    private SignalWorkflowExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.workflowId = builder.workflowId;
        this.runId = builder.runId;
        this.signalName = builder.signalName;
        this.input = builder.input;
    }

    public final String domain() {
        return this.domain;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final String runId() {
        return this.runId;
    }

    public final String signalName() {
        return this.signalName;
    }

    public final String input() {
        return this.input;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalWorkflowExecutionRequest)) {
            return false;
        }
        SignalWorkflowExecutionRequest other = (SignalWorkflowExecutionRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.signalName(), other.signalName()) && Objects.equals(this.input(), other.input());
    }

    public final String toString() {
        return ToString.builder((String)"SignalWorkflowExecutionRequest").add("Domain", (Object)this.domain()).add("WorkflowId", (Object)this.workflowId()).add("RunId", (Object)this.runId()).add("SignalName", (Object)this.signalName()).add("Input", (Object)this.input()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "runId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "signalName": {
                return Optional.ofNullable(clazz.cast(this.signalName()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("domain", DOMAIN_FIELD);
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("runId", RUN_ID_FIELD);
        map.put("signalName", SIGNAL_NAME_FIELD);
        map.put("input", INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignalWorkflowExecutionRequest, T> g) {
        return obj -> g.apply((SignalWorkflowExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String workflowId;
        private String runId;
        private String signalName;
        private String input;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalWorkflowExecutionRequest model) {
            super(model);
            this.domain(model.domain);
            this.workflowId(model.workflowId);
            this.runId(model.runId);
            this.signalName(model.signalName);
            this.input(model.input);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getSignalName() {
            return this.signalName;
        }

        public final void setSignalName(String signalName) {
            this.signalName = signalName;
        }

        @Override
        public final Builder signalName(String signalName) {
            this.signalName = signalName;
            return this;
        }

        public final String getInput() {
            return this.input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SignalWorkflowExecutionRequest build() {
            return new SignalWorkflowExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SignalWorkflowExecutionRequest> {
        public Builder domain(String var1);

        public Builder workflowId(String var1);

        public Builder runId(String var1);

        public Builder signalName(String var1);

        public Builder input(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

