/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.NamingUtils;

@SdkInternalApi
public class SdkExceptionToV2
extends Recipe {
    public static MethodMatcher v1ExceptionMethod(String methodSignature) {
        return new MethodMatcher("com.amazonaws.AmazonServiceException " + methodSignature, true);
    }

    public String getDisplayName() {
        return "SDK Exceptions Methods to V2";
    }

    public String getDescription() {
        return "SDK Exceptions Methods to V2";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static final class Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            if (SdkExceptionToV2.v1ExceptionMethod("getErrorCode()").matches((MethodCall)method)) {
                String newMethodName = "awsErrorDetails().errorCode()";
                method = NamingUtils.transformMethodName(method, newMethodName, this.getCursor());
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (SdkExceptionToV2.v1ExceptionMethod("getServiceName()").matches((MethodCall)method)) {
                String newMethodName = "awsErrorDetails().serviceName()";
                method = NamingUtils.transformMethodName(method, newMethodName, this.getCursor());
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (SdkExceptionToV2.v1ExceptionMethod("getErrorMessage()").matches((MethodCall)method)) {
                String newMethodName = "awsErrorDetails().errorMessage()";
                method = NamingUtils.transformMethodName(method, newMethodName, this.getCursor());
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (SdkExceptionToV2.v1ExceptionMethod("getStatusCode()").matches((MethodCall)method)) {
                String newMethodName = "awsErrorDetails().sdkHttpResponse().statusCode()";
                method = NamingUtils.transformMethodName(method, newMethodName, this.getCursor());
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (SdkExceptionToV2.v1ExceptionMethod("getHttpHeaders()").matches((MethodCall)method)) {
                String newMethodName = "awsErrorDetails().sdkHttpResponse().headers()";
                method = NamingUtils.transformMethodName(method, newMethodName, this.getCursor());
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (SdkExceptionToV2.v1ExceptionMethod("getRawResponse()").matches((MethodCall)method)) {
                String newMethodName = "awsErrorDetails().rawResponse().asByteArray()";
                method = NamingUtils.transformMethodName(method, newMethodName, this.getCursor());
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (SdkExceptionToV2.v1ExceptionMethod("getRawResponseContent()").matches((MethodCall)method)) {
                String newMethodName = "awsErrorDetails().rawResponse().asUtf8String()";
                method = NamingUtils.transformMethodName(method, newMethodName, this.getCursor());
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            return super.visitMethodInvocation(method, (Object)executionContext);
        }
    }
}

