/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class WrapSdkClientBuilderRegionStr
extends Recipe {
    public String getDisplayName() {
        return "Wrap the region string provided on the SDK client builder with Region.of";
    }

    public String getDescription() {
        return "Wrap the region string provided on the SDK client builder with Region.of.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new V1GetterToV2Visitor();
    }

    private static class V1GetterToV2Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private V1GetterToV2Visitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation originalMethod, ExecutionContext executionContext) {
            J.MethodInvocation method = super.visitMethodInvocation(originalMethod, (Object)executionContext);
            if (!V1GetterToV2Visitor.isSdkClientBuilder(method)) {
                return method;
            }
            String methodName = method.getSimpleName();
            if (!methodName.equals("region")) {
                return method;
            }
            JavaType.Method methodType = method.getMethodType();
            if (methodType == null) {
                return method;
            }
            List parameterTypes = methodType.getParameterTypes();
            if (parameterTypes.size() != 1 || !TypeUtils.isString((JavaType)((JavaType)parameterTypes.get(0)))) {
                return method;
            }
            String regionFqcn = Region.class.getCanonicalName();
            JavaTemplate template = JavaTemplate.builder((String)"Region.of(#{any()})").imports(new String[]{"software.amazon.awssdk.regions.Region"}).build();
            this.maybeAddImport(regionFqcn, false);
            ArrayList arguments = new ArrayList(method.getArguments());
            method = (J.MethodInvocation)template.apply(this.updateCursor((Tree)method), method.getCoordinates().replaceArguments(), arguments.toArray(new Object[0]));
            this.autoFormat((J)method, executionContext);
            return method;
        }

        private static boolean isSdkClientBuilder(J.MethodInvocation method) {
            return Optional.ofNullable(method.getMethodType()).map(mt -> mt.getReturnType()).filter(t -> SdkTypeUtils.isV2ClientClass(t)).isPresent();
        }
    }
}

