/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import software.amazon.dax.Configuration;
import software.amazon.dax.InternalConfiguration;
import software.amazon.dax.channel.AuthHandler;
import software.amazon.dax.channel.ChannelInitHandler;
import software.amazon.dax.channel.FrameHandler;
import software.amazon.dax.channel.IdleConnectionReaperHandler;
import software.amazon.dax.channel.OldConnectionReaperHandler;
import software.amazon.dax.channel.StatusCodeHandler;
import software.amazon.dax.channel.UnusedChannelExceptionHandler;

public class ChannelPipelineInitializer
extends AbstractChannelPoolHandler {
    private final SslContext sslCtx;
    private final SslProvider sslProvider;
    private final Configuration configuration;
    private final InternalConfiguration internalConfiguration;
    private final String host;
    private final int port;
    private final ChannelCounter channelCounter;
    private final ChannelHandler authHandler;

    public ChannelPipelineInitializer(SslContext sslCtx, SslProvider sslProvider, Configuration configuration, InternalConfiguration internalConfiguration) {
        this.sslCtx = sslCtx;
        this.sslProvider = sslProvider;
        this.configuration = configuration;
        this.internalConfiguration = internalConfiguration;
        this.host = configuration.host();
        this.port = configuration.port();
        this.channelCounter = new ChannelCounter();
        this.authHandler = new AuthHandler(configuration.credentialsProvider(), configuration.region().id(), internalConfiguration.userAgent());
    }

    public void channelCreated(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{this.channelCounter});
        if (this.sslCtx != null) {
            SslHandler sslHandler = this.newSslHandler(this.sslCtx, ch.alloc(), this.host, this.port);
            pipeline.addLast(new ChannelHandler[]{sslHandler});
            if (this.sslProvider == SslProvider.JDK) {
                ch.config().setOption(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT);
            }
        }
        if (this.internalConfiguration.needInit()) {
            pipeline.addLast(new ChannelHandler[]{ChannelInitHandler.THE});
        }
        pipeline.addLast(new ChannelHandler[]{new IdleConnectionReaperHandler(this.configuration.idleTimeoutMillis())});
        if (this.configuration.connectionTtlMillis() > 0) {
            pipeline.addLast(new ChannelHandler[]{new OldConnectionReaperHandler(this.configuration.connectionTtlMillis())});
        }
        if (this.internalConfiguration.needFrame()) {
            pipeline.addLast(new ChannelHandler[]{new FrameHandler()});
        }
        pipeline.addLast(new ChannelHandler[]{new StatusCodeHandler(this.internalConfiguration.needStatusCode())});
        if (this.internalConfiguration.needAuth()) {
            pipeline.addLast(new ChannelHandler[]{this.authHandler});
        }
        pipeline.addLast(new ChannelHandler[]{UnusedChannelExceptionHandler.getInstance()});
    }

    public int size() {
        return this.channelCounter.count.get();
    }

    private SslHandler newSslHandler(SslContext sslContext, ByteBufAllocator alloc, String peerHost, int peerPort) {
        SslHandler sslHandler = sslContext.newHandler(alloc, peerHost, peerPort);
        this.configureSslEngine(sslHandler.engine());
        return sslHandler;
    }

    private void configureSslEngine(SSLEngine sslEngine) {
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        if (!this.configuration.skipHostNameVerification()) {
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            if (this.internalConfiguration.dns() != null) {
                sslParameters.setServerNames(Collections.singletonList(new SNIHostName(this.internalConfiguration.dns())));
            }
        }
        sslEngine.setSSLParameters(sslParameters);
    }

    @ChannelHandler.Sharable
    private static class ChannelCounter
    extends ChannelInboundHandlerAdapter {
        private final AtomicInteger count = new AtomicInteger(0);

        private ChannelCounter() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.count.incrementAndGet();
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.count.decrementAndGet();
            super.channelInactive(ctx);
        }
    }
}

