/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.channel;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import software.amazon.dax.channel.ChannelAttributeKey;

public class IdleConnectionReaperHandler
extends IdleStateHandler {
    private final int maxIdleTimeMillis;

    public IdleConnectionReaperHandler(int maxIdleTimeMillis) {
        super(0L, 0L, (long)maxIdleTimeMillis, TimeUnit.MILLISECONDS);
        this.maxIdleTimeMillis = maxIdleTimeMillis;
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent event) {
        assert (ctx.channel().eventLoop().inEventLoop());
        boolean channelNotInUse = Boolean.FALSE.equals(ctx.channel().attr(ChannelAttributeKey.IN_USE).get());
        if (channelNotInUse && ctx.channel().isOpen()) {
            ctx.close();
        }
    }
}

