/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.cluster;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.dax.DaxAsyncClient;
import software.amazon.dax.cluster.Cluster;
import software.amazon.dax.com.amazon.dax.bits.disco.ServiceEndpoint;
import software.amazon.dax.com.amazon.dax.client.HostPort;

abstract class Source
implements Closeable {
    private static final Log LOG = LogFactory.getLog(Source.class);

    Source() {
    }

    public abstract void refresh() throws IOException;

    public static Source autoconf(Cluster c, HostPort seed) {
        if (seed == null) {
            throw new IllegalArgumentException("no configuration seed hosts provided");
        }
        return new AutoconfSource(c, seed);
    }

    static class AutoconfSource
    extends Source {
        private final Cluster cluster;
        private final HostPort seed;
        private Set<ServiceEndpoint> services;

        AutoconfSource(Cluster c, HostPort seed) {
            this.cluster = c;
            this.seed = seed;
        }

        @Override
        public void refresh() throws IOException {
            List<ServiceEndpoint> newCfg = this.pull(this.seed);
            this.checkConfig(newCfg);
        }

        @Override
        public void close() {
        }

        private void checkConfig(List<ServiceEndpoint> newCfg) throws IOException {
            Set<ServiceEndpoint> existing = this.services;
            HashSet<ServiceEndpoint> latest = new HashSet<ServiceEndpoint>(newCfg);
            if (existing != null && existing.equals(latest)) {
                return;
            }
            this.services = latest;
            this.cluster.update(latest);
        }

        private List<ServiceEndpoint> pull(HostPort dest) throws IOException {
            InetAddress[] addrs;
            try {
                addrs = InetAddress.getAllByName(dest.host());
            }
            catch (UnknownHostException ue) {
                IOException ie = new IOException("failed to configure cluster endpoints from hosts: " + dest);
                ie.addSuppressed(ue);
                throw ie;
            }
            return this.pull(addrs, dest);
        }

        List<ServiceEndpoint> pull(InetAddress[] addrs, HostPort dest) throws IOException {
            Throwable e = null;
            if (addrs.length > 1) {
                for (int j = addrs.length - 1; j > 0; --j) {
                    int k = ThreadLocalRandom.current().nextInt(j + 1);
                    InetAddress tmp = addrs[k];
                    addrs[k] = addrs[j];
                    addrs[j] = tmp;
                }
            }
            for (InetAddress ia : addrs) {
                try {
                    List<ServiceEndpoint> newCfg = this.pullFrom(ia, dest.port());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("found endpoint configuration " + newCfg + " from " + ia + ":" + dest.port()));
                    }
                    if (newCfg == null || newCfg.isEmpty()) continue;
                    return newCfg;
                }
                catch (Throwable t) {
                    if (e == null) {
                        e = t;
                        continue;
                    }
                    e.addSuppressed(t);
                }
            }
            IOException ie = new IOException("failed to configure cluster endpoints from hosts: " + dest);
            if (e != null) {
                ie.initCause(e);
            }
            throw ie;
        }

        private List<ServiceEndpoint> pullFrom(InetAddress addr, int port) throws Throwable {
            DaxAsyncClient client = this.cluster.newClient(addr, port, this.cluster.endpointClientConfiguration);
            try {
                List<ServiceEndpoint> list = client.endpoints().join();
                if (client != null) {
                    client.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CompletionException e) {
                    if (e.getCause() != null) {
                        if (e.getCause().getCause() instanceof IOException) {
                            throw e.getCause().getCause();
                        }
                        throw e.getCause();
                    }
                    throw e;
                }
            }
        }
    }
}

