/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.com.amazon.dax;

import java.io.IOException;
import java.io.OutputStream;
import software.amazon.dax.com.amazon.dax.Frame;

public class FramingOutputStream
extends OutputStream {
    private int mEnd;
    private final byte[] mBuffer;
    private final OutputStream mOut;

    public FramingOutputStream(OutputStream out, int size) {
        this.mBuffer = new byte[size + 16];
        this.mEnd = 8;
        this.mOut = out;
    }

    private void ensureBufSpace(int spaceNeeded) throws IOException {
        if (this.mEnd + spaceNeeded > this.mBuffer.length - 8) {
            this.flushBuffer(false);
        }
    }

    private void flushBufferWithExtraBytes(byte[] bs, int offset, int length) throws IOException {
        Frame.castHeader(this.mBuffer, 0, this.mEnd, false);
        Frame.castHeader(this.mBuffer, this.mEnd, 8 + length, false);
        this.mOut.write(this.mBuffer, 0, this.mEnd + 8);
        this.mOut.write(bs, offset, length);
        this.mEnd = 8;
    }

    private void flushBuffer(boolean endOfMessage) throws IOException {
        Frame.castHeader(this.mBuffer, 0, this.mEnd, endOfMessage);
        this.mOut.write(this.mBuffer, 0, this.mEnd);
        this.mEnd = 8;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureBufSpace(1);
        this.mBuffer[this.mEnd++] = (byte)b;
    }

    @Override
    public void write(byte[] bs, int offset, int length) throws IOException {
        if (length > this.mBuffer.length - 16) {
            this.flushBufferWithExtraBytes(bs, offset, length);
        } else {
            this.ensureBufSpace(length);
            System.arraycopy(bs, offset, this.mBuffer, this.mEnd, length);
            this.mEnd += length;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer(true);
        this.mOut.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.mOut.close();
    }
}

