/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.dax.channel.ResponseHandler;
import software.amazon.dax.com.amazon.dax.Constants;
import software.amazon.dax.com.amazon.dax.bits.DaxCborInputStream;
import software.amazon.dax.dynamodb.AttributeValueDecoder;
import software.amazon.dax.dynamodb.DaxResponseDecoder;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.RefreshingCache;
import software.amazon.dax.dynamodb.SimpleCache;
import software.amazon.dax.exceptions.DecoderException;

public class ScanResponseHandler
extends ResponseHandler<ScanResponse> {
    private static final Constants.DaxResponseParam[] RESPONSE_PARAMS = Constants.DaxResponseParam.values();
    private final SimpleCache<Long, List<String>> attrListCache;
    private final RefreshingCache<String, List<AttributeDefinition>> keyCache;
    private final ScanRequest request;
    private AtomicReference<Map<Integer, DocumentPath>> projectionOrdinals;
    private AtomicReference<String> indexName;

    public ScanResponseHandler(CompletableFuture<ScanResponse> completableFuture, RefreshingCache<String, List<AttributeDefinition>> keyCache, SimpleCache<Long, List<String>> attrListCache, AtomicReference<Map<Integer, DocumentPath>> projectionOrdinals, AtomicReference<String> indexName, ScanRequest request) {
        super(completableFuture);
        this.attrListCache = attrListCache;
        this.projectionOrdinals = projectionOrdinals;
        this.keyCache = keyCache;
        this.indexName = indexName;
        this.request = request;
    }

    @Override
    public void decode(DaxCborInputStream in, CompletableFuture<ScanResponse> completableFuture) throws Exception {
        ScanResponse.Builder response = ScanResponse.builder();
        if (this.request.returnConsumedCapacity() != null && !this.request.returnConsumedCapacity().equals((Object)ReturnConsumedCapacity.NONE)) {
            response.consumedCapacity(DaxResponseDecoder.newZeroConsumedCapacity(this.request.tableName()));
        }
        if (in.tryReadNull()) {
            completableFuture.complete((ScanResponse)response.build());
            return;
        }
        this.keyCache.get(this.request.tableName()).whenComplete((keys, e) -> {
            if (e != null) {
                completableFuture.completeExceptionally((Throwable)e);
            } else {
                try {
                    this.decodeScanResponse(in, response, (List<AttributeDefinition>)keys, completableFuture);
                }
                catch (Exception exception) {
                    completableFuture.completeExceptionally(exception);
                }
            }
        });
    }

    private void decodeScanResponse(DaxCborInputStream in, ScanResponse.Builder response, List<AttributeDefinition> keys, CompletableFuture<ScanResponse> completableFuture) throws IOException {
        if (in.fieldType() == 191) {
            in.consumeField();
            ArrayList<List<AttributeValue>> anonAttributeValues = new ArrayList<List<AttributeValue>>();
            ArrayList<Long> attributeListIds = new ArrayList<Long>();
            ArrayList<Map<String, AttributeValue>> items = new ArrayList<Map<String, AttributeValue>>();
            block7: while (in.fieldType() != 255) {
                int mapKey = in.readInt();
                switch (RESPONSE_PARAMS[mapKey]) {
                    case Items: {
                        AttributeValueDecoder.decodeAnonymousItems(in, keys, this.projectionOrdinals.get(), items, anonAttributeValues, attributeListIds);
                        continue block7;
                    }
                    case ConsumedCapacity: {
                        response.consumedCapacity(DaxResponseDecoder.decodeConsumedCapacity(in));
                        continue block7;
                    }
                    case Count: {
                        response.count(Integer.valueOf(in.readInt()));
                        continue block7;
                    }
                    case ScannedCount: {
                        response.scannedCount(Integer.valueOf(in.readInt()));
                        continue block7;
                    }
                    case LastEvaluatedKey: {
                        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
                        if (this.indexName.get() == null) {
                            AttributeValueDecoder.decodeKey(in, keys, key);
                        } else {
                            AttributeValueDecoder.decodeCompoundKey(in, key);
                        }
                        response.lastEvaluatedKey(key.size() > 0 ? key : null);
                        continue block7;
                    }
                }
                throw new DecoderException("Unknown value type: " + mapKey);
            }
            in.consumeField();
            CompletableFuture[] futures = new CompletableFuture[attributeListIds.size()];
            for (int i = 0; i < attributeListIds.size(); ++i) {
                int index = i;
                futures[index] = this.attrListCache.get((Long)attributeListIds.get(i)).thenApply(attrNames -> {
                    try {
                        AttributeValueDecoder.deanonymizeAttributeValues((Map)items.get(index), attrNames, (List)anonAttributeValues.get(index));
                    }
                    catch (Exception ex) {
                        throw new CompletionException(ex);
                    }
                    return null;
                });
            }
            CompletableFuture.allOf(futures).whenComplete((placeholder, ex) -> {
                if (ex != null) {
                    completableFuture.completeExceptionally((Throwable)ex);
                } else {
                    response.items((Collection)items);
                    completableFuture.complete((ScanResponse)response.build());
                }
            });
        }
    }
}

