/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.dax.channel.ChannelAttributeKey;
import software.amazon.dax.channel.RequestContext;
import software.amazon.dax.channel.ResponseHandler;
import software.amazon.dax.dynamodb.SimpleCache;
import software.amazon.dax.exceptions.ExceptionHandler;

public abstract class TransactionResponseHandler<T>
extends ResponseHandler<T> {
    private final AtomicReference<List<Map<String, AttributeValue>>> keysPerRequest;
    private final SimpleCache<Long, List<String>> attrListCache;

    public TransactionResponseHandler(CompletableFuture completableFuture, AtomicReference<List<Map<String, AttributeValue>>> keysPerRequest, SimpleCache<Long, List<String>> attrListCache) {
        super(completableFuture);
        this.keysPerRequest = keysPerRequest;
        this.attrListCache = attrListCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        RequestContext requestContext = (RequestContext)ctx.channel().attr(ChannelAttributeKey.REQUEST_CONTEXT_KEY).get();
        try {
            ExceptionHandler.handleTransactionException(this.getCompletableFuture(), cause, ctx.channel(), this.keysPerRequest.get(), this.attrListCache);
        }
        finally {
            requestContext.channelPool().release(ctx.channel());
        }
    }
}

