/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.channel;

import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPool;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import software.amazon.dax.channel.ChannelAttributeKey;
import software.amazon.dax.channel.RequestEncoder;
import software.amazon.dax.channel.ResponseHandler;
import software.amazon.dax.utils.NettyUtils;

class HandlerRemovingChannelPool
implements ChannelPool {
    private final ChannelPool delegatePool;

    HandlerRemovingChannelPool(ChannelPool delegatePool) {
        this.delegatePool = delegatePool;
    }

    public Future<Channel> acquire() {
        return this.delegatePool.acquire();
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        return this.delegatePool.acquire(promise);
    }

    public Future<Void> release(Channel channel) {
        this.removePerRequestHandlers(channel);
        return this.delegatePool.release(channel);
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        this.removePerRequestHandlers(channel);
        return this.delegatePool.release(channel, promise);
    }

    public void close() {
        this.delegatePool.close();
    }

    private void removePerRequestHandlers(Channel channel) {
        channel.attr(ChannelAttributeKey.IN_USE).set((Object)false);
        if (channel.isOpen() || channel.isRegistered()) {
            NettyUtils.removeIfExists(channel.pipeline(), ResponseHandler.class, RequestEncoder.class, ReadTimeoutHandler.class, WriteTimeoutHandler.class);
        }
    }
}

